/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.cache;

import cn.yto.config.WcsTcpServerConfig;
import cn.yto.entity.monitor.TExpOperationTable;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.mapper.ExpOperationTableMapper;
import cn.yto.utils.ExpUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class OperationTableCacheService {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private ExpOperationTableMapper mapper;
    @Autowired
    private WcsTcpServerConfig wcsTcpServerConfig;
    public static Map<String, TExpOperationTable> operationTableCaches = new ConcurrentHashMap<String, TExpOperationTable>();
    public static Map<String, TExpOperationTable> operationIpCaches = new ConcurrentHashMap<String, TExpOperationTable>();

    public void refreshOperationTableCache() {
        String wcsIpPort = this.wcsTcpServerConfig.getWcsIp() + ":" + this.wcsTcpServerConfig.getWcsTcpPort();
        Long start = System.currentTimeMillis();
        try {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TExpOperationTable::getDelFlag, (Object)"0")).isNotNull(TExpOperationTable::getOperationMac);
            List list = this.mapper.selectList((Wrapper)queryWrapper);
            Map<String, TExpOperationTable> operationTableMap = list.stream().collect(Collectors.toMap(TExpOperationTable::getOperationMac, e -> e, (k1, k2) -> k2));
            Map<String, TExpOperationTable> operationIpCaches = list.stream().collect(Collectors.toMap(TExpOperationTable::getOperationIp, e -> e, (k1, k2) -> k2));
            operationTableCaches = operationTableMap;
            OperationTableCacheService.operationIpCaches = operationIpCaches;
            logger.info("\u5237\u65b0\u5f53\u524d\u64cd\u4f5c\u53f0\u7f13\u5b58\u6210\u529f\uff0c\u53ef\u7528\u64cd\u4f5c\u53f0:{}\u4e2a,\u8017\u65f6:{}", (Object)operationTableCaches.size(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e2) {
            logger.error("\u5237\u65b0\u5f53\u524d\u64cd\u4f5c\u53f0\u7f13\u5b58", (Throwable)e2);
        }
    }

    public TExpOperationTable getOperationTableByMac(String mac) {
        if (ExpUtils.isBlank(mac)) {
            return null;
        }
        TExpOperationTable tExpOperationTable = operationTableCaches.get(mac);
        if (Objects.nonNull(tExpOperationTable)) {
            return tExpOperationTable;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TExpOperationTable::getDelFlag, (Object)"0")).eq(TExpOperationTable::getOperationMac, (Object)mac);
        List list = this.mapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        operationTableCaches.put(mac, (TExpOperationTable)list.get(0));
        return (TExpOperationTable)list.get(0);
    }

    public TExpOperationTable getOperationTableByIp(String ip) {
        if (ExpUtils.isBlank(ip)) {
            return null;
        }
        TExpOperationTable tExpOperationTable = operationTableCaches.get(ip);
        if (Objects.nonNull(tExpOperationTable)) {
            return tExpOperationTable;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(TExpOperationTable::getDelFlag, (Object)"0")).eq(TExpOperationTable::getOperationIp, (Object)ip);
        List list = this.mapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        operationIpCaches.put(ip, (TExpOperationTable)list.get(0));
        return (TExpOperationTable)list.get(0);
    }
}

