/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.communication.business.receive;

import cn.yto.cache.LatticeBindCacheService;
import cn.yto.cache.LatticeStatusCacheService;
import cn.yto.config.SortingConfig;
import cn.yto.entity.BaseResponse;
import cn.yto.entity.ExpLatticeBindEntity;
import cn.yto.entity.LatticeLockRecord;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.plc.PlcGateWayClient;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.server.plc.PlcGateWay;
import cn.yto.netty.utils.MessageUtils;
import cn.yto.service.lattice.LatticeBindService;
import cn.yto.service.lattice.LatticeLockService;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import cn.yto.utils.SortIdUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiveLatticeBindComm {
    @Autowired
    private PlcGateWayClient plcGateWayClient;
    @Autowired
    private LatticeBindService latticeBindService;
    @Autowired
    private LatticeBindCacheService latticeBindCacheService;
    @Autowired
    private LatticeLockService latticeLockService;
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    private PlcGateWay plcGateWay;
    private static final Logger logger = CustomLoggerFactory.OperateLogger();

    public BaseResponse procBusinessBindPackageReq(JSONObject jsonObject, SocketClientObj socketClientObj) {
        BaseResponse<ExpLatticeBindEntity> response = new BaseResponse<ExpLatticeBindEntity>();
        response.setCode("000");
        response.setMsg("\u6210\u529f");
        String waybillNo = jsonObject.getString("Waybill_NO");
        String latticeNo = jsonObject.getString("Lattice");
        String employeeNo = jsonObject.getString("Employee_NO");
        String chipNo = jsonObject.getString("chipNo");
        String bindTime = jsonObject.getString("Time");
        if (ExpUtils.isBlank(latticeNo)) {
            response.setCode("100");
            response.setMsg("LatticeNo\u4e3a\u7a7a,\u4e0d\u53d1\u9001plc\u89e3\u9501\u6307\u4ee4");
            return response;
        }
        ExpLatticeBindEntity latticeBindEntity = new ExpLatticeBindEntity();
        latticeBindEntity.setChipNo(chipNo);
        latticeBindEntity.setCreateTime(DateUtil.formatDate(bindTime, "yyyy-MM-dd HH:mm:ss.SSS"));
        latticeBindEntity.setLatticeNo(latticeNo);
        latticeBindEntity.setBindUserCode(employeeNo);
        latticeBindEntity.setPackageNo(waybillNo);
        String msgType = "LOCK";
        String devNo = "1";
        String sortId = SortIdUtils.genBindPackageSortId(devNo, latticeNo);
        String unLockMsg = MessageUtils.buildResponseStr(sortId, msgType, devNo, latticeNo, "0");
        if ("1".equals(this.sortingConfig.getMasterWcs())) {
            Long lockTime = null;
            try {
                lockTime = LatticeStatusCacheService.lockStatusCache.get(Integer.parseInt(latticeNo));
            }
            catch (Exception e) {
                logger.info("\u683c\u53e3\u53f7\u683c\u53e3\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
            this.plcGateWay.sendMsg(unLockMsg, devNo);
            this.latticeBindService.insertOrUpdate(latticeBindEntity);
            LatticeLockRecord latticeLockRecord = new LatticeLockRecord();
            if (Objects.nonNull(lockTime)) {
                latticeLockRecord.setLatticeLockTime(new Date(lockTime));
            }
            latticeLockRecord.setLatticeNo(latticeNo);
            latticeLockRecord.setLatticeUnlockTime(new Date());
            latticeLockRecord.setStatus("0");
            latticeLockRecord.setMode(1);
            this.latticeLockService.sendLatticeUnlockToMonitor(latticeLockRecord, latticeBindEntity);
        } else {
            logger.info("\u975e\u4e3b\u63a7PLC\uff0c\u4e0d\u53d1\u9001\u89e3\u9501\u62a5\u6587");
        }
        this.latticeBindCacheService.updateLatticeBindCache(latticeNo, latticeBindEntity);
        response.setData(latticeBindEntity);
        return response;
    }
}

