/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.communication.business.send;

import cn.yto.cache.DeviceRecordCacheService;
import cn.yto.cache.NewLatticeCacheService;
import cn.yto.communication.business.BusinessGateWayComm;
import cn.yto.config.SortingConfig;
import cn.yto.constants.MtyEnum;
import cn.yto.constants.SortingStatusEnum;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.busigateway.request.OptInAndOutReq;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.GateWay;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendOptInComm
extends BusinessGateWayComm {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    private GateWay gateWay;

    @Override
    public void reqBusinessGateway(DeviceSortRecord deviceSortRecord) {
        OptInAndOutReq optInAndOutReq = new OptInAndOutReq();
        optInAndOutReq.setCreateTime(DateUtil.formatYMDHMSS(deviceSortRecord.getCameraTime()));
        optInAndOutReq.setAuxCode("NEW");
        optInAndOutReq.setWaybillNo(deviceSortRecord.getWaybillNo());
        optInAndOutReq.setSignature("123");
        optInAndOutReq.setTxId(deviceSortRecord.getItemKey());
        optInAndOutReq.setMty(MtyEnum.AUTO_DEVICE_OPT_IN.getKey());
        optInAndOutReq.setDestOrgCode(deviceSortRecord.getDestOrgCode());
        if (ExpUtils.isNotBlank(deviceSortRecord.getLatticeNo())) {
            optInAndOutReq.setLatticeNo(deviceSortRecord.getLatticeNo());
        } else {
            logger.info("\u4f9b\u4ef6\u65f6\u65e0\u683c\u53e3\u4fe1\u606f,\u4f7f\u7528\u5f02\u5e38\u53e3:{}", (Object)this.sortingConfig.getPhysicalLattice());
            optInAndOutReq.setLatticeNo(this.sortingConfig.getPhysicalLattice());
        }
        if (ExpUtils.isNotBlank(deviceSortRecord.getSchemeNo())) {
            optInAndOutReq.setSchemeId(deviceSortRecord.getSchemeNo());
        } else if (NewLatticeCacheService.currentScheme != null) {
            String schemeId = NewLatticeCacheService.currentScheme.getSchemeId();
            logger.info("\u5355\u53f7:{},\u91c7\u7528\u5f53\u524d\u542f\u7528\u7684\u683c\u53e3\u65b9\u6848Id:{}", (Object)deviceSortRecord.getWaybillNo(), (Object)schemeId);
            optInAndOutReq.setSchemeId(schemeId);
            deviceSortRecord.setSchemeNo(schemeId);
        }
        optInAndOutReq.setCreateUserCode(deviceSortRecord.getCreateUserCode());
        optInAndOutReq.setAutoDeviceNo("123");
        optInAndOutReq.setContainerNo(ExpUtils.isBlank(deviceSortRecord.getContainerNo()) ? this.getOtherContainer(deviceSortRecord.getCreateOrgCode()) : deviceSortRecord.getContainerNo());
        optInAndOutReq.setMac(deviceSortRecord.getTableMac());
        optInAndOutReq.setLatticeThreeCode(deviceSortRecord.getLatticeThreeCode());
        optInAndOutReq.setWeight(deviceSortRecord.getWeight());
        if (this.sortingConfig.getDynamicScale() == 1) {
            optInAndOutReq.setExtend4("1");
        }
        optInAndOutReq.setLatticeOrgCode(deviceSortRecord.getLatticeOrgCode());
        optInAndOutReq.setDestOrgCode(deviceSortRecord.getDestOrgCode());
        optInAndOutReq.setSchemeId(deviceSortRecord.getSchemeNo());
        optInAndOutReq.setLatticeNo(deviceSortRecord.getLatticeNo());
        optInAndOutReq.setLatticeThreeCode(deviceSortRecord.getLatticeThreeCode());
        optInAndOutReq.setDaTouBi(deviceSortRecord.getThreeCode());
        optInAndOutReq.setEmpCode(deviceSortRecord.getEmpCode());
        optInAndOutReq.setExtend2(deviceSortRecord.getExtend2());
        String inJsonStr = JSONObject.toJSONString((Object)optInAndOutReq);
        try {
            int len = inJsonStr.getBytes("GBK").length;
            String inJsonStrMsg = AdapterHelperUtil.renewItem(String.valueOf(len), 8) + inJsonStr;
            logger.info("\u53d1\u9001\u4f9b\u4ef6\u62a5\u6587:{}", (Object)inJsonStrMsg);
            boolean success = this.sendMsg(2, inJsonStrMsg);
            if (!success) {
                logger.info("\u4f9b\u4ef6\u53d1\u9001\u5931\u8d25:{}", (Object)inJsonStrMsg);
                deviceSortRecord.setStatus(SortingStatusEnum.STATUS_OFFLINE.getCode());
                deviceSortRecord.setStatusMsg(SortingStatusEnum.STATUS_OFFLINE.getMessage());
                deviceSortRecord.setRecordType("1");
                this.deviceSortRecordService.insertDeviceSortRecord(deviceSortRecord);
            }
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u4f9b\u4ef6\u62a5\u6587\u65f6\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void respBusinessGateway(JSONObject jsonObject) {
        logger.info("\u6536\u5230\u4f9b\u4ef6\u56de\u590d:{}", (Object)jsonObject.toString());
        String code = jsonObject.getString("code");
        String message = jsonObject.getString("msg");
        JSONObject data = jsonObject.getJSONObject("data");
        if (Objects.isNull(data)) {
            return;
        }
        String txId = data.getString("txId");
        String waybillNo = data.getString("waybillNo");
        if (ExpUtils.isBlank(txId)) {
            return;
        }
        if (!txId.contains("_") && txId.length() != 18) {
            return;
        }
        String serverTime = data.getString("serverTime");
        DeviceSortRecord deviceSortRecord = null;
        deviceSortRecord = this.sortingConfig.topScan() ? DeviceRecordCacheService.cartWaybillNoCache.get(txId) : DeviceRecordCacheService.supplyRecordItemKeyCache.get(txId);
        if (Objects.isNull(deviceSortRecord)) {
            logger.info("\u6839\u636ewaybillNo:{},itemKey:{},\u672a\u4ece\u7f13\u5b58\u67e5\u5230\u8bb0\u5f55", (Object)waybillNo, (Object)txId);
            List<DeviceSortRecord> records = this.deviceSortRecordService.selectDeviceSortRecordList(waybillNo, null, txId, Arrays.asList(SortingStatusEnum.STATUS_SUPPLY_FAILED.getCode(), SortingStatusEnum.STATUS_OFFLINE.getCode()));
            if (CollectionUtils.isEmpty(records)) {
                logger.info("\u6839\u636ewaybillNo:{},itemKey:{},\u672a\u4ece\u6570\u636e\u5e93\u67e5\u5230\u8bb0\u5f55", (Object)waybillNo, (Object)txId);
                return;
            }
            deviceSortRecord = records.get(0);
        }
        deviceSortRecord.setRecordType("1");
        boolean needDeleteFailRecord = false;
        boolean needUpdateFailRecord = false;
        if (SortingStatusEnum.STATUS_SUPPLY_FAILED.getCode() == deviceSortRecord.getStatus() || SortingStatusEnum.STATUS_OFFLINE.getCode() == deviceSortRecord.getStatus()) {
            if (Objects.isNull(deviceSortRecord.getRetryCount())) {
                deviceSortRecord.setRetryCount(1);
            } else {
                deviceSortRecord.setRetryCount(deviceSortRecord.getRetryCount() + 1);
            }
            logger.info("\u5355\u53f7:{},\u4f9b\u4ef6\u8bb0\u5f55\u8865\u4f20,\u8865\u4f20\u6b21\u6570:{}", (Object)deviceSortRecord.getWaybillNo(), (Object)deviceSortRecord.getRetryCount());
            needUpdateFailRecord = true;
            deviceSortRecord.setModifyTime(new Date());
        } else {
            deviceSortRecord.setCreateTime(new Date());
        }
        if ("000".equals(code)) {
            deviceSortRecord.setStatusMsg(SortingStatusEnum.STATUS_SUPPLY_SUCCESS.getMessage());
            deviceSortRecord.setStatus(SortingStatusEnum.STATUS_SUPPLY_SUCCESS.getCode());
            deviceSortRecord.setInGenMsg(message);
            deviceSortRecord.setInGenStatus(code);
            needDeleteFailRecord = true;
        } else {
            deviceSortRecord.setStatusMsg(SortingStatusEnum.STATUS_SUPPLY_FAILED.getMessage());
            deviceSortRecord.setStatus(SortingStatusEnum.STATUS_SUPPLY_FAILED.getCode());
            deviceSortRecord.setInGenMsg(message);
            deviceSortRecord.setInGenStatus(code);
        }
        if (this.sortingConfig.topScan()) {
            DeviceSortRecord waybillNoRecord = DeviceRecordCacheService.waybillNoThreeCodeCache.get(waybillNo);
            waybillNoRecord.setInGenStatus(code);
            DeviceRecordCacheService.waybillNoThreeCodeCache.put(waybillNo, waybillNoRecord);
        }
        if (needUpdateFailRecord) {
            this.deviceSortRecordService.updateById(deviceSortRecord);
        } else {
            this.deviceSortRecordService.insertDeviceSortRecord(deviceSortRecord);
        }
    }

    public static void main(String[] args) {
        System.out.println("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000".length());
    }
}

