/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.communication.business.send;

import cn.yto.cache.DeviceRecordCacheService;
import cn.yto.cache.LatticeBindCacheService;
import cn.yto.cache.NewLatticeCacheService;
import cn.yto.communication.business.BusinessGateWayComm;
import cn.yto.constants.MtyEnum;
import cn.yto.constants.SortingStatusEnum;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.busigateway.request.OptInAndOutReq;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.GateWay;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SendOptOutComm
extends BusinessGateWayComm {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    @Autowired
    private GateWay gateWay;
    @Autowired
    private LatticeBindCacheService latticeBindCacheService;

    @Override
    public void reqBusinessGateway(DeviceSortRecord deviceSortRecord) {
        OptInAndOutReq optInAndOutReq = new OptInAndOutReq();
        if (Objects.isNull(deviceSortRecord.getLatticeTime())) {
            optInAndOutReq.setCreateTime(DateUtil.formatYMDHMSS(new Date()));
        } else {
            try {
                String createTime = DateUtil.formatYMDHMSS(deviceSortRecord.getLatticeTime());
                optInAndOutReq.setCreateTime(createTime);
            }
            catch (Exception e) {
                optInAndOutReq.setCreateTime(DateUtil.formatYMDHMSS(new Date()));
            }
        }
        optInAndOutReq.setAuxCode("NEW");
        optInAndOutReq.setWaybillNo(deviceSortRecord.getWaybillNo());
        optInAndOutReq.setSignature("123");
        optInAndOutReq.setDestOrgCode(deviceSortRecord.getDestOrgCode());
        optInAndOutReq.setLatticeNo(deviceSortRecord.getLatticeNoReal());
        if (ExpUtils.isNotBlank(deviceSortRecord.getExtend2())) {
            optInAndOutReq.setExtend2(deviceSortRecord.getExtend2());
        }
        if (ExpUtils.isNotBlank(deviceSortRecord.getSchemeNo())) {
            optInAndOutReq.setSchemeId(deviceSortRecord.getSchemeNo());
        } else if (NewLatticeCacheService.currentScheme != null) {
            String schemeId = NewLatticeCacheService.currentScheme.getSchemeId();
            logger.info("\u5355\u53f7:{},\u91c7\u7528\u5f53\u524d\u542f\u7528\u7684\u683c\u53e3\u65b9\u6848Id:{}", (Object)deviceSortRecord.getWaybillNo(), (Object)schemeId);
            optInAndOutReq.setSchemeId(schemeId);
            deviceSortRecord.setSchemeNo(schemeId);
        }
        optInAndOutReq.setCreateUserCode(deviceSortRecord.getLatticeBindUserCode());
        optInAndOutReq.setAutoDeviceNo("123");
        optInAndOutReq.setContainerNo(deviceSortRecord.getContainerNo());
        optInAndOutReq.setMac(deviceSortRecord.getTableMac());
        optInAndOutReq.setLatticeThreeCode(deviceSortRecord.getLatticeThreeCode());
        optInAndOutReq.setWeight(deviceSortRecord.getWeight());
        optInAndOutReq.setMty(MtyEnum.AUTO_DEVICE_OPT_OUT.getKey());
        optInAndOutReq.setTxId(deviceSortRecord.getItemKey());
        optInAndOutReq.setCartNo(deviceSortRecord.getLayer() + "-" + deviceSortRecord.getCartNo());
        String outJsonStr = JSONObject.toJSONString((Object)optInAndOutReq);
        try {
            int len = outJsonStr.getBytes("GBK").length;
            String outJsonStrMsg = AdapterHelperUtil.renewItem(String.valueOf(len), 8) + outJsonStr;
            logger.info("\u53d1\u9001\u843d\u683c\u62a5\u6587:{}", (Object)outJsonStrMsg);
            boolean success = this.sendMsg(3, outJsonStrMsg);
            if (!success) {
                logger.info("\u843d\u683c\u53d1\u9001\u5931\u8d25:{}", (Object)outJsonStrMsg);
                deviceSortRecord.setStatus(SortingStatusEnum.STATUS_OFFLINE.getCode());
                deviceSortRecord.setStatusMsg(SortingStatusEnum.STATUS_OFFLINE.getMessage());
                deviceSortRecord.setRecordType("2");
                this.deviceSortRecordService.insertDeviceSortRecord(deviceSortRecord);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void respBusinessGateway(JSONObject jsonObject) {
        logger.info("\u6536\u5230\u843d\u683c\u56de\u590d:{}", (Object)jsonObject.toString());
        String code = jsonObject.getString("code");
        String message = jsonObject.getString("msg");
        JSONObject data = jsonObject.getJSONObject("data");
        if (Objects.isNull(data)) {
            return;
        }
        String txId = data.getString("txId");
        String waybillNo = data.getString("waybillNo");
        if (ExpUtils.isBlank(txId)) {
            return;
        }
        if (!txId.contains("_") && txId.length() != 18) {
            return;
        }
        String serverTime = data.getString("serverTime");
        DeviceSortRecord deviceSortRecord = DeviceRecordCacheService.cartWaybillNoCache.get(txId);
        if (Objects.isNull(deviceSortRecord)) {
            logger.info("\u6839\u636ewaybillNo:{},itemKey:{},\u672a\u4ece\u7f13\u5b58\u67e5\u5230\u8bb0\u5f55", (Object)waybillNo, (Object)txId);
            List<DeviceSortRecord> records = this.deviceSortRecordService.selectDeviceSortRecordList(waybillNo, null, txId, Arrays.asList(SortingStatusEnum.STATUS_LUOJIAN_FAILED.getCode(), SortingStatusEnum.STATUS_OFFLINE.getCode()));
            if (CollectionUtils.isEmpty(records)) {
                return;
            }
            deviceSortRecord = records.get(0);
        }
        boolean needDeleteFailRecord = false;
        boolean needUpdateFailRecord = false;
        if (SortingStatusEnum.STATUS_LUOJIAN_FAILED.getCode() == deviceSortRecord.getStatus() || SortingStatusEnum.STATUS_OFFLINE.getCode() == deviceSortRecord.getStatus()) {
            if (Objects.isNull(deviceSortRecord.getRetryCount())) {
                deviceSortRecord.setRetryCount(1);
            } else {
                deviceSortRecord.setRetryCount(deviceSortRecord.getRetryCount() + 1);
            }
            logger.info("\u5355\u53f7:{},\u843d\u683c\u8bb0\u5f55\u8865\u4f20,\u8865\u4f20\u6b21\u6570:{}", (Object)deviceSortRecord.getWaybillNo(), (Object)deviceSortRecord.getRetryCount());
            deviceSortRecord.setModifyTime(new Date());
            needUpdateFailRecord = true;
        } else {
            deviceSortRecord.setCreateTime(new Date());
        }
        if ("000".equals(code)) {
            deviceSortRecord.setStatusMsg(SortingStatusEnum.STATUS_LUOJIAN_SUCCESS.getMessage());
            deviceSortRecord.setStatus(SortingStatusEnum.STATUS_LUOJIAN_SUCCESS.getCode());
            deviceSortRecord.setOutGenMsg(message);
            deviceSortRecord.setOutGenStatus(code);
            needDeleteFailRecord = true;
        } else {
            deviceSortRecord.setStatusMsg(SortingStatusEnum.STATUS_LUOJIAN_FAILED.getMessage());
            deviceSortRecord.setStatus(SortingStatusEnum.STATUS_LUOJIAN_FAILED.getCode());
            deviceSortRecord.setOutGenMsg(message);
            deviceSortRecord.setOutGenStatus(code);
        }
        deviceSortRecord.setRecordType("2");
        if (needUpdateFailRecord) {
            this.deviceSortRecordService.updateById(deviceSortRecord);
        } else {
            this.deviceSortRecordService.insertDeviceSortRecord(deviceSortRecord);
        }
        DeviceRecordCacheService.cartWaybillNoCache.remove(txId);
    }
}

