/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.communication.business.send;

import cn.yto.cache.LatticeCacheService;
import cn.yto.communication.business.BusinessGateWayComm;
import cn.yto.constants.MtyEnum;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.busigateway.request.OptCommonReq;
import cn.yto.entity.busigateway.response.OptSchemeQueryData;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.DateTimeSynchronizeUtil;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SendOptSchemeComm
extends BusinessGateWayComm {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();

    @Override
    public void reqBusinessGateway(DeviceSortRecord deviceSortRecord) {
        OptCommonReq optCommonReq = new OptCommonReq();
        optCommonReq.setMty(MtyEnum.AUTO_DEVICE_OPT_SCHEME_QUERY.getKey());
        optCommonReq.setTxId(MtyEnum.AUTO_DEVICE_OPT_SCHEME_QUERY.getKey());
        optCommonReq.setSignature("123");
        optCommonReq.setCreateTime(DateUtil.formatYMDHMSS(new Date()));
        String jsonStr = JSONObject.toJSONString((Object)optCommonReq);
        String message = AdapterHelperUtil.renewItem(String.valueOf(jsonStr.length()), 8) + jsonStr;
        this.sendMsg(1, message);
    }

    @Override
    public void respBusinessGateway(JSONObject jsonObject) {
        String code = jsonObject.getString("code");
        String message = jsonObject.getString("msg");
        JSONObject data = jsonObject.getJSONObject("data");
        if ("000".equals(code)) {
            logger.info("\u8bf7\u6c42\u4e09\u6bb5\u7801\u7f51\u5173\u5237\u65b0\u683c\u53e3\u65b9\u6848\u6210\u529f");
            String serverTime = data.getString("serverTime");
            Date date = ExpUtils.parseDateTimeMill(serverTime);
            if (date != null) {
                logger.info("\u5f00\u59cb\u6821\u9a8c\u65f6\u95f4\u540c\u6b65");
                DateTimeSynchronizeUtil.getInstance().dateTimeSynchronize(date);
            }
        } else {
            logger.info("\u8bf7\u6c42\u4e09\u6bb5\u7801\u7f51\u5173\u5237\u65b0\u683c\u53e3\u65b9\u6848\u5931\u8d25,code:{},message:{}", (Object)code, (Object)message);
            return;
        }
        OptSchemeQueryData schemeQueryData = (OptSchemeQueryData)JSON.toJavaObject((JSON)data, OptSchemeQueryData.class);
        LatticeCacheService.updateLatticeScheme(schemeQueryData);
    }
}

