/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.communication.business.send;

import cn.yto.cache.CommonInfo;
import cn.yto.cache.GatewayInfoCacheService;
import cn.yto.communication.business.BusinessGateWayComm;
import cn.yto.constants.MtyEnum;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.busigateway.request.OptCommonReq;
import cn.yto.entity.busigateway.response.OptSystemQueryData;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SendOptSystemComm
extends BusinessGateWayComm {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();

    @Override
    public void reqBusinessGateway(DeviceSortRecord deviceSortRecord) {
        OptCommonReq optCommonReq = new OptCommonReq();
        optCommonReq.setMty(MtyEnum.AUTO_DEVICE_SYSTEM_QUERY.getKey());
        optCommonReq.setTxId(MtyEnum.AUTO_DEVICE_SYSTEM_QUERY.getKey());
        optCommonReq.setSignature("123");
        optCommonReq.setCreateTime(DateUtil.formatYMDHMSS(new Date()));
        String jsonStr = JSONObject.toJSONString((Object)optCommonReq);
        String message = AdapterHelperUtil.renewItem(String.valueOf(jsonStr.length()), 8) + jsonStr;
        this.sendMsg(Integer.parseInt(deviceSortRecord.getExtend1()), message);
    }

    @Override
    public void respBusinessGateway(JSONObject jsonObject) {
        String code = jsonObject.getString("code");
        String message = jsonObject.getString("msg");
        String type = jsonObject.getString("type");
        JSONObject data = jsonObject.getJSONObject("data");
        if ("000".equals(code)) {
            logger.info("\u8bf7\u6c42\u7f51\u5173\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\u6210\u529f");
            OptSystemQueryData schemeQueryData = (OptSystemQueryData)JSON.toJavaObject((JSON)data, OptSystemQueryData.class);
            if (Objects.nonNull(schemeQueryData) && ExpUtils.isNotBlank(type)) {
                GatewayInfoCacheService.gateWaySystemInfos.put(Integer.parseInt(type), schemeQueryData);
                CommonInfo instance = CommonInfo.getInstance();
                if (ExpUtils.isBlank(instance.getOrgCode()) && ExpUtils.isNotBlank(schemeQueryData.getOrgCode())) {
                    logger.info("\u8bbe\u7f6eorgCode:{}", (Object)schemeQueryData.getOrgCode());
                    instance.setOrgCode(schemeQueryData.getOrgCode());
                    instance.setOrgName(schemeQueryData.getOrgName());
                    instance.setOrgType(schemeQueryData.getOrgType());
                }
                if (ExpUtils.isBlank(instance.getUserCode()) && ExpUtils.isNotBlank(schemeQueryData.getUserCode())) {
                    logger.info("\u8bbe\u7f6euserCode:{}", (Object)schemeQueryData.getUserCode());
                    instance.setUserCode(schemeQueryData.getUserCode());
                    instance.setUserName(schemeQueryData.getUserName());
                }
            }
        } else {
            logger.info("\u8bf7\u6c42\u7f51\u5173\u83b7\u53d6\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25,code:{},message:{}", (Object)code, (Object)message);
            return;
        }
    }
}

