/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.communication.business.send;

import cn.yto.cache.DeviceRecordCacheService;
import cn.yto.cache.LatticeStatusCacheService;
import cn.yto.cache.NewLatticeCacheService;
import cn.yto.communication.business.BusinessGateWayComm;
import cn.yto.communication.business.receive.ReceiveThreeCodeComm;
import cn.yto.communication.plc.receive.ReceiveScanComm;
import cn.yto.constants.MtyEnum;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.busigateway.request.OptDaTouBiReq;
import cn.yto.entity.busigateway.response.OptDaTouBiData;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.plc.PlcGateWay;
import cn.yto.netty.utils.MessageUtils;
import cn.yto.service.AsyncService;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendThreeCodeComm
extends BusinessGateWayComm {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    @Autowired
    private ReceiveThreeCodeComm receiveThreeCodeComm;
    @Autowired
    private AsyncService asyncService;
    @Autowired
    private PlcGateWay plcGateWay;
    @Autowired
    private ReceiveScanComm receiveScanComm;
    @Autowired
    private NewLatticeCacheService latticeCacheService;

    @Override
    public void reqBusinessGateway(DeviceSortRecord deviceSortRecord) {
        OptDaTouBiReq optDaTouBiReq = new OptDaTouBiReq();
        optDaTouBiReq.setCreateTime(DateUtil.formatYMDHMSS(new Date()));
        optDaTouBiReq.setWaybillNo(deviceSortRecord.getWaybillNo());
        optDaTouBiReq.setSignature("123");
        optDaTouBiReq.setTxId(deviceSortRecord.getItemKey());
        optDaTouBiReq.setMty(MtyEnum.AUTO_DEVICE_OPT_DATOUBI.getKey());
        if (ExpUtils.isNotBlank(deviceSortRecord.getSchemeNo())) {
            optDaTouBiReq.setSchemeId(deviceSortRecord.getSchemeNo());
        } else if (NewLatticeCacheService.currentScheme != null) {
            optDaTouBiReq.setSchemeId(NewLatticeCacheService.currentScheme.getSchemeId());
        }
        String threeCodeJsonStr = JSONObject.toJSONString((Object)optDaTouBiReq);
        String threeCodeJsonStrMsg = AdapterHelperUtil.renewItem(String.valueOf(threeCodeJsonStr.length()), 8) + threeCodeJsonStr;
        this.sendMsg(1, threeCodeJsonStrMsg);
    }

    @Override
    public void respBusinessGateway(JSONObject jsonObject) {
        String code = jsonObject.getString("code");
        String message = jsonObject.getString("msg");
        JSONObject data = jsonObject.getJSONObject("data");
        String txId = data.getString("txId");
        OptDaTouBiData optDaTouBiData = (OptDaTouBiData)JSON.toJavaObject((JSON)data, OptDaTouBiData.class);
        String waybillNo = optDaTouBiData.getWaybillNo();
        DeviceSortRecord deviceSortRecord = DeviceRecordCacheService.cartWaybillNoCache.get(txId);
        if ("000".equals(code)) {
            this.receiveThreeCodeComm.handleReciveDaTouBiData(optDaTouBiData, null);
            if (Objects.isNull(deviceSortRecord)) {
                logger.info("\u6839\u636ewaybillNo:{},itemKey:{},\u672a\u4ece\u7f13\u5b58\u67e5\u5230\u8bb0\u5f55", (Object)optDaTouBiData.getWaybillNo(), (Object)txId);
                return;
            }
            String latticeNo = optDaTouBiData.getLatticeNo();
            if (ExpUtils.isBlank(latticeNo)) {
                logger.info("\u672a\u67e5\u5230\u683c\u53e3\u4fe1\u606f,\u843d\u7269\u7406\u5f02\u5e38\u53e3");
                String scanResp = this.receiveScanComm.sendPhysicalLattice(System.currentTimeMillis() + "00000", "SCAN", "1", deviceSortRecord.getCartNo(), waybillNo);
                this.plcGateWay.sendMsg(scanResp, "1");
                return;
            }
            logger.info("\u5355\u53f7:{},\u67e5\u5230\u683c\u53e3\u4fe1\u606f:{}", (Object)waybillNo, (Object)latticeNo);
            String[] split1 = latticeNo.split(",");
            String chuteNumber = split1.length + "";
            String daTouBi = optDaTouBiData.getDaTouBi();
            if (split1.length > 1 && ExpUtils.isNotBlank(daTouBi) && this.latticeCacheService.enableLatticeRound()) {
                List notLockLattices = Arrays.stream(split1).filter(n -> !LatticeStatusCacheService.lockLattices.contains(Integer.parseInt(n))).sorted().collect(Collectors.toList());
                logger.info("\u5355\u53f7:{},\u4e09\u6bb5\u7801:{},\u672a\u9501\u7684\u683c\u53e3:{}", new Object[]{waybillNo, daTouBi, notLockLattices});
                if (notLockLattices.size() > 1) {
                    String preLatticeNo = DeviceRecordCacheService.threeCodeLattice.get(daTouBi);
                    latticeNo = ExpUtils.isBlank(preLatticeNo) ? split1[0] : notLockLattices.stream().filter(n -> Integer.parseInt(n) > Integer.parseInt(preLatticeNo)).findFirst().orElse(split1[0]);
                    chuteNumber = "1";
                    DeviceRecordCacheService.threeCodeLattice.put(daTouBi, latticeNo);
                    logger.info("\u5355\u53f7:{},\u4e09\u6bb5\u7801:{},\u4f7f\u7528\u683c\u53e3\u8f6e\u8be2,\u683c\u53e3:{}", new Object[]{waybillNo, daTouBi, latticeNo});
                } else {
                    logger.info("\u5355\u53f7:{},\u4e09\u6bb5\u7801:{},\u683c\u53e3:{}\u5df2\u9501", new Object[]{waybillNo, daTouBi, Arrays.asList(split1)});
                }
            }
            String scanResp = MessageUtils.buildResponseStr(System.currentTimeMillis() + "00000", "SCAN", "1", deviceSortRecord.getCartNo(), waybillNo, chuteNumber, latticeNo);
            logger.info("\u5355\u53f7:{},\u5f00\u59cb\u53d1\u9001SCAN\u6d88\u606f:{}", (Object)waybillNo, (Object)scanResp);
            this.plcGateWay.sendMsg(scanResp, "1");
            if (Objects.nonNull(deviceSortRecord.getScanCount())) {
                deviceSortRecord.setScanCount(deviceSortRecord.getScanCount() + 1);
            } else {
                deviceSortRecord.setScanCount(1);
            }
            if (Objects.isNull(deviceSortRecord.getScanTime())) {
                deviceSortRecord.setScanTime(new Date());
            }
            this.asyncService.updateItemKeyCacheAndSendSupplyCmd(deviceSortRecord);
        } else {
            logger.info("\u4e09\u6bb5\u7801\u8bf7\u6c42\u54cd\u5e94\u5931\u8d25,\u5355\u53f7:{},\u72b6\u6001\u7801:{},\u63d0\u793a\u4fe1\u606f:{},\u53d1\u9001\u7269\u7406\u5f02\u5e38\u53e3", new Object[]{waybillNo, code, message});
            if (Objects.isNull(deviceSortRecord)) {
                logger.info("\u6839\u636ewaybillNo:{},itemKey:{},\u672a\u4ece\u7f13\u5b58\u67e5\u5230\u8bb0\u5f55", (Object)optDaTouBiData.getWaybillNo(), (Object)txId);
                return;
            }
            String scanResp = this.receiveScanComm.sendPhysicalLattice(System.currentTimeMillis() + "00000", "SCAN", "1", deviceSortRecord.getCartNo(), waybillNo);
            this.plcGateWay.sendMsg(scanResp, "1");
        }
    }

    public static void main(String[] args) {
        System.out.println(MessageUtils.buildResponseStr(System.currentTimeMillis() + "", "SCAN", "1", "10", "YT1234", "2", "010,111"));
        Object[] numbers = new String[]{"123", "456", "789", "012", "003", "345"};
        Arrays.sort(numbers);
        String preLatticeNo = "789";
        String latticeNo = Arrays.stream(numbers).filter(n -> Integer.parseInt(n) > Integer.parseInt(preLatticeNo)).findFirst().orElse((String)numbers[0]);
        System.out.printf(latticeNo, new Object[0]);
    }
}

