/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.config;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import freemarker.template.utility.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.util.CollectionUtils;

@Configuration
@PropertySource(value={"classpath:config/expSortingConfig.properties"})
public class SortingConfig {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Value(value="${supplyTable:1}")
    private int supplyTable;
    @Value(value="${dynamicScale:1}")
    private int dynamicScale;
    @Value(value="${tmwsClient:1}")
    private int tmwsClient;
    @Value(value="${connectWcs:1}")
    private int connectWcs;
    @Value(value="${physicalLattice:}")
    private String physicalLattice;
    @Value(value="${operTableNum:12}")
    private Integer operTableNum;
    @Value(value="${latticeNum:160}")
    private Integer latticeNum;
    @Value(value="${masterWcs:1}")
    private String masterWcs;
    @Value(value="${multiPlc:0}")
    private String multiPlc;
    @Value(value="${errCode:1}")
    private String errCode;
    @Value(value="${pushOutToMonitor:0}")
    private String pushOutToMonitor;
    @Value(value="${backFlowCircle:}")
    private String backFlowCircle;
    @Value(value="${weight:}")
    private String weight;
    @Value(value="${fullDetection:}")
    private String fullDetection;
    @Value(value="${latticeButton:}")
    private String latticeButton;
    @Value(value="${autoLockLattice:1}")
    private String autoLockLattice;
    @Value(value="${compress:1}")
    private String compress;
    @Value(value="${waterMark:1}")
    private String waterMark;
    @Value(value="${handleNoRead:1}")
    private String handleNoRead;
    private List<String> excludeLimitLattice = new ArrayList<String>();
    @Value(value="${roundLattice:1}")
    private String roundLattice;
    @Value(value="${limitWeight:0}")
    private String limitWeight;
    @Value(value="${maxWeight:35}")
    private String maxWeight;
    @Value(value="${enableSupplyWeight:0}")
    private String enableSupplyWeight;
    @Value(value="${supplyLimitWeight:3}")
    private String supplyLimitWeight;
    @Value(value="${notLimitLattice:}")
    private String notLimitLattice;
    @Value(value="${supplyWeightLattice:}")
    private String supplyWeightLattice;
    @Value(value="${maxStatisticsHour:6}")
    private Integer maxStatisticsHour;
    @Value(value="${turnOverMode:0}")
    private String turnOverMode;
    @Value(value="${autoGenCQNum:0}")
    private String autoGenCQNum;
    private List<String> errCodes;

    public String getCompress() {
        return this.compress;
    }

    public void setCompress(String compress) {
        this.compress = compress;
    }

    public String getWaterMark() {
        return this.waterMark;
    }

    public String getHandleNoRead() {
        return this.handleNoRead;
    }

    public void setHandleNoRead(String handleNoRead) {
        this.handleNoRead = handleNoRead;
    }

    public void setWaterMark(String waterMark) {
        this.waterMark = waterMark;
    }

    public String getRoundLattice() {
        return this.roundLattice;
    }

    public void setRoundLattice(String roundLattice) {
        this.roundLattice = roundLattice;
    }

    public String getEnableSupplyWeight() {
        return this.enableSupplyWeight;
    }

    public void setEnableSupplyWeight(String enableSupplyWeight) {
        this.enableSupplyWeight = enableSupplyWeight;
    }

    public String getSupplyLimitWeight() {
        return this.supplyLimitWeight;
    }

    public void setSupplyLimitWeight(String supplyLimitWeight) {
        this.supplyLimitWeight = supplyLimitWeight;
    }

    public String getSupplyWeightLattice() {
        return this.supplyWeightLattice;
    }

    public void setSupplyWeightLattice(String supplyWeightLattice) {
        this.supplyWeightLattice = supplyWeightLattice;
    }

    public String getTurnOverMode() {
        return this.turnOverMode;
    }

    public void setTurnOverMode(String turnOverMode) {
        this.turnOverMode = turnOverMode;
    }

    public String getAutoGenCQNum() {
        return this.autoGenCQNum;
    }

    public void setAutoGenCQNum(String autoGenCQNum) {
        this.autoGenCQNum = autoGenCQNum;
    }

    public Integer getMaxStatisticsHour() {
        return this.maxStatisticsHour;
    }

    public void setMaxStatisticsHour(Integer maxStatisticsHour) {
        this.maxStatisticsHour = maxStatisticsHour;
    }

    public String getLimitWeight() {
        return this.limitWeight;
    }

    public void setLimitWeight(String limitWeight) {
        this.limitWeight = limitWeight;
    }

    public String getMaxWeight() {
        return this.maxWeight;
    }

    public void setMaxWeight(String maxWeight) {
        this.maxWeight = maxWeight;
    }

    public String getAutoLockLattice() {
        return this.autoLockLattice;
    }

    public void setAutoLockLattice(String autoLockLattice) {
        this.autoLockLattice = autoLockLattice;
    }

    public String getMultiPlc() {
        return this.multiPlc;
    }

    public void setMultiPlc(String multiPlc) {
        this.multiPlc = multiPlc;
    }

    public String getPushOutToMonitor() {
        return this.pushOutToMonitor;
    }

    public void setPushOutToMonitor(String pushOutToMonitor) {
        this.pushOutToMonitor = pushOutToMonitor;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public List<String> getErrCodes() {
        if (CollectionUtils.isEmpty(this.errCodes)) {
            String[] split = this.errCode.split(",");
            this.errCodes = Arrays.asList(split);
        }
        return this.errCodes;
    }

    public Integer getLatticeNum() {
        return this.latticeNum;
    }

    public void setLatticeNum(Integer latticeNum) {
        this.latticeNum = latticeNum;
    }

    public String getMasterWcs() {
        return this.masterWcs;
    }

    public void setMasterWcs(String masterWcs) {
        this.masterWcs = masterWcs;
    }

    public Integer getOperTableNum() {
        return this.operTableNum;
    }

    public void setOperTableNum(Integer operTableNum) {
        this.operTableNum = operTableNum;
    }

    public String getPhysicalLattice() {
        return this.physicalLattice;
    }

    public void setPhysicalLattice(String physicalLattice) {
        this.physicalLattice = physicalLattice;
    }

    public boolean tmwsDynamicScaleConnectWcs() {
        return this.supplyTable == 1 && this.dynamicScale == 1 && this.tmwsClient == 1 && this.connectWcs == 1;
    }

    public boolean tmwsDynamicScaleNotConnectWcs() {
        return this.supplyTable == 1 && this.dynamicScale == 1 && this.tmwsClient == 1 && this.connectWcs == 0;
    }

    public boolean tmwsStaticScaleConnectWcs() {
        return this.supplyTable == 1 && this.dynamicScale == 0 && this.tmwsClient == 1 && this.connectWcs == 1;
    }

    public boolean tmwsStaticScaleNotConnectWcs() {
        return this.supplyTable == 1 && this.dynamicScale == 0 && this.tmwsClient == 1 && this.connectWcs == 0;
    }

    public boolean topScan() {
        return this.supplyTable == 0 && this.dynamicScale == 0 && this.tmwsClient == 0;
    }

    public boolean thirdStaticScaleNotConnectWcs() {
        return this.supplyTable == 1 && this.dynamicScale == 0 && this.tmwsClient == 0 && this.connectWcs == 0;
    }

    public boolean hirdDynamicScaleNotConnectWcs() {
        return this.supplyTable == 1 && this.dynamicScale == 1 && this.tmwsClient == 0 && this.connectWcs == 0;
    }

    public String getScanMode() {
        return this.supplyTable + "" + this.dynamicScale + this.tmwsClient + this.connectWcs;
    }

    public List<String> getExcludeLimitLattice() {
        if (!CollectionUtils.isEmpty(this.excludeLimitLattice)) {
            return this.excludeLimitLattice;
        }
        ArrayList<String> lattices = new ArrayList<String>();
        if (ExpUtils.isNotBlank(this.physicalLattice)) {
            if (this.physicalLattice.contains(",")) {
                lattices.addAll(Arrays.asList(this.physicalLattice.split(",")));
            } else {
                lattices.add(this.physicalLattice);
            }
        }
        if ("1".equals(this.enableSupplyWeight) && ExpUtils.isNotBlank(this.supplyWeightLattice)) {
            if (this.supplyWeightLattice.contains(",")) {
                lattices.addAll(Arrays.asList(this.supplyWeightLattice.split(",")));
            } else {
                lattices.add(this.supplyWeightLattice);
            }
        }
        if (ExpUtils.isNotBlank(this.notLimitLattice)) {
            if (this.notLimitLattice.contains(",")) {
                lattices.addAll(Arrays.asList(this.notLimitLattice.split(",")));
            } else {
                lattices.add(this.notLimitLattice);
            }
        }
        for (int i = 0; i <= lattices.size(); ++i) {
            this.excludeLimitLattice.add(StringUtil.leftPad((String)((String)lattices.get(i)), (int)3, (char)'0'));
        }
        logger.info("\u5f53\u524d\u4e0d\u9650\u91cd\u7684\u683c\u53e3:{}", this.excludeLimitLattice);
        return this.excludeLimitLattice;
    }

    public int getSupplyTable() {
        return this.supplyTable;
    }

    public int getDynamicScale() {
        return this.dynamicScale;
    }

    public int getTmwsClient() {
        return this.tmwsClient;
    }

    public int getConnectWcs() {
        return this.connectWcs;
    }

    public String getBackFlowCircle() {
        return this.backFlowCircle;
    }

    public String getWeight() {
        return this.weight;
    }

    public String getFullDetection() {
        return this.fullDetection;
    }

    public String getLatticeButton() {
        return this.latticeButton;
    }

    public String getNotLimitLattice() {
        return this.notLimitLattice;
    }

    public void setSupplyTable(int supplyTable) {
        this.supplyTable = supplyTable;
    }

    public void setDynamicScale(int dynamicScale) {
        this.dynamicScale = dynamicScale;
    }

    public void setTmwsClient(int tmwsClient) {
        this.tmwsClient = tmwsClient;
    }

    public void setConnectWcs(int connectWcs) {
        this.connectWcs = connectWcs;
    }

    public void setBackFlowCircle(String backFlowCircle) {
        this.backFlowCircle = backFlowCircle;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public void setFullDetection(String fullDetection) {
        this.fullDetection = fullDetection;
    }

    public void setLatticeButton(String latticeButton) {
        this.latticeButton = latticeButton;
    }

    public void setExcludeLimitLattice(List<String> excludeLimitLattice) {
        this.excludeLimitLattice = excludeLimitLattice;
    }

    public void setNotLimitLattice(String notLimitLattice) {
        this.notLimitLattice = notLimitLattice;
    }

    public void setErrCodes(List<String> errCodes) {
        this.errCodes = errCodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortingConfig)) {
            return false;
        }
        SortingConfig other = (SortingConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSupplyTable() != other.getSupplyTable()) {
            return false;
        }
        if (this.getDynamicScale() != other.getDynamicScale()) {
            return false;
        }
        if (this.getTmwsClient() != other.getTmwsClient()) {
            return false;
        }
        if (this.getConnectWcs() != other.getConnectWcs()) {
            return false;
        }
        String this$physicalLattice = this.getPhysicalLattice();
        String other$physicalLattice = other.getPhysicalLattice();
        if (this$physicalLattice == null ? other$physicalLattice != null : !this$physicalLattice.equals(other$physicalLattice)) {
            return false;
        }
        Integer this$operTableNum = this.getOperTableNum();
        Integer other$operTableNum = other.getOperTableNum();
        if (this$operTableNum == null ? other$operTableNum != null : !((Object)this$operTableNum).equals(other$operTableNum)) {
            return false;
        }
        Integer this$latticeNum = this.getLatticeNum();
        Integer other$latticeNum = other.getLatticeNum();
        if (this$latticeNum == null ? other$latticeNum != null : !((Object)this$latticeNum).equals(other$latticeNum)) {
            return false;
        }
        String this$masterWcs = this.getMasterWcs();
        String other$masterWcs = other.getMasterWcs();
        if (this$masterWcs == null ? other$masterWcs != null : !this$masterWcs.equals(other$masterWcs)) {
            return false;
        }
        String this$multiPlc = this.getMultiPlc();
        String other$multiPlc = other.getMultiPlc();
        if (this$multiPlc == null ? other$multiPlc != null : !this$multiPlc.equals(other$multiPlc)) {
            return false;
        }
        String this$errCode = this.getErrCode();
        String other$errCode = other.getErrCode();
        if (this$errCode == null ? other$errCode != null : !this$errCode.equals(other$errCode)) {
            return false;
        }
        String this$pushOutToMonitor = this.getPushOutToMonitor();
        String other$pushOutToMonitor = other.getPushOutToMonitor();
        if (this$pushOutToMonitor == null ? other$pushOutToMonitor != null : !this$pushOutToMonitor.equals(other$pushOutToMonitor)) {
            return false;
        }
        String this$backFlowCircle = this.getBackFlowCircle();
        String other$backFlowCircle = other.getBackFlowCircle();
        if (this$backFlowCircle == null ? other$backFlowCircle != null : !this$backFlowCircle.equals(other$backFlowCircle)) {
            return false;
        }
        String this$weight = this.getWeight();
        String other$weight = other.getWeight();
        if (this$weight == null ? other$weight != null : !this$weight.equals(other$weight)) {
            return false;
        }
        String this$fullDetection = this.getFullDetection();
        String other$fullDetection = other.getFullDetection();
        if (this$fullDetection == null ? other$fullDetection != null : !this$fullDetection.equals(other$fullDetection)) {
            return false;
        }
        String this$latticeButton = this.getLatticeButton();
        String other$latticeButton = other.getLatticeButton();
        if (this$latticeButton == null ? other$latticeButton != null : !this$latticeButton.equals(other$latticeButton)) {
            return false;
        }
        String this$autoLockLattice = this.getAutoLockLattice();
        String other$autoLockLattice = other.getAutoLockLattice();
        if (this$autoLockLattice == null ? other$autoLockLattice != null : !this$autoLockLattice.equals(other$autoLockLattice)) {
            return false;
        }
        String this$compress = this.getCompress();
        String other$compress = other.getCompress();
        if (this$compress == null ? other$compress != null : !this$compress.equals(other$compress)) {
            return false;
        }
        String this$waterMark = this.getWaterMark();
        String other$waterMark = other.getWaterMark();
        if (this$waterMark == null ? other$waterMark != null : !this$waterMark.equals(other$waterMark)) {
            return false;
        }
        String this$handleNoRead = this.getHandleNoRead();
        String other$handleNoRead = other.getHandleNoRead();
        if (this$handleNoRead == null ? other$handleNoRead != null : !this$handleNoRead.equals(other$handleNoRead)) {
            return false;
        }
        List<String> this$excludeLimitLattice = this.getExcludeLimitLattice();
        List<String> other$excludeLimitLattice = other.getExcludeLimitLattice();
        if (this$excludeLimitLattice == null ? other$excludeLimitLattice != null : !((Object)this$excludeLimitLattice).equals(other$excludeLimitLattice)) {
            return false;
        }
        String this$roundLattice = this.getRoundLattice();
        String other$roundLattice = other.getRoundLattice();
        if (this$roundLattice == null ? other$roundLattice != null : !this$roundLattice.equals(other$roundLattice)) {
            return false;
        }
        String this$limitWeight = this.getLimitWeight();
        String other$limitWeight = other.getLimitWeight();
        if (this$limitWeight == null ? other$limitWeight != null : !this$limitWeight.equals(other$limitWeight)) {
            return false;
        }
        String this$maxWeight = this.getMaxWeight();
        String other$maxWeight = other.getMaxWeight();
        if (this$maxWeight == null ? other$maxWeight != null : !this$maxWeight.equals(other$maxWeight)) {
            return false;
        }
        String this$enableSupplyWeight = this.getEnableSupplyWeight();
        String other$enableSupplyWeight = other.getEnableSupplyWeight();
        if (this$enableSupplyWeight == null ? other$enableSupplyWeight != null : !this$enableSupplyWeight.equals(other$enableSupplyWeight)) {
            return false;
        }
        String this$supplyLimitWeight = this.getSupplyLimitWeight();
        String other$supplyLimitWeight = other.getSupplyLimitWeight();
        if (this$supplyLimitWeight == null ? other$supplyLimitWeight != null : !this$supplyLimitWeight.equals(other$supplyLimitWeight)) {
            return false;
        }
        String this$notLimitLattice = this.getNotLimitLattice();
        String other$notLimitLattice = other.getNotLimitLattice();
        if (this$notLimitLattice == null ? other$notLimitLattice != null : !this$notLimitLattice.equals(other$notLimitLattice)) {
            return false;
        }
        String this$supplyWeightLattice = this.getSupplyWeightLattice();
        String other$supplyWeightLattice = other.getSupplyWeightLattice();
        if (this$supplyWeightLattice == null ? other$supplyWeightLattice != null : !this$supplyWeightLattice.equals(other$supplyWeightLattice)) {
            return false;
        }
        Integer this$maxStatisticsHour = this.getMaxStatisticsHour();
        Integer other$maxStatisticsHour = other.getMaxStatisticsHour();
        if (this$maxStatisticsHour == null ? other$maxStatisticsHour != null : !((Object)this$maxStatisticsHour).equals(other$maxStatisticsHour)) {
            return false;
        }
        String this$turnOverMode = this.getTurnOverMode();
        String other$turnOverMode = other.getTurnOverMode();
        if (this$turnOverMode == null ? other$turnOverMode != null : !this$turnOverMode.equals(other$turnOverMode)) {
            return false;
        }
        String this$autoGenCQNum = this.getAutoGenCQNum();
        String other$autoGenCQNum = other.getAutoGenCQNum();
        if (this$autoGenCQNum == null ? other$autoGenCQNum != null : !this$autoGenCQNum.equals(other$autoGenCQNum)) {
            return false;
        }
        List<String> this$errCodes = this.getErrCodes();
        List<String> other$errCodes = other.getErrCodes();
        return !(this$errCodes == null ? other$errCodes != null : !((Object)this$errCodes).equals(other$errCodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SortingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSupplyTable();
        result = result * 59 + this.getDynamicScale();
        result = result * 59 + this.getTmwsClient();
        result = result * 59 + this.getConnectWcs();
        String $physicalLattice = this.getPhysicalLattice();
        result = result * 59 + ($physicalLattice == null ? 43 : $physicalLattice.hashCode());
        Integer $operTableNum = this.getOperTableNum();
        result = result * 59 + ($operTableNum == null ? 43 : ((Object)$operTableNum).hashCode());
        Integer $latticeNum = this.getLatticeNum();
        result = result * 59 + ($latticeNum == null ? 43 : ((Object)$latticeNum).hashCode());
        String $masterWcs = this.getMasterWcs();
        result = result * 59 + ($masterWcs == null ? 43 : $masterWcs.hashCode());
        String $multiPlc = this.getMultiPlc();
        result = result * 59 + ($multiPlc == null ? 43 : $multiPlc.hashCode());
        String $errCode = this.getErrCode();
        result = result * 59 + ($errCode == null ? 43 : $errCode.hashCode());
        String $pushOutToMonitor = this.getPushOutToMonitor();
        result = result * 59 + ($pushOutToMonitor == null ? 43 : $pushOutToMonitor.hashCode());
        String $backFlowCircle = this.getBackFlowCircle();
        result = result * 59 + ($backFlowCircle == null ? 43 : $backFlowCircle.hashCode());
        String $weight = this.getWeight();
        result = result * 59 + ($weight == null ? 43 : $weight.hashCode());
        String $fullDetection = this.getFullDetection();
        result = result * 59 + ($fullDetection == null ? 43 : $fullDetection.hashCode());
        String $latticeButton = this.getLatticeButton();
        result = result * 59 + ($latticeButton == null ? 43 : $latticeButton.hashCode());
        String $autoLockLattice = this.getAutoLockLattice();
        result = result * 59 + ($autoLockLattice == null ? 43 : $autoLockLattice.hashCode());
        String $compress = this.getCompress();
        result = result * 59 + ($compress == null ? 43 : $compress.hashCode());
        String $waterMark = this.getWaterMark();
        result = result * 59 + ($waterMark == null ? 43 : $waterMark.hashCode());
        String $handleNoRead = this.getHandleNoRead();
        result = result * 59 + ($handleNoRead == null ? 43 : $handleNoRead.hashCode());
        List<String> $excludeLimitLattice = this.getExcludeLimitLattice();
        result = result * 59 + ($excludeLimitLattice == null ? 43 : ((Object)$excludeLimitLattice).hashCode());
        String $roundLattice = this.getRoundLattice();
        result = result * 59 + ($roundLattice == null ? 43 : $roundLattice.hashCode());
        String $limitWeight = this.getLimitWeight();
        result = result * 59 + ($limitWeight == null ? 43 : $limitWeight.hashCode());
        String $maxWeight = this.getMaxWeight();
        result = result * 59 + ($maxWeight == null ? 43 : $maxWeight.hashCode());
        String $enableSupplyWeight = this.getEnableSupplyWeight();
        result = result * 59 + ($enableSupplyWeight == null ? 43 : $enableSupplyWeight.hashCode());
        String $supplyLimitWeight = this.getSupplyLimitWeight();
        result = result * 59 + ($supplyLimitWeight == null ? 43 : $supplyLimitWeight.hashCode());
        String $notLimitLattice = this.getNotLimitLattice();
        result = result * 59 + ($notLimitLattice == null ? 43 : $notLimitLattice.hashCode());
        String $supplyWeightLattice = this.getSupplyWeightLattice();
        result = result * 59 + ($supplyWeightLattice == null ? 43 : $supplyWeightLattice.hashCode());
        Integer $maxStatisticsHour = this.getMaxStatisticsHour();
        result = result * 59 + ($maxStatisticsHour == null ? 43 : ((Object)$maxStatisticsHour).hashCode());
        String $turnOverMode = this.getTurnOverMode();
        result = result * 59 + ($turnOverMode == null ? 43 : $turnOverMode.hashCode());
        String $autoGenCQNum = this.getAutoGenCQNum();
        result = result * 59 + ($autoGenCQNum == null ? 43 : $autoGenCQNum.hashCode());
        List<String> $errCodes = this.getErrCodes();
        result = result * 59 + ($errCodes == null ? 43 : ((Object)$errCodes).hashCode());
        return result;
    }

    public String toString() {
        return "SortingConfig(supplyTable=" + this.getSupplyTable() + ", dynamicScale=" + this.getDynamicScale() + ", tmwsClient=" + this.getTmwsClient() + ", connectWcs=" + this.getConnectWcs() + ", physicalLattice=" + this.getPhysicalLattice() + ", operTableNum=" + this.getOperTableNum() + ", latticeNum=" + this.getLatticeNum() + ", masterWcs=" + this.getMasterWcs() + ", multiPlc=" + this.getMultiPlc() + ", errCode=" + this.getErrCode() + ", pushOutToMonitor=" + this.getPushOutToMonitor() + ", backFlowCircle=" + this.getBackFlowCircle() + ", weight=" + this.getWeight() + ", fullDetection=" + this.getFullDetection() + ", latticeButton=" + this.getLatticeButton() + ", autoLockLattice=" + this.getAutoLockLattice() + ", compress=" + this.getCompress() + ", waterMark=" + this.getWaterMark() + ", handleNoRead=" + this.getHandleNoRead() + ", excludeLimitLattice=" + this.getExcludeLimitLattice() + ", roundLattice=" + this.getRoundLattice() + ", limitWeight=" + this.getLimitWeight() + ", maxWeight=" + this.getMaxWeight() + ", enableSupplyWeight=" + this.getEnableSupplyWeight() + ", supplyLimitWeight=" + this.getSupplyLimitWeight() + ", notLimitLattice=" + this.getNotLimitLattice() + ", supplyWeightLattice=" + this.getSupplyWeightLattice() + ", maxStatisticsHour=" + this.getMaxStatisticsHour() + ", turnOverMode=" + this.getTurnOverMode() + ", autoGenCQNum=" + this.getAutoGenCQNum() + ", errCodes=" + this.getErrCodes() + ")";
    }
}

