/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.config;

import cn.yto.utils.CommonUtils;
import java.net.InetAddress;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WcsTcpServerConfig {
    @Value(value="${wcs.server.startUpChannel}")
    private Integer wcsStartUpTcpServerChannel;
    @Value(value="${wcs.server.port}")
    private Integer wcsTcpPort;
    @Value(value="${wcs.server.ip:127.0.0.1}")
    private String wcsIp;
    @Value(value="${wcs.server.plcPort}")
    private Integer plcPort;
    @Value(value="${wcs.server.plcStartUpChannel}")
    private Integer plcStartUpChannel;

    public String getWcsIp() {
        InetAddress hostLANAddress;
        if ("127.0.0.1".equals(this.wcsIp) && Objects.nonNull(hostLANAddress = CommonUtils.getLocalHostLANAddress())) {
            this.wcsIp = hostLANAddress.getHostAddress();
        }
        return this.wcsIp;
    }

    public Integer getWcsStartUpTcpServerChannel() {
        return this.wcsStartUpTcpServerChannel;
    }

    public Integer getWcsTcpPort() {
        return this.wcsTcpPort;
    }

    public Integer getPlcPort() {
        return this.plcPort;
    }

    public Integer getPlcStartUpChannel() {
        return this.plcStartUpChannel;
    }

    public void setWcsStartUpTcpServerChannel(Integer wcsStartUpTcpServerChannel) {
        this.wcsStartUpTcpServerChannel = wcsStartUpTcpServerChannel;
    }

    public void setWcsTcpPort(Integer wcsTcpPort) {
        this.wcsTcpPort = wcsTcpPort;
    }

    public void setWcsIp(String wcsIp) {
        this.wcsIp = wcsIp;
    }

    public void setPlcPort(Integer plcPort) {
        this.plcPort = plcPort;
    }

    public void setPlcStartUpChannel(Integer plcStartUpChannel) {
        this.plcStartUpChannel = plcStartUpChannel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WcsTcpServerConfig)) {
            return false;
        }
        WcsTcpServerConfig other = (WcsTcpServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$wcsStartUpTcpServerChannel = this.getWcsStartUpTcpServerChannel();
        Integer other$wcsStartUpTcpServerChannel = other.getWcsStartUpTcpServerChannel();
        if (this$wcsStartUpTcpServerChannel == null ? other$wcsStartUpTcpServerChannel != null : !((Object)this$wcsStartUpTcpServerChannel).equals(other$wcsStartUpTcpServerChannel)) {
            return false;
        }
        Integer this$wcsTcpPort = this.getWcsTcpPort();
        Integer other$wcsTcpPort = other.getWcsTcpPort();
        if (this$wcsTcpPort == null ? other$wcsTcpPort != null : !((Object)this$wcsTcpPort).equals(other$wcsTcpPort)) {
            return false;
        }
        String this$wcsIp = this.getWcsIp();
        String other$wcsIp = other.getWcsIp();
        if (this$wcsIp == null ? other$wcsIp != null : !this$wcsIp.equals(other$wcsIp)) {
            return false;
        }
        Integer this$plcPort = this.getPlcPort();
        Integer other$plcPort = other.getPlcPort();
        if (this$plcPort == null ? other$plcPort != null : !((Object)this$plcPort).equals(other$plcPort)) {
            return false;
        }
        Integer this$plcStartUpChannel = this.getPlcStartUpChannel();
        Integer other$plcStartUpChannel = other.getPlcStartUpChannel();
        return !(this$plcStartUpChannel == null ? other$plcStartUpChannel != null : !((Object)this$plcStartUpChannel).equals(other$plcStartUpChannel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WcsTcpServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $wcsStartUpTcpServerChannel = this.getWcsStartUpTcpServerChannel();
        result = result * 59 + ($wcsStartUpTcpServerChannel == null ? 43 : ((Object)$wcsStartUpTcpServerChannel).hashCode());
        Integer $wcsTcpPort = this.getWcsTcpPort();
        result = result * 59 + ($wcsTcpPort == null ? 43 : ((Object)$wcsTcpPort).hashCode());
        String $wcsIp = this.getWcsIp();
        result = result * 59 + ($wcsIp == null ? 43 : $wcsIp.hashCode());
        Integer $plcPort = this.getPlcPort();
        result = result * 59 + ($plcPort == null ? 43 : ((Object)$plcPort).hashCode());
        Integer $plcStartUpChannel = this.getPlcStartUpChannel();
        result = result * 59 + ($plcStartUpChannel == null ? 43 : ((Object)$plcStartUpChannel).hashCode());
        return result;
    }

    public String toString() {
        return "WcsTcpServerConfig(wcsStartUpTcpServerChannel=" + this.getWcsStartUpTcpServerChannel() + ", wcsTcpPort=" + this.getWcsTcpPort() + ", wcsIp=" + this.getWcsIp() + ", plcPort=" + this.getPlcPort() + ", plcStartUpChannel=" + this.getPlcStartUpChannel() + ")";
    }
}

