/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.entity.busigateway.listener;

import cn.yto.communication.business.send.SendOptInComm;
import cn.yto.communication.business.send.SendOptOutComm;
import cn.yto.communication.business.send.SendOptSchemeComm;
import cn.yto.communication.business.send.SendOptSystemComm;
import cn.yto.communication.business.send.SendThreeCodeComm;
import cn.yto.constants.MtyEnum;
import cn.yto.entity.busigateway.listener.FallLatticeEvent;
import cn.yto.entity.busigateway.listener.SupplyExpressEvent;
import cn.yto.entity.busigateway.listener.ThreeCodeEvent;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class DeviceSortEventListener {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final Logger heartBeatLogger = CustomLoggerFactory.HeartBeatLogger();
    @Autowired
    private SendOptInComm optInMsgProcService;
    @Autowired
    private SendOptSchemeComm latticeSchemeService;
    @Autowired
    private SendThreeCodeComm threeCodeMsgProcService;
    @Autowired
    private SendOptOutComm optOutMsgProcService;
    @Autowired
    private SendOptSystemComm systemInfoService;

    @EventListener
    public void handelThreeCodeEvent(ThreeCodeEvent event) {
        JSONObject jsonObject = event.getJsonObject();
        JSONObject data = jsonObject.getJSONObject("data");
        if (Objects.isNull(data)) {
            return;
        }
        String txId = data.getString("txId");
        if (ExpUtils.isBlank(txId)) {
            return;
        }
        if (MtyEnum.AUTO_DEVICE_OPT_SCHEME_QUERY.getKey().equals(txId)) {
            this.latticeSchemeService.respBusinessGateway(jsonObject);
        } else if (MtyEnum.AUTO_DEVICE_SYSTEM_QUERY.getKey().equals(txId)) {
            jsonObject.put("type", (Object)1);
            this.systemInfoService.respBusinessGateway(jsonObject);
        } else if (MtyEnum.AUTO_DEVICE_SYSTEM_HEART_BEAT_RESP.getKey().equals(txId)) {
            heartBeatLogger.info("\u6536\u5230\u4e09\u6bb5\u7801\u7f51\u5173\u5fc3\u8df3\u56de\u590d\uff1a" + data.toJSONString());
        } else {
            this.threeCodeMsgProcService.respBusinessGateway(jsonObject);
        }
    }

    @EventListener
    public void handelSupplyExpressEvent(SupplyExpressEvent event) {
        JSONObject jsonObject = event.getJsonObject();
        String txId = jsonObject.getJSONObject("data").getString("txId");
        if (MtyEnum.AUTO_DEVICE_SYSTEM_HEART_BEAT_RESP.getKey().equals(txId)) {
            heartBeatLogger.info("\u6536\u5230\u4f9b\u4ef6\u7f51\u5173\u5fc3\u8df3\u56de\u590d\uff1a" + jsonObject.getJSONObject("data").toJSONString());
            return;
        }
        if (MtyEnum.AUTO_DEVICE_SYSTEM_QUERY.getKey().equals(txId)) {
            jsonObject.put("type", (Object)2);
            this.systemInfoService.respBusinessGateway(jsonObject);
            return;
        }
        this.optInMsgProcService.respBusinessGateway(jsonObject);
    }

    @EventListener
    public void handelFailLatticeEvent(FallLatticeEvent event) {
        JSONObject jsonObject = event.getJsonObject();
        String txId = jsonObject.getJSONObject("data").getString("txId");
        if (MtyEnum.AUTO_DEVICE_SYSTEM_HEART_BEAT_RESP.getKey().equals(txId)) {
            heartBeatLogger.info("\u6536\u5230\u843d\u4ef6\u7f51\u5173\u5fc3\u8df3\u56de\u590d\uff1a" + jsonObject.getJSONObject("data").toJSONString());
            return;
        }
        if (MtyEnum.AUTO_DEVICE_SYSTEM_QUERY.getKey().equals(txId)) {
            jsonObject.put("type", (Object)3);
            this.systemInfoService.respBusinessGateway(jsonObject);
            return;
        }
        this.optOutMsgProcService.respBusinessGateway(jsonObject);
    }
}

