/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.ftp;

import cn.yto.service.image.FtpHandleService;
import cn.yto.utils.SpringUtil;
import java.io.File;
import java.io.IOException;
import org.apache.ftpserver.filesystem.nativefs.impl.NativeFtpFile;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.ftplet.FtpSession;
import org.apache.ftpserver.ftplet.FtpletResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFtpPlet
extends DefaultFtplet {
    private static final Logger logger = LoggerFactory.getLogger(CustomFtpPlet.class);
    private static FtpHandleService ftpHandleService;

    public static FtpHandleService getFtpHandleService() {
        if (ftpHandleService == null) {
            ftpHandleService = SpringUtil.getBean(FtpHandleService.class);
        }
        return ftpHandleService;
    }

    public FtpletResult onUploadStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        String path = session.getUser().getHomeDirectory();
        String filename = request.getArgument();
        logger.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u76ee\u5f55\uff1a'{}'\uff0c\u6587\u4ef6\u540d\u79f0\u4e3a\uff1a'{}'\uff0c\u72b6\u6001\uff1a\u5f00\u59cb\u4e0a\u4f20~", (Object)path, (Object)filename);
        return super.onUploadStart(session, request);
    }

    public FtpletResult onUploadEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        String path = session.getUser().getHomeDirectory();
        String filename = request.getArgument();
        FtpletResult ftpletResult = super.onUploadEnd(session, request);
        FtpFile file = session.getFileSystemView().getFile(request.getArgument());
        if (file.isFile() && file instanceof NativeFtpFile) {
            File srcFile = ((NativeFtpFile)file).getPhysicalFile();
            logger.info("\u4e0a\u4f20\u6587\u4ef6\u5230\u76ee\u5f55\uff1a'{}'\uff0c\u6587\u4ef6\u540d\u79f0\u4e3a\uff1a'{}\uff0c\u72b6\u6001\uff1a\u6210\u529f\uff01'", (Object)path, (Object)filename);
            CustomFtpPlet.getFtpHandleService().procImage(srcFile);
        }
        return ftpletResult;
    }

    public FtpletResult onDownloadStart(FtpSession session, FtpRequest request) throws FtpException, IOException {
        return super.onDownloadStart(session, request);
    }

    public FtpletResult onDownloadEnd(FtpSession session, FtpRequest request) throws FtpException, IOException {
        return super.onDownloadEnd(session, request);
    }
}

