/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.ftp;

import cn.yto.config.FtpServerConfig;
import cn.yto.config.SortingConfig;
import cn.yto.ftp.CustomFtpPlet;
import cn.yto.service.image.FtpHandleService;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.listener.Listener;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.apache.ftpserver.usermanager.impl.WritePermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.stereotype.Service;

@Service
public class FtpServerStarter
implements SmartLifecycle,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(FtpServerStarter.class);
    @Autowired
    private FtpServerConfig ftpConfiguration;
    private volatile boolean running;
    private FtpServer server;
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    private FtpHandleService ftpHandleService;

    public void destroy() throws Exception {
        this.setRunning(false);
        if (Objects.nonNull(this.server)) {
            this.server.stop();
        }
        logger.info("container destroyed, {}", (Object)this.toString());
    }

    public void start() {
        if (this.isRunning()) {
            throw new IllegalStateException("container already running. " + this.toString());
        }
        this.setRunning(true);
        this.ftpStart();
        logger.info("running container: {}", (Object)this.toString());
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void stop() {
        if (this.isRunning()) {
            if (Objects.nonNull(this.server)) {
                this.server.stop();
            }
            this.setRunning(false);
            logger.info("stop container: {}", (Object)this.toString());
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        int supplyTable = this.sortingConfig.getSupplyTable();
        return supplyTable == 0;
    }

    public int getPhase() {
        return 0;
    }

    public void ftpStart() {
        try {
            this.ftpHandleService.initDirectory();
            String ftpPath = this.ftpConfiguration.getImgFtpSrcPath();
            File file = new File(ftpPath);
            logger.info("=========FTP\u6587\u4ef6\u5b58\u50a8\u8def\u5f84:" + ftpPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            FtpServerFactory factory = new FtpServerFactory();
            ListenerFactory listenerFactory = new ListenerFactory();
            logger.info("=========FTP\u4e0a\u4f20\u6587\u4ef6\u7aef\u53e3:" + this.ftpConfiguration.getFtpPort());
            listenerFactory.setPort(this.ftpConfiguration.getFtpPort().intValue());
            logger.info("=========\u7a7a\u95f2\u8d85\u65f6\u65f6\u95f4\uff1a" + this.ftpConfiguration.getIdleTimeout());
            listenerFactory.setIdleTimeout(this.ftpConfiguration.getIdleTimeout().intValue());
            logger.info("=========\u88ab\u52a8\u6a21\u5f0f\u4e0a\u4f20\u7aef\u53e3\u8303\u56f4\uff1a" + this.ftpConfiguration.getPassivePorts());
            DataConnectionConfigurationFactory dataConnectionConfFactory = new DataConnectionConfigurationFactory();
            dataConnectionConfFactory.setPassivePorts(this.ftpConfiguration.getPassivePorts());
            listenerFactory.setDataConnectionConfiguration(dataConnectionConfFactory.createDataConnectionConfiguration());
            Listener listener = listenerFactory.createListener();
            factory.addListener("default", listener);
            HashMap<String, CustomFtpPlet> ftpLets = new HashMap<String, CustomFtpPlet>();
            ftpLets.put("ftpService", new CustomFtpPlet());
            factory.setFtplets(ftpLets);
            BaseUser user = new BaseUser();
            user.setName(this.ftpConfiguration.getFtpUser());
            user.setPassword(this.ftpConfiguration.getFtpPwd());
            user.setHomeDirectory(ftpPath);
            ArrayList<WritePermission> authorities = new ArrayList<WritePermission>();
            authorities.add(new WritePermission());
            user.setAuthorities(authorities);
            factory.getUserManager().save((User)user);
            this.server = factory.createServer();
            logger.info("=========\u542f\u52a8FTP\u670d\u52a1\u6210\u529f");
            this.server.start();
        }
        catch (FtpException e) {
            logger.error("=========\u542f\u52a8FTP\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
    }
}

