/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.client.manage;

import cn.yto.cache.GatewayInfoCacheService;
import cn.yto.cache.LatticeCacheService;
import cn.yto.config.WcsClientConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.manage.NettyClientManage;
import cn.yto.netty.client.plc.PlcNettyClient;
import cn.yto.netty.client.tcp.TcpNettyClientObj;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NettyClientinitializer {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private WcsClientConfig wcsClientConfig;
    @Autowired
    private GatewayInfoCacheService gatewayInfoCacheService;
    @Autowired
    private PlcNettyClient plcNettyClient;
    @Autowired
    private LatticeCacheService latticeCacheService;

    public void AutomaticPlcInit() {
        try {
            if (this.wcsClientConfig.getStartUpPlcClientChannel() == 1) {
                logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u81ea\u52a8\u5316PLC\u5ba2\u6237\u7aef");
                this.plcNettyClient.init(-1);
                boolean connected = this.plcNettyClient.connect();
                if (!connected) {
                    System.exit(0);
                }
            }
        }
        catch (Exception e) {
            logger.info("\u81ea\u52a8\u5316PLC\u5ba2\u6237\u7aef\u542f\u52a8\u5931\u8d25,\u7aef\u53e3: " + this.wcsClientConfig.getPlcPort());
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void AutomaticThreeCodeInit() {
        try {
            if (this.wcsClientConfig.getThreeCodeStartUpChannel() == 1) {
                logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u4e09\u6bb5\u7801\u7f51\u5173\u5ba2\u6237\u7aef");
                if (NettyClientManage.getInstance().getThreeCodeInfo_NettyClient() == null || !NettyClientManage.getInstance().getThreeCodeInfo_NettyClient().IsConnected) {
                    TcpNettyClientObj item = new TcpNettyClientObj(this.wcsClientConfig.getThreeCodeIp(), this.wcsClientConfig.getThreeCodePort(), 1);
                    NettyClientManage.getInstance().setThreeCodeInfo_NettyClient(item);
                    NettyClientManage.getInstance().getThreeCodeInfo_NettyClient().Connect();
                    if (NettyClientManage.getInstance().getThreeCodeInfo_NettyClient().IsConnected) {
                        logger.info("\u4e09\u6bb5\u7801\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053\u542f\u52a8\u6210\u529f,IP\u7aef\u53e3:{}", (Object)(this.wcsClientConfig.getThreeCodeIp() + ":" + this.wcsClientConfig.getThreeCodePort()));
                    }
                }
            } else {
                logger.info("\u4e09\u6bb5\u7801\u7f51\u5173\u5ba2\u6237\u7aef\u5f00\u5173\u672a\u6253\u5f00\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void AutomaticSupplyExpressInit() {
        try {
            if (this.wcsClientConfig.getSupplyExpressStartUpChannel() == 1) {
                logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u4f9b\u4ef6\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053\u521d\u59cb\u5316");
                if (NettyClientManage.getInstance().getSupplyExpress_NettyClient() == null || !NettyClientManage.getInstance().getSupplyExpress_NettyClient().IsConnected) {
                    TcpNettyClientObj item = new TcpNettyClientObj(this.wcsClientConfig.getSupplyExpressIp(), this.wcsClientConfig.getSupplyExpressPort(), 2);
                    NettyClientManage.getInstance().setSupplyExpress_NettyClient(item);
                    NettyClientManage.getInstance().getSupplyExpress_NettyClient().Connect();
                    if (NettyClientManage.getInstance().getSupplyExpress_NettyClient().IsConnected) {
                        logger.info("\u4f9b\u4ef6\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053\u542f\u52a8\u6210\u529f,\u7aef\u53e3: " + this.wcsClientConfig.getSupplyExpressPort());
                    }
                }
            } else {
                logger.info("\u4f9b\u4ef6\u7f51\u5173\u5ba2\u6237\u7aef\u5f00\u5173\u672a\u6253\u5f00\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316");
            }
        }
        catch (Exception e) {
            logger.info("\u4f9b\u4ef6\u7f51\u5173\u901a\u9053\u542f\u52a8\u5931\u8d25,\u7aef\u53e3: " + this.wcsClientConfig.getSupplyExpressPort());
            e.printStackTrace();
        }
    }

    public void AutomaticFallLatticeInit() {
        try {
            if (this.wcsClientConfig.getFallLatticeStartUpChannel() == 1) {
                logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u843d\u683c\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053\u521d\u59cb\u5316");
                if (NettyClientManage.getInstance().getFallLattice_NettyClient() == null || !NettyClientManage.getInstance().getFallLattice_NettyClient().IsConnected) {
                    TcpNettyClientObj item = new TcpNettyClientObj(this.wcsClientConfig.getFallLatticeIp(), this.wcsClientConfig.getFallLatticePort(), 3);
                    NettyClientManage.getInstance().setFallLattice_NettyClient(item);
                    NettyClientManage.getInstance().getFallLattice_NettyClient().Connect();
                    if (NettyClientManage.getInstance().getFallLattice_NettyClient().IsConnected) {
                        logger.info("\u7f51\u5173\u843d\u683c\u5ba2\u6237\u7aef\u901a\u9053\u542f\u52a8\u6210\u529f,\u7aef\u53e3: " + this.wcsClientConfig.getFallLatticePort());
                    }
                }
            } else {
                logger.info("\u7f51\u5173\u843d\u683c\u5ba2\u6237\u7aef\u5f00\u5173\u672a\u6253\u5f00\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316");
            }
        }
        catch (Exception e) {
            logger.info("\u7f51\u5173\u843d\u683c\u5ba2\u6237\u7aef\u901a\u9053\u542f\u52a8\u5931\u8d25,\u7aef\u53e3: " + this.wcsClientConfig.getFallLatticePort());
            e.printStackTrace();
        }
    }

    public void MonitorTcpClientInit() {
        try {
            if (this.wcsClientConfig.getMonitorStartUpChannel() == 1) {
                logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u76d1\u63a7\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053");
                if (NettyClientManage.getInstance().getMonitor_NettyClient() == null || !NettyClientManage.getInstance().getMonitor_NettyClient().IsConnected) {
                    TcpNettyClientObj item = new TcpNettyClientObj(this.wcsClientConfig.getMonitorIp(), this.wcsClientConfig.getMonitorPort(), 4);
                    NettyClientManage.getInstance().setMonitor_NettyClient(item);
                    NettyClientManage.getInstance().getMonitor_NettyClient().Connect();
                    if (NettyClientManage.getInstance().getMonitor_NettyClient().IsConnected) {
                        logger.info("\u76d1\u63a7\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053\u542f\u52a8\u6210\u529f,\u7aef\u53e3: " + this.wcsClientConfig.getMonitorPort());
                    }
                }
            } else {
                logger.info("\u76d1\u63a7\u7f51\u5173\u5ba2\u6237\u7aef\u5f00\u5173\u672a\u6253\u5f00\uff0c\u4e0d\u8fdb\u884c\u521d\u59cb\u5316");
            }
        }
        catch (Exception e) {
            logger.info("\u76d1\u63a7\u7f51\u5173\u5ba2\u6237\u7aef\u901a\u9053\u542f\u52a8\u5931\u8d25,\u7aef\u53e3: " + this.wcsClientConfig.getMonitorPort());
            e.printStackTrace();
        }
    }

    public void initNettyClientObj() {
        logger.info("\u5f00\u59cb\u5224\u65ad\u662f\u5426\u8981\u521d\u59cb\u5316\u4e09\u6bb5\u7801\u7f51\u5173\u3001\u4f9b\u4ef6\u7f51\u5173\u3001\u843d\u683c\u7f51\u5173\u81ea\u52a8\u5316\u5206\u62e3\u901a\u9053");
        this.AutomaticPlcInit();
        this.AutomaticThreeCodeInit();
        this.AutomaticSupplyExpressInit();
        this.AutomaticFallLatticeInit();
        this.MonitorTcpClientInit();
    }
}

