/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.client.plc;

import cn.hutool.core.convert.Convert;
import cn.yto.config.WcsClientConfig;
import cn.yto.constants.MtyEnum;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.thread.DisposePlcRcvClientDataManageThread;
import cn.yto.netty.server.datastuct.DisposeGateWayImp;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientManage;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.utils.PlcHexUtils;
import cn.yto.service.MsgProcHelperService;
import cn.yto.service.log.ReqMonitorService;
import cn.yto.utils.ExpBeanUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.util.Iterator;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PlcGateWayClient
implements DisposeGateWayImp {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final Logger heartBeatLogger = CustomLoggerFactory.HeartBeatLogger();
    private SocketClientManage tcpClientList = new SocketClientManage();
    private Vector<SocketClientObj> tcpClients_Tmp = new Vector();
    private LinkedBlockingQueue<RcvDataObj> plc_rcv_queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor plcThreadPoolDisposeData;
    private int checkInterval = 0;
    @Autowired
    WcsClientConfig wcsClientConfig;
    @Value(value="${spring.profiles.active:default}")
    private String env;

    public SocketClientManage getTcpClientList() {
        return this.tcpClientList;
    }

    @PostConstruct
    public void init() {
        if (1 == this.wcsClientConfig.getStartUpPlcClientChannel()) {
            logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u7f51\u5173PLC\u7ebf\u7a0b\u6c60(\u5ba2\u6237\u7aef\u6a21\u5f0f)");
            this.plcThreadPoolDisposeData = new ThreadPoolExecutor(12, 20, 6L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30), new ThreadPoolExecutor.CallerRunsPolicy());
            new DisposePlcRcvClientDataManageThread(this.plcThreadPoolDisposeData, this.plc_rcv_queue).start();
            ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
            scheduledThreadPool.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    PlcGateWayClient.this.heartBeat();
                }
            }, 30L, 10L, TimeUnit.SECONDS);
        }
    }

    private void heartBeat() {
        try {
            int size = this.tcpClientList.size();
            if (size == 0) {
                if (this.needLog()) {
                    heartBeatLogger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u4e3a0,\u51c6\u5907\u91cd\u8fde,{}", (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
                }
                ExpBeanUtil.getPlcNettyClient().connect();
            } else if (size > 1) {
                int i = 0;
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this.tcpClientList.keySet()).iterator();
                while (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    SocketClientObj socketClientObj = (SocketClientObj)this.tcpClientList.get(k);
                    if (i > 0) {
                        if (this.needLog()) {
                            heartBeatLogger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u5927\u4e8e1,\u65ad\u5f00\u8fd9\u4e9b\u591a\u4f59\u8fde\u63a5,{}", (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
                        }
                        long beatCount = socketClientObj.getBeatCount();
                        if (this.needLog()) {
                            heartBeatLogger.info("PLC TCP\u8fde\u63a5:{},\u5fc3\u8df3\u6570:{}", (Object)(socketClientObj.channel.localAddress() + "->" + socketClientObj.remoteaddress), (Object)beatCount);
                        }
                        this.DoOnTcpClientDisconnect(socketClientObj.channel);
                    }
                    ++i;
                }
            } else if (size == 1) {
                SocketClientObj socketClientObj = null;
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this.tcpClientList.keySet()).iterator();
                if (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    socketClientObj = (SocketClientObj)this.tcpClientList.get(k);
                }
                if (socketClientObj == null) {
                    if (this.needLog()) {
                        heartBeatLogger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u4e3a1,\u672a\u83b7\u53d6\u8fde\u63a5,{}", (Object)size, (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
                    }
                    return;
                }
                long beatCount = socketClientObj.getBeatCount();
                if (beatCount != 3L && this.needLog()) {
                    heartBeatLogger.info("PLC TCP\u8fde\u63a5:{},\u5fc3\u8df3\u6570:{},{}", new Object[]{socketClientObj.channel.localAddress() + "->" + socketClientObj.remoteaddress, beatCount, "(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)"});
                }
                if (beatCount < 0L) {
                    if (this.needLog()) {
                        heartBeatLogger.info("\u5fc3\u8df3\u6570\u5c0f\u4e8e0,\u9700\u8981\u91cd\u8fde");
                    }
                    this.DoOnTcpClientDisconnect(socketClientObj.channel);
                    ExpBeanUtil.getPlcNettyClient().connect();
                    return;
                }
                socketClientObj.setBeatCount(--beatCount);
                String hex = MsgProcHelperService.genHeartBeatMessage(0, 0, Integer.parseInt(MtyEnum.PLC_HEART_BEAT.getKey()), 10);
                if (this.needLog()) {
                    heartBeatLogger.info("\u53d1\u9001\u5fc3\u8df3\u7ed9plc,HEX:{}", (Object)hex);
                }
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])Convert.hexToBytes((String)hex));
                socketClientObj.channel.writeAndFlush((Object)buf);
            } else if (this.needLog()) {
                heartBeatLogger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u4e3a{},{}", (Object)size, (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
            }
        }
        catch (Exception ex) {
            heartBeatLogger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    private void monitorConnection() {
        try {
            int size = this.tcpClientList.size();
            if (size == 0) {
                heartBeatLogger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u4e3a0,\u51c6\u5907\u91cd\u8fde,{}", (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
                ExpBeanUtil.getPlcNettyClient().connect();
            } else {
                int i = 0;
                Iterator iterator = ((ConcurrentHashMap.KeySetView)this.tcpClientList.keySet()).iterator();
                while (iterator.hasNext()) {
                    int k = (Integer)iterator.next();
                    SocketClientObj socketClientObj = (SocketClientObj)this.tcpClientList.get(k);
                    long beatCount = socketClientObj.getBeatCount();
                    logger.info("PLC TCP\u8fde\u63a5:{},\u5fc3\u8df3\u6570:{}", (Object)(socketClientObj.channel.localAddress() + "->" + socketClientObj.remoteaddress), (Object)beatCount);
                    socketClientObj.setBeatCount(--beatCount);
                    if (beatCount < 0L) {
                        logger.info("\u5fc3\u8df3\u6570\u5c0f\u4e8e0,\u9700\u8981\u91cd\u8fde");
                        this.DoOnTcpClientDisconnect(socketClientObj.channel);
                        ExpBeanUtil.getPlcNettyClient().connect();
                    }
                    if (i > 0) {
                        logger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u5927\u4e8e1,{}", (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
                        if (i >= 10) {
                            heartBeatLogger.info("\u4e0ePLC\u7684\u8fde\u63a5\u6570\u5927\u4e8e5,\u5f3a\u5236\u9000\u51fa,{}", (Object)"(\u8fd9\u79cd\u60c5\u51b5\u4e0d\u5e94\u8be5\u5b58\u5728,\u9700\u8981\u68c0\u67e5)");
                            System.exit(0);
                            return;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public boolean DoOnRcvTcpOnData(Channel channel, Object msg) {
        SocketClientObj tcpObj = (SocketClientObj)this.tcpClientList.get(channel.hashCode());
        if (tcpObj == null) {
            logger.info("\u5f02\u5e38IP|" + channel.remoteAddress().toString());
            return false;
        }
        tcpObj.m_lostDataTime = 0;
        if (channel.isOpen()) {
            byte[] rcvData = (byte[])msg;
            RcvDataObj rdObj = new RcvDataObj(rcvData, tcpObj);
            this.dispatchRcvQueue(rdObj);
        }
        return true;
    }

    @Override
    public boolean DoOnTcpClientDisconnect(Channel channel) {
        int idstr = channel.hashCode();
        SocketClientObj tcpConnclientObj = (SocketClientObj)this.tcpClientList.get(idstr);
        if (tcpConnclientObj != null) {
            tcpConnclientObj.close();
            this.tcpClientList.remove(idstr);
            if (this.needLog()) {
                heartBeatLogger.info("PLC TCP\u8fde\u63a5\u5df2\u65ad\u5f00:{}", (Object)(tcpConnclientObj.channel.localAddress() + "->" + tcpConnclientObj.remoteaddress));
            }
        }
        return true;
    }

    @Override
    public boolean DoOnTcpConnect(Channel channel) {
        SocketClientObj tcpConnclientObj = new SocketClientObj(channel, channel.remoteAddress());
        int hashCode = channel.hashCode();
        this.tcpClientList.put(hashCode, tcpConnclientObj);
        if (this.needLog()) {
            heartBeatLogger.info("PLC TCP\u5df2\u8fde\u63a5:{},\u5fc3\u8df3\u6570:{}", (Object)(tcpConnclientObj.channel.localAddress() + "->" + tcpConnclientObj.remoteaddress), (Object)tcpConnclientObj.getBeatCount());
        }
        return true;
    }

    private void CloseAllOtherTcp() {
        int size = this.tcpClients_Tmp.size();
        if (size > 0) {
            for (int i = this.tcpClients_Tmp.size() - 1; i >= 0; --i) {
                SocketClientObj obj = this.tcpClients_Tmp.elementAt(i);
                obj.close();
            }
        }
    }

    private void dispatchRcvQueue(RcvDataObj rdObj) {
        try {
            this.plc_rcv_queue.put(rdObj);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            ByteBuf buf = PlcHexUtils.error("500", ex.getMessage());
            rdObj.getClient().sendErrData(buf);
        }
    }

    public boolean sendData(String str) {
        try {
            Iterator iterator;
            int size = this.tcpClientList.size();
            SocketClientObj socketClientObj = null;
            if (size > 0 && (iterator = ((ConcurrentHashMap.KeySetView)this.tcpClientList.keySet()).iterator()).hasNext()) {
                int k = (Integer)iterator.next();
                socketClientObj = (SocketClientObj)this.tcpClientList.get(k);
            }
            if (socketClientObj != null && socketClientObj.channel.isOpen()) {
                ReqMonitorService.continueLog("\u7ed9plc\u53d1\u9001\u62a5\u6587\uff1a{}", str);
                socketClientObj.SendData(Convert.hexToBytes((String)str));
                return true;
            }
            ReqMonitorService.continueLog("\u5f53\u524d\u6ca1\u6709\u8fde\u63a5\u5230plc,\u8bf7\u7a0d\u540e\u91cd\u8bd5", new Object[0]);
            return false;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public boolean needLog() {
        return !"sit".equalsIgnoreCase(this.env);
    }
}

