/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.client.plc;

import cn.yto.config.WcsClientConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.plc.PlcGateWayClient;
import cn.yto.netty.client.plc.PlcNettyClientHandler;
import cn.yto.netty.server.plc.PlcGatewayDataDecoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlcNettyClient {
    @Autowired
    WcsClientConfig wcsClientConfig;
    @Autowired
    PlcGateWayClient plcGateWayClient;
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final Logger heartBeatLogger = CustomLoggerFactory.HeartBeatLogger();
    private EventLoopGroup workerGroup;
    private Bootstrap bootstrap;
    private volatile Channel clientChannel;

    public void init(int threads) {
        this.workerGroup = threads > 0 ? new NioEventLoopGroup(threads) : new NioEventLoopGroup();
        this.bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)30000)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new PlcGatewayDataDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{new PlcNettyClientHandler(PlcNettyClient.this.plcGateWayClient)});
            }
        });
    }

    public boolean connect() {
        String plcIP = this.wcsClientConfig.getPlcIP();
        Integer plcPort = this.wcsClientConfig.getPlcPort();
        if (this.plcGateWayClient.needLog()) {
            heartBeatLogger.info("\u51c6\u5907\u8fde\u63a5PLC\u670d\u52a1\u5668 : {}:{}", (Object)plcIP, (Object)plcPort);
        }
        try {
            ChannelFuture channelFuture = this.bootstrap.connect(plcIP, plcPort.intValue());
            boolean notTimeout = channelFuture.awaitUninterruptibly(30L, TimeUnit.SECONDS);
            this.clientChannel = channelFuture.channel();
            if (notTimeout) {
                if (this.clientChannel != null && this.clientChannel.isActive()) {
                    if (this.plcGateWayClient.needLog()) {
                        heartBeatLogger.info("{} \u6210\u529f\u8fde\u63a5PLC\u670d\u52a1\u5668", (Object)this.clientChannel.localAddress());
                    }
                    return true;
                }
                Throwable cause = channelFuture.cause();
                if (cause != null) {
                    this.exceptionHandler(cause);
                }
            } else {
                heartBeatLogger.warn("\u8fde\u63a5PLC\u670d\u52a1\u5668[{}]\u8d85\u65f6{}s", (Object)this.clientChannel.remoteAddress(), (Object)30);
            }
        }
        catch (Exception e) {
            this.exceptionHandler(e);
        }
        this.clientChannel.close();
        return false;
    }

    private void exceptionHandler(Throwable cause) {
        if (cause instanceof ConnectException) {
            heartBeatLogger.error(" \u8fde\u63a5\u5f02\u5e38 :{}", (Object)cause.getMessage());
        } else if (cause instanceof ClosedChannelException) {
            heartBeatLogger.error("\u8fde\u63a5\u5f02\u5e38:{}", (Object)"\u5ba2\u6237\u7aef\u5df2\u5173\u95ed");
        } else {
            heartBeatLogger.error("\u8fde\u63a5\u5f02\u5e38:", cause);
        }
        heartBeatLogger.error(cause.getMessage(), cause);
    }

    public void close() {
        if (this.clientChannel != null) {
            this.clientChannel.close();
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
    }

    public Channel getChannel() {
        return this.clientChannel;
    }
}

