/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.client.tcp;

import java.io.UnsupportedEncodingException;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpNettyClientDataDecoder
extends FrameDecoder {
    private static final Logger logger = LoggerFactory.getLogger(TcpNettyClientDataDecoder.class);

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        byte[] data = null;
        while (this.searchHead(buffer)) {
            try {
                int buffLen = buffer.readableBytes();
                if (buffLen < 30) {
                    return null;
                }
                int index = buffer.readerIndex();
                byte[] dataLenBytes = new byte[8];
                buffer.getBytes(index, dataLenBytes);
                int dataLen = Integer.parseInt(this.toString(dataLenBytes));
                data = new byte[dataLen + 8];
                buffer.readBytes(data);
                logger.info("\u6536\u5230\u5408\u6cd5\u62a5\u6587\uff1a" + this.toString(data));
                break;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                buffer.skipBytes(1);
            }
        }
        return data;
    }

    private boolean searchHead(ChannelBuffer buffer) throws Exception {
        int buffLen = buffer.readableBytes();
        if (buffLen < 8) {
            return false;
        }
        int readIndex = buffer.readerIndex();
        byte[] dataLenBytes = new byte[8];
        for (int i = 0; i < buffLen; ++i) {
            try {
                buffer.getBytes(readIndex + i, dataLenBytes);
                int dataLen = Integer.parseInt(this.toString(dataLenBytes));
                byte startHead = buffer.getByte(readIndex + i + 8);
                if (startHead != 123) {
                    buffer.skipBytes(1);
                    return false;
                }
                if (dataLen <= 0 || dataLen > 5096) {
                    buffer.skipBytes(1);
                    return false;
                }
                return buffer.readableBytes() >= dataLen + 8;
            }
            catch (Exception e) {
                buffer.skipBytes(1);
                continue;
            }
        }
        return false;
    }

    public String toString(byte[] data) {
        String result = "";
        try {
            result = new String(data, "gbk");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

