/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.client.tcp;

import cn.yto.cache.GatewayInfoCacheService;
import cn.yto.entity.BaseResponse;
import cn.yto.entity.busigateway.listener.FallLatticeEvent;
import cn.yto.entity.busigateway.listener.SupplyExpressEvent;
import cn.yto.entity.busigateway.listener.ThreeCodeEvent;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.manage.NettyClientManage;
import cn.yto.netty.client.tcp.GatewayClientHandler;
import cn.yto.netty.client.tcp.TcpNettyClientDataDecoder;
import cn.yto.netty.utils.NettyTools;
import cn.yto.utils.DateUtil;
import cn.yto.utils.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictorFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.slf4j.Logger;
import org.springframework.context.ApplicationEvent;

public class TcpNettyClientObj {
    private static final Logger logger = CustomLoggerFactory.HeartBeatLogger();
    public Channel tcpChannel = null;
    public int m_ChannelBufferLen = 0;
    protected byte[] m_recvBuf = new byte[this.MAXBUFLEN];
    protected int MAXBUFLEN = 30720000;
    protected int m_recvBufLen = 0;
    protected int MAXPACKLEN = 4096;
    private int type;
    public boolean IsConnected = false;
    private String remoteAddress;
    private int remotePort;
    private long m_LostDataTime_FallLattice;
    private long m_LostDataTime_SupplyExpress;
    private long m_LostDataTime_ThreeCode;
    private GatewayClientHandler gatewayClientHandler;
    private ClientBootstrap bootstrap;
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private static GatewayInfoCacheService gatewayInfoCacheService;
    private static ThreadPoolExecutor executor;
    private static ChannelFactory factory;

    public static GatewayInfoCacheService getGatewayInfoCacheService() {
        if (gatewayInfoCacheService == null) {
            gatewayInfoCacheService = SpringUtil.getBean(GatewayInfoCacheService.class);
        }
        return gatewayInfoCacheService;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getType() {
        return this.type;
    }

    public TcpNettyClientObj(String remoteAddress, int remotePort, int itype) {
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.type = itype;
        this.init();
    }

    private void init() {
        this.gatewayClientHandler = new GatewayClientHandler(this);
        this.bootstrap = new ClientBootstrap(factory);
        this.bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline((ChannelHandler[])new ChannelHandler[]{new TcpNettyClientDataDecoder(), TcpNettyClientObj.this.gatewayClientHandler});
            }
        });
        this.bootstrap.setOption("keepAlive", (Object)false);
        this.bootstrap.setOption("tcpNoDelay", (Object)false);
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)true);
        this.bootstrap.setOption("connectTimeoutMillis", (Object)60000);
        this.bootstrap.setOption("sendBufferSize", (Object)10000);
        this.bootstrap.setOption("receiveBufferSize", (Object)10240);
        this.bootstrap.setOption("receiveBufferSizePredictorFactory", (Object)new FixedReceiveBufferSizePredictorFactory(0x100000));
        this.bootstrap.setOption("writeBufferLowWaterMark", (Object)65536);
        this.bootstrap.setOption("writeBufferHighWaterMark", (Object)0x100000);
    }

    public void Connect() {
        try {
            this.m_recvBufLen = 0;
            this.m_ChannelBufferLen = 0;
            String IP = this.remoteAddress;
            int Port = this.remotePort;
            logger.info("\u670d\u52a1[" + this.remoteAddress + ":" + Port + "]\u6b63\u5728\u8fde\u63a5...");
            ChannelFuture channelFuture = this.bootstrap.connect((SocketAddress)new InetSocketAddress(IP, Port));
            channelFuture.awaitUninterruptibly(1L, TimeUnit.SECONDS);
            if (channelFuture.isSuccess()) {
                logger.info("\u670d\u52a1[" + this.remoteAddress + ":" + Port + "]\u8fde\u63a5\u6210\u529f");
                this.IsConnected = Boolean.TRUE;
                this.gatewayClientHandler.isDisconnect = false;
                if (this.type == 1) {
                    this.m_LostDataTime_ThreeCode = System.currentTimeMillis();
                    if (Objects.nonNull(TcpNettyClientObj.getGatewayInfoCacheService())) {
                        TcpNettyClientObj.getGatewayInfoCacheService().refreshThreeCodeSystemInfo();
                    }
                } else if (this.type == 2) {
                    this.m_LostDataTime_SupplyExpress = System.currentTimeMillis();
                    if (Objects.nonNull(TcpNettyClientObj.getGatewayInfoCacheService())) {
                        TcpNettyClientObj.getGatewayInfoCacheService().refreshOptInSystemInfo();
                    }
                } else if (this.type == 3) {
                    this.m_LostDataTime_FallLattice = System.currentTimeMillis();
                    if (Objects.nonNull(TcpNettyClientObj.getGatewayInfoCacheService())) {
                        TcpNettyClientObj.getGatewayInfoCacheService().refreshOptOutSystemInfo();
                    }
                }
            } else {
                logger.info("\u670d\u52a1[" + this.remoteAddress + ":" + Port + "]\u8fde\u63a5\u5931\u8d25");
                this.IsConnected = Boolean.FALSE;
                this.gatewayClientHandler.isDisconnect = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.info("\u670d\u52a1[" + this.remoteAddress + "]\u8fde\u63a5\u51fa\u9519:" + e.getClass().getName() + ":" + e.getMessage());
        }
    }

    public void Close() {
        this.IsConnected = false;
        if (this.tcpChannel != null) {
            this.tcpChannel.close();
        }
    }

    public void SendData(byte[] data) throws Exception {
        if (this.tcpChannel != null && this.tcpChannel.isOpen() && this.tcpChannel.isConnected()) {
            ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])data);
            if (this.tcpChannel.isWritable()) {
                this.tcpChannel.write((Object)channelBuffer);
                logger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ",\u6570\u636e\u5305\uff1a" + this.toString(data));
            } else {
                channelBuffer.clear();
                logger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ", \u7f13\u51b2\u961f\u5217\u5df2\u6ee1");
            }
        }
    }

    public boolean SendData(Logger ownLogger, String msg) throws Exception {
        if (ownLogger == null) {
            ownLogger = logger;
        }
        ownLogger.info("\u51c6\u5907\u53d1\u9001\u6570\u636e:" + msg);
        if (this.tcpChannel != null) {
            if (this.tcpChannel.isOpen() && this.tcpChannel.isConnected()) {
                this.sendMsg(ownLogger, msg);
                return true;
            }
            ownLogger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5");
        } else {
            ownLogger.info("\u5f53\u524d\u901a\u9053\u4e3anull,\u5c06\u5c1d\u8bd5\u91cd\u8fde");
            if (this.type == 1 && NettyClientManage.getInstance().getThreeCodeInfo_NettyClient() != null) {
                NettyClientManage.getInstance().getThreeCodeInfo_NettyClient().Connect();
                if (this.IsConnected) {
                    this.sendMsg(ownLogger, msg);
                    return true;
                }
                logger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5,\u4e0d\u53d1\u9001\u6570\u636e");
            }
            if (this.type == 2 && NettyClientManage.getInstance().getSupplyExpress_NettyClient() != null) {
                NettyClientManage.getInstance().getSupplyExpress_NettyClient().Connect();
                if (this.IsConnected) {
                    this.sendMsg(ownLogger, msg);
                    return true;
                }
                logger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5,\u4e0d\u53d1\u9001\u6570\u636e");
            }
            if (this.type == 3 && NettyClientManage.getInstance().getFallLattice_NettyClient() != null) {
                NettyClientManage.getInstance().getFallLattice_NettyClient().Connect();
                if (this.IsConnected) {
                    this.sendMsg(ownLogger, msg);
                    return true;
                }
                logger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5,\u4e0d\u53d1\u9001\u6570\u636e");
            }
            if (this.type == 4 && NettyClientManage.getInstance().getMonitor_NettyClient() != null) {
                NettyClientManage.getInstance().getMonitor_NettyClient().Connect();
                if (this.IsConnected) {
                    this.sendMsgForMonitor(ownLogger, msg);
                    return true;
                }
                logger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5,\u4e0d\u53d1\u9001\u6570\u636e");
            }
        }
        return false;
    }

    private void sendMsg(Logger ownLogger, String msg) throws UnsupportedEncodingException {
        String temp = msg + "\r\n";
        byte[] data = temp.getBytes("GBK");
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])data);
        if (this.tcpChannel.isWritable()) {
            this.tcpChannel.write((Object)channelBuffer);
            ownLogger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ",\u6570\u636e\u5305\uff1a" + this.toString(data));
        } else {
            channelBuffer.clear();
            ownLogger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ", \u7f13\u51b2\u961f\u5217\u5df2\u6ee1");
        }
    }

    private void sendMsgForMonitor(Logger ownLogger, String msg) {
        byte[] data = msg.getBytes();
        ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])data);
        if (this.tcpChannel.isWritable()) {
            this.tcpChannel.write((Object)channelBuffer);
            ownLogger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ",\u6570\u636e\u5305\uff1a" + this.toString(data));
        } else {
            channelBuffer.clear();
            ownLogger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ", \u7f13\u51b2\u961f\u5217\u5df2\u6ee1");
        }
    }

    public boolean SendDataFuture(String msg) throws Exception {
        logger.info("\u51c6\u5907\u53d1\u9001\u6570\u636e:" + msg);
        if (this.tcpChannel != null) {
            if (this.tcpChannel.isOpen() && this.tcpChannel.isConnected()) {
                String temp = msg + "\r\n";
                byte[] data = temp.getBytes();
                ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])data);
                if (this.tcpChannel.isWritable()) {
                    long startTime;
                    long l;
                    ChannelFuture write = this.tcpChannel.write((Object)channelBuffer);
                    boolean success = write.isSuccess();
                    if (success || (l = DateUtil.secondDifference(startTime = System.currentTimeMillis(), System.currentTimeMillis())) > 3L || (success = write.isSuccess())) {
                        // empty if block
                    }
                    logger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ",\u6570\u636e\u5305\uff1a" + this.toString(data));
                    return success;
                }
                channelBuffer.clear();
                logger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ", \u7f13\u51b2\u961f\u5217\u5df2\u6ee1");
            } else {
                logger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5");
            }
        } else {
            logger.info("\u5f53\u524d\u901a\u9053\u4e3anull,\u4e0d\u53d1\u9001\u6570\u636e");
        }
        return true;
    }

    public BaseResponse SendDataCache(String msg, String key) throws Exception {
        BaseResponse resp = new BaseResponse();
        logger.info("\u51c6\u5907\u53d1\u9001\u6570\u636e(\u963b\u585e\u65b9\u5f0f):" + msg);
        if (this.tcpChannel != null) {
            if (this.tcpChannel.isOpen() && this.tcpChannel.isConnected()) {
                String temp = msg + "\r\n";
                byte[] data = temp.getBytes();
                ChannelBuffer channelBuffer = ChannelBuffers.wrappedBuffer((byte[])data);
                if (this.tcpChannel.isWritable()) {
                    NettyTools.initReceiveMsg(key);
                    this.tcpChannel.write((Object)channelBuffer);
                    resp = NettyTools.waitReceiveMsg(key);
                } else {
                    channelBuffer.clear();
                    logger.info("\u53d1\u9001\u7f51\u5173\uff1a" + this.getRemoteAddress() + ":" + this.getRemotePort() + ", \u7f13\u51b2\u961f\u5217\u5df2\u6ee1");
                    resp.setCode("100");
                    resp.setMsg("\u63a8\u9001WCS\u5931\u8d25,\u7f13\u51b2\u961f\u5217\u5df2\u6ee1");
                }
            } else {
                logger.info("\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5");
                resp.setCode("100");
                resp.setMsg("\u63a8\u9001WCS\u5931\u8d25,\u5f53\u524d\u901a\u9053\u672a\u6253\u5f00\u6216\u672a\u8fde\u63a5");
            }
        } else {
            logger.info("\u5f53\u524d\u901a\u9053\u4e3anull,\u4e0d\u53d1\u9001\u6570\u636e");
            resp.setCode("100");
            resp.setMsg("\u63a8\u9001WCS\u5931\u8d25,\u5f53\u524d\u901a\u9053\u4e3a\u7a7a");
        }
        return resp;
    }

    public void procData(byte[] data) throws UnsupportedEncodingException {
        String temp = this.toString(data);
        JSONObject json = JSONObject.parseObject((String)temp.substring(8));
        switch (this.type) {
            case 1: {
                this.m_LostDataTime_ThreeCode = System.currentTimeMillis();
                SpringUtil.getApplicationContext().publishEvent((ApplicationEvent)new ThreeCodeEvent(this, json));
                break;
            }
            case 2: {
                this.m_LostDataTime_SupplyExpress = System.currentTimeMillis();
                SpringUtil.getApplicationContext().publishEvent((ApplicationEvent)new SupplyExpressEvent(this, json));
                break;
            }
            case 3: {
                this.m_LostDataTime_FallLattice = System.currentTimeMillis();
                SpringUtil.getApplicationContext().publishEvent((ApplicationEvent)new FallLatticeEvent(this, json));
            }
        }
    }

    public String toString(byte[] data) {
        String result = "";
        try {
            result = new String(data, "GB18030");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String data = "{\"wayBill_NO\":\"code000000\",\"weight\":1.5,\"length\":90,\"width\":60,\"height\":50,\"respCode\":\"000\",\"resMessage\":\"success\",\"type\":\"1\"}";
        System.out.println(data.getBytes().length);
        System.out.println(data);
    }

    public long getM_LostDataTime_FallLattice() {
        return this.m_LostDataTime_FallLattice;
    }

    public void setM_LostDataTime_FallLattice(long m_LostDataTime_FallLattice) {
        this.m_LostDataTime_FallLattice = m_LostDataTime_FallLattice;
    }

    public long getM_LostDataTime_SupplyExpress() {
        return this.m_LostDataTime_SupplyExpress;
    }

    public void setM_LostDataTime_SupplyExpress(long m_LostDataTime_SupplyExpress) {
        this.m_LostDataTime_SupplyExpress = m_LostDataTime_SupplyExpress;
    }

    public long getM_LostDataTime_ThreeCode() {
        return this.m_LostDataTime_ThreeCode;
    }

    public void setM_LostDataTime_ThreeCode(long m_LostDataTime_ThreeCode) {
        this.m_LostDataTime_ThreeCode = m_LostDataTime_ThreeCode;
    }

    static {
        factory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        executor = new ThreadPoolExecutor(5, 10, 2L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

