/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.client.thread;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.HexUtil;
import cn.yto.cache.LatticeBindCacheService;
import cn.yto.communication.plc.receive.ReceiveCartStatusComm;
import cn.yto.communication.plc.receive.ReceiveDeviceRunComm;
import cn.yto.communication.plc.receive.ReceiveDeviceSelfStatusComm;
import cn.yto.communication.plc.receive.ReceiveLatticeStatusComm;
import cn.yto.communication.plc.receive.ReceiveLockLatticeComm;
import cn.yto.communication.plc.receive.ReceiveOperateCartComm;
import cn.yto.communication.plc.receive.ReceiveOutComm;
import cn.yto.communication.plc.receive.ReceiveUnlockLatticeComm;
import cn.yto.constants.MtyEnum;
import cn.yto.constants.PlcRespCodeEnum;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.utils.PlcHexUtils;
import cn.yto.service.MsgProcHelperService;
import cn.yto.service.lattice.LatticeBindService;
import cn.yto.service.log.ReqMonitorService;
import cn.yto.utils.SpringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.slf4j.Logger;

public class DisposePlcRcvClientDataItemThread
implements Runnable {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    private static final Logger heartBeatLogger = CustomLoggerFactory.HeartBeatLogger();
    private SocketClientObj tcpObj = null;
    private RcvDataObj dataObj = null;
    private static ReceiveOutComm receiveOutComm;
    private static ReceiveDeviceSelfStatusComm receiveDeviceSelfStatusComm;
    private static ReceiveLockLatticeComm receiveLockLatticeComm;
    private static ReceiveLatticeStatusComm latticeStatusComm;
    private static ReceiveDeviceRunComm receiveDeviceRunComm;
    private static ReceiveOperateCartComm operateCartComm;
    private static ReceiveCartStatusComm cartStatusComm;
    private static ReceiveUnlockLatticeComm receiveUnlockLatticeComm;
    private static LatticeBindCacheService latticeBindCacheService;
    private static LatticeBindService latticeBindService;
    public boolean running = false;

    public DisposePlcRcvClientDataItemThread() {
    }

    public DisposePlcRcvClientDataItemThread(RcvDataObj dataObj) {
        this.dataObj = dataObj;
        this.running = true;
    }

    public DisposePlcRcvClientDataItemThread(boolean _running, SocketClientObj _tcpObj) {
        this.running = _running;
        this.tcpObj = _tcpObj;
    }

    public static ReceiveOutComm getReceiveOutComm() {
        if (receiveOutComm == null) {
            receiveOutComm = SpringUtil.getBean(ReceiveOutComm.class);
        }
        return receiveOutComm;
    }

    public static ReceiveDeviceSelfStatusComm getReceiveSelfStausComm() {
        if (receiveDeviceSelfStatusComm == null) {
            receiveDeviceSelfStatusComm = SpringUtil.getBean(ReceiveDeviceSelfStatusComm.class);
        }
        return receiveDeviceSelfStatusComm;
    }

    public static ReceiveLockLatticeComm getReceiveLockLatticeComm() {
        if (receiveLockLatticeComm == null) {
            receiveLockLatticeComm = SpringUtil.getBean(ReceiveLockLatticeComm.class);
        }
        return receiveLockLatticeComm;
    }

    public static ReceiveLatticeStatusComm getLatticeStatusComm() {
        if (latticeStatusComm == null) {
            latticeStatusComm = SpringUtil.getBean(ReceiveLatticeStatusComm.class);
        }
        return latticeStatusComm;
    }

    public static ReceiveDeviceRunComm getDeviceRunComm() {
        if (receiveDeviceRunComm == null) {
            receiveDeviceRunComm = SpringUtil.getBean(ReceiveDeviceRunComm.class);
        }
        return receiveDeviceRunComm;
    }

    public static ReceiveOperateCartComm getOperateCartComm() {
        if (operateCartComm == null) {
            operateCartComm = SpringUtil.getBean(ReceiveOperateCartComm.class);
        }
        return operateCartComm;
    }

    public static ReceiveCartStatusComm getCartStatusComm() {
        if (cartStatusComm == null) {
            cartStatusComm = SpringUtil.getBean(ReceiveCartStatusComm.class);
        }
        return cartStatusComm;
    }

    public static ReceiveUnlockLatticeComm getReceiveUnlockLatticeComm() {
        if (receiveUnlockLatticeComm == null) {
            receiveUnlockLatticeComm = SpringUtil.getBean(ReceiveUnlockLatticeComm.class);
        }
        return receiveUnlockLatticeComm;
    }

    public static LatticeBindCacheService getLatticeBindCacheService() {
        if (latticeBindCacheService == null) {
            latticeBindCacheService = SpringUtil.getBean(LatticeBindCacheService.class);
        }
        return latticeBindCacheService;
    }

    public static LatticeBindService getLatticeBindService() {
        if (latticeBindService == null) {
            latticeBindService = SpringUtil.getBean(LatticeBindService.class);
        }
        return latticeBindService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            ReqMonitorService.plcStart();
            String requestData = null;
            int mty = 0;
            try {
                byte[] data = this.dataObj.getData();
                requestData = PlcHexUtils.bytesToHex(data);
                ReqMonitorService.continueLog("PLC\u8bf7\u6c42:{}", requestData);
                String totalLengthHex = requestData.substring(4, 8);
                int totalLength = HexUtil.toBigInteger((String)totalLengthHex).intValue();
                String bodyHex = requestData.substring(16);
                String contentLengthHex = requestData.substring(16, 20);
                int contentLength = HexUtil.toBigInteger((String)contentLengthHex).intValue();
                String mtyHex = requestData.substring(20, 24);
                mty = HexUtil.toBigInteger((String)mtyHex).intValue();
                if (totalLength != contentLength + 8) {
                    String resp = PlcRespCodeEnum.MSG_LENGTH_ERROR.getKey();
                    ReqMonitorService.continueLog("PLC\u8bf7\u6c42\u957f\u5ea6\u6821\u9a8c\u5931\u8d25:{},\u6d88\u606f\u5934\u3001\u6d88\u606f\u4f53\u957f\u5ea6\u4e4b\u548c\u4e0d\u7b49\u4e8e\u62a5\u6587\u957f\u5ea6", resp);
                    String hex = MsgProcHelperService.genCommonRespMessage(mty, resp);
                    ByteBuf buf = Unpooled.wrappedBuffer((byte[])Convert.hexToBytes((String)hex));
                    ReqMonitorService.continueLog("\u54cd\u5e94PLC:{},\u54cd\u5e94\u4fe1\u606f\uff1a{}", PlcRespCodeEnum.MSG_LENGTH_ERROR.getKey(), PlcRespCodeEnum.MSG_LENGTH_ERROR.getValue());
                    ReqMonitorService.continueLog("\u54cd\u5e94PLC HEX:{}", hex);
                    this.dataObj.getClient().channel.writeAndFlush((Object)buf);
                    return;
                }
                if (MtyEnum.PLC_HEART_BEAT.getKey().equals(String.valueOf(mty))) {
                    heartBeatLogger.info("PLC\u8bf7\u6c42\u6d88\u606f\u7801:{}, \u6d88\u606f\u7c7b\u578b:{},\u6536\u5230\u5fc3\u8df3,{}", new Object[]{mty, MtyEnum.PLC_HEART_BEAT.getValue(), this.dataObj.getClient().remoteaddress + "->" + this.dataObj.getClient().channel.localAddress()});
                    this.dataObj.getClient().setBeatCount(3L);
                    return;
                }
                if (MtyEnum.PLC_SORT_OPT_OUT_RESP.getKey().equals(String.valueOf(mty))) {
                    if (bodyHex.length() < 70) {
                        ReqMonitorService.continueLog("PLC\u8bf7\u6c42\u6d88\u606f\u7801:{}, \u6d88\u606f\u7c7b\u578b:{},\u62a5\u6587\u957f\u5ea6\u4e0d\u591f", mty, MtyEnum.PLC_SORT_OPT_OUT_RESP.getValue());
                        String hex = MsgProcHelperService.genCommonRespMessage(mty, PlcRespCodeEnum.MSG_LENGTH_ERROR.getKey());
                        ByteBuf buf = Unpooled.wrappedBuffer((byte[])Convert.hexToBytes((String)hex));
                        ReqMonitorService.continueLog("\u54cd\u5e94PLC:{},\u54cd\u5e94\u4fe1\u606f:{}", PlcRespCodeEnum.MSG_LENGTH_ERROR.getKey(), PlcRespCodeEnum.MSG_LENGTH_ERROR.getValue());
                        ReqMonitorService.continueLog("\u54cd\u5e94PLC HEX:{}", hex);
                        this.dataObj.getClient().channel.writeAndFlush((Object)buf);
                        return;
                    }
                    DisposePlcRcvClientDataItemThread.getReceiveOutComm().processPlcFallLatticeMsg(bodyHex, this.dataObj);
                } else if (MtyEnum.LATTICE_STATUS_MSG.getKey().equals(String.valueOf(mty))) {
                    DisposePlcRcvClientDataItemThread.getLatticeStatusComm().processPlcLatticeStatusMsg(bodyHex, this.dataObj);
                } else if (MtyEnum.DEVICE_RUN_RESP.getKey().equals(String.valueOf(mty))) {
                    DisposePlcRcvClientDataItemThread.getDeviceRunComm().processDeviceRunMsg(bodyHex, this.dataObj);
                } else if (MtyEnum.SLEF_STATUS_RESP.getKey().equals(String.valueOf(mty))) {
                    DisposePlcRcvClientDataItemThread.getReceiveSelfStausComm().processSelfStatusMessage(bodyHex, this.dataObj);
                } else if (MtyEnum.OPER_CART_RESP.getKey().equals(String.valueOf(mty))) {
                    DisposePlcRcvClientDataItemThread.getOperateCartComm().processOperateCartCommMessage(bodyHex, this.dataObj);
                } else if (MtyEnum.CART_STATUS.getKey().equals(String.valueOf(mty))) {
                    DisposePlcRcvClientDataItemThread.getCartStatusComm().processCartStatusMsg(bodyHex, this.dataObj);
                } else if (MtyEnum.PLC_LOCK_LATTICE.getKey().equals(String.valueOf(mty))) {
                    DisposePlcRcvClientDataItemThread.getReceiveLockLatticeComm().processPlcLockLatticeMsg(bodyHex, this.dataObj);
                } else {
                    String resp = PlcRespCodeEnum.MSG_MTY_ERROR.getKey();
                    String hex = MsgProcHelperService.genCommonRespMessage(mty, resp);
                    ByteBuf buf = Unpooled.wrappedBuffer((byte[])Convert.hexToBytes((String)hex));
                    ReqMonitorService.continueLog("PLC\u8bf7\u6c42\u7c7b\u578b\u6821\u9a8c\u5931\u8d25:{},\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7801{}", resp, mty);
                    ReqMonitorService.continueLog("\u54cd\u5e94PLC:{},\u54cd\u5e94\u4fe1\u606f\uff1a{}", PlcRespCodeEnum.MSG_MTY_ERROR.getKey(), PlcRespCodeEnum.MSG_MTY_ERROR.getValue());
                    ReqMonitorService.continueLog("\u54cd\u5e94PLC HEX:{}", hex);
                    this.dataObj.getClient().channel.writeAndFlush((Object)buf);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                String hex = MsgProcHelperService.genCommonRespMessage(mty, PlcRespCodeEnum.MSG_CONTENT_ERROR.getKey());
                ByteBuf buf = Unpooled.wrappedBuffer((byte[])Convert.hexToBytes((String)hex));
                ReqMonitorService.continueLog("\u54cd\u5e94PLC:{},\u54cd\u5e94\u4fe1\u606f\uff1a{}", PlcRespCodeEnum.PLC_FAIL_SYSTEM_CODE.getKey(), PlcRespCodeEnum.PLC_FAIL_SYSTEM_CODE.getValue());
                ReqMonitorService.continueLog("\u54cd\u5e94PLC HEX:{}", hex);
                this.dataObj.getClient().channel.writeAndFlush((Object)buf);
            }
            finally {
                ReqMonitorService.plcEnd();
            }
        }
    }

    private static String splitStr(String str) {
        int length = str.length();
        String[] split = str.split("");
        StringBuffer buffer = new StringBuffer();
        for (String c : split) {
            buffer.append("\\" + c);
        }
        return buffer.toString();
    }
}

