/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.camera;

import cn.hutool.core.util.HexUtil;
import cn.yto.config.SystemConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.utils.PlcHexUtils;
import cn.yto.utils.SpringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;

public class CameraDataDecoder
extends ByteToMessageDecoder {
    Logger logger = CustomLoggerFactory.OperateLogger();
    private static SystemConfig systemConfig;

    public static SystemConfig getSystemConfig() {
        if (systemConfig == null) {
            systemConfig = SpringUtil.getBean(SystemConfig.class);
        }
        return systemConfig;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        while (this.searchHead(in)) {
            try {
                byte[] data;
                int buffLen = in.readableBytes();
                if (buffLen < 2) {
                    return;
                }
                String tcpOutEnd = CameraDataDecoder.getSystemConfig().getTcpOutEnd();
                String mode = CameraDataDecoder.getSystemConfig().getCommunicateMode();
                byte[] tcpEndbytes = tcpOutEnd.getBytes(StandardCharsets.UTF_8);
                if ("2".equals(mode)) {
                    tcpEndbytes = HexUtil.decodeHex((String)tcpOutEnd);
                    data = new byte[buffLen + tcpEndbytes.length];
                    in.readBytes(data, 0, buffLen);
                    System.arraycopy(tcpEndbytes, 0, data, buffLen, tcpEndbytes.length);
                    String dataHex = PlcHexUtils.bytesToHex(data);
                    this.logger.info("Netty\u6536\u5230CAMERA\u62a5\u6587:{}", (Object)dataHex);
                } else {
                    tcpEndbytes = tcpOutEnd.getBytes(StandardCharsets.UTF_8);
                    data = new byte[buffLen + tcpEndbytes.length];
                    in.readBytes(data, 0, buffLen);
                    System.arraycopy(tcpEndbytes, 0, data, buffLen, tcpEndbytes.length);
                    this.logger.info("Netty\u6536\u5230CAMERA\u62a5\u6587:{}", (Object)this.toString(data));
                }
                ctx.fireChannelRead((Object)data);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                in.skipBytes(1);
            }
        }
    }

    private boolean searchHead(ByteBuf buffer) throws Exception {
        int buffLen = buffer.readableBytes();
        String mode = CameraDataDecoder.getSystemConfig().getCommunicateMode();
        String msgHead = CameraDataDecoder.getSystemConfig().getTcpOutStart();
        if (buffLen < msgHead.length()) {
            return false;
        }
        int readIndex = buffer.readerIndex();
        byte[] bytesHead = "2".equals(mode) ? new byte[msgHead.length() / 2] : new byte[msgHead.length()];
        for (int i = 0; i < buffLen; ++i) {
            try {
                buffer.getBytes(readIndex + i, bytesHead);
                if ("2".equals(mode)) {
                    String head = PlcHexUtils.bytesToHex(bytesHead);
                    if (!head.equalsIgnoreCase(msgHead)) {
                        buffer.skipBytes(1);
                        return false;
                    }
                } else {
                    String head = new String(bytesHead);
                    if (!head.equals(msgHead)) {
                        buffer.skipBytes(1);
                        return false;
                    }
                }
                return true;
            }
            catch (Exception e) {
                buffer.skipBytes(1);
                continue;
            }
        }
        return false;
    }

    public String toString(byte[] data) {
        String result = "";
        try {
            result = new String(data, "GB18030");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

