/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.camera;

import cn.yto.config.CameraConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.DisposeGateWayImp;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientManage;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.server.thread.DisposeCameraRcvClientDataManageThread;
import cn.yto.netty.utils.PlcHexUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CameraGateWay
implements DisposeGateWayImp {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private SocketClientManage tcpClientList = new SocketClientManage();
    private Vector<SocketClientObj> tcpClients_Tmp = new Vector();
    private LinkedBlockingQueue<RcvDataObj> camera_rcv_queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor cameraThreadPoolDisposeData;
    public static ConcurrentHashMap<Integer, String> ipConnectMap = new ConcurrentHashMap();
    private int checkInterval = 0;
    @Autowired
    CameraConfig cameraConfig;

    @PostConstruct
    public void init() {
        if (this.cameraConfig.getCameraStartUpChannel() == 1) {
            logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u76f8\u673a\u901a\u4fe1\u5904\u7406\u7ebf\u7a0b\u6c60");
            this.cameraThreadPoolDisposeData = new ThreadPoolExecutor(20, 35, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadPoolExecutor.CallerRunsPolicy());
            new DisposeCameraRcvClientDataManageThread(this.cameraThreadPoolDisposeData, this.camera_rcv_queue).start();
        }
    }

    @Override
    public boolean DoOnRcvTcpOnData(Channel channel, Object msg) {
        SocketClientObj tcpObj = (SocketClientObj)this.tcpClientList.get(channel.hashCode());
        if (tcpObj == null) {
            logger.info("\u5f02\u5e38IP|" + channel.remoteAddress().toString());
            return false;
        }
        tcpObj.m_lostDataTime = 0;
        if (channel.isOpen()) {
            byte[] rcvData = (byte[])msg;
            RcvDataObj rdObj = new RcvDataObj(rcvData, tcpObj);
            this.dispatchRcvQueue(rdObj);
        }
        return true;
    }

    @Override
    public boolean DoOnTcpClientDisconnect(Channel channel) {
        int idstr = channel.hashCode();
        SocketClientObj tcpConnclientObj = (SocketClientObj)this.tcpClientList.get(idstr);
        if (tcpConnclientObj != null) {
            tcpConnclientObj.close();
            this.tcpClientList.remove(idstr);
            ipConnectMap.remove(idstr);
            logger.info("\u6389\u7ebfCAMERA TCP\u8fde\u63a5:" + tcpConnclientObj.remoteaddress + "|\u5f53\u524dCAMERA TCP\u8fde\u63a5\u6570:" + this.tcpClientList.size());
        }
        return true;
    }

    @Override
    public boolean DoOnTcpConnect(Channel channel) {
        SocketClientObj tcpConnclientObj = new SocketClientObj(channel, channel.remoteAddress());
        int hashCode = channel.hashCode();
        this.tcpClientList.put(hashCode, tcpConnclientObj);
        logger.info("\u63a5\u6536\u4e00\u4e2aCAMERA TCP\u8fde\u63a5:{}," + tcpConnclientObj.remoteaddress + "|\u5f53\u524dCAMERA TCP\u8fde\u63a5\u6570:" + this.tcpClientList.size(), (Object)hashCode);
        try {
            String ip = ((NioSocketChannel)channel).remoteAddress().getAddress().getHostAddress();
            ipConnectMap.put(hashCode, ip);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6ip\u65f6\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return true;
    }

    public void DoonTimer() {
        this.checkInterval = ++this.checkInterval > Integer.MAX_VALUE ? 0 : this.checkInterval;
        this.CheckConnectClientTcp();
    }

    private void CheckConnectClientTcp() {
        try {
            this.tcpClients_Tmp.clear();
            Collection c = this.tcpClientList.values();
            for (SocketClientObj clientItem : c) {
                if (!clientItem.bLostData()) continue;
                this.tcpClients_Tmp.add(clientItem);
            }
            this.CloseAllOtherTcp();
        }
        catch (Exception ex) {
            logger.error("\u68c0\u6d4bPLC\u5ba2\u6237\u7aef\u5bf9\u8c61\u957f\u65f6\u95f4\u672a\u901a\u8baf\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
        }
    }

    private void CloseAllOtherTcp() {
        int size = this.tcpClients_Tmp.size();
        if (size > 0) {
            for (int i = this.tcpClients_Tmp.size() - 1; i >= 0; --i) {
                SocketClientObj obj = this.tcpClients_Tmp.elementAt(i);
                obj.close();
            }
        }
    }

    private void dispatchRcvQueue(RcvDataObj rdObj) {
        try {
            this.camera_rcv_queue.put(rdObj);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            ByteBuf buf = PlcHexUtils.error("500", ex.getMessage());
            rdObj.getClient().sendErrData(buf);
        }
    }
}

