/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.camera;

import cn.hutool.core.util.HexUtil;
import cn.yto.config.SystemConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.camera.CameraDataDecoder;
import cn.yto.netty.server.camera.CameraGateWay;
import cn.yto.netty.server.camera.CameraNettyServerHandler;
import cn.yto.utils.ExpUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CameraNettyServer {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workGroup = null;
    private ChannelFuture channelFuture = null;
    @Autowired
    private CameraGateWay gateWay;
    @Autowired
    private SystemConfig systemConfig;

    public void start(int port) {
        logger.info("\u5f00\u59cb\u7ed1\u5b9aNetty CAMERA\u670d\u52a1\u7aef\u7aef\u53e3{},\u7528\u4e8e\u76d1\u542cCAMERA\u8bf7\u6c42", (Object)port);
        this.systemConfig.initCameraCommParams();
        logger.info("CAMERA\u901a\u8baf\u6a21\u5f0f:{},\u622a\u53d6\u540e\u7684\u62a5\u6587\u5934:{}\uff0c\u62a5\u6587\u5c3e\u90e8:{}", new Object[]{this.systemConfig.getCommunicateMode(), this.systemConfig.getTcpOutStart(), this.systemConfig.getTcpOutEnd()});
        this.bind(port);
    }

    public void bind(int port) {
        this.bossGroup = new NioEventLoopGroup();
        this.workGroup = new NioEventLoopGroup();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(this.bossGroup, this.workGroup);
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                logger.info("\u6709\u4e00Camera\u5ba2\u6237\u7aef\u767b\u5f55\u5230\u672c\u670d\u52a1\u7aef\uff0c\u5ba2\u6237\u7aef\u5730\u5740\uff1a" + socketChannel.remoteAddress().getAddress() + ":" + socketChannel.remoteAddress().getPort() + "(" + socketChannel.remoteAddress().getHostName() + ")");
                String communicateMode = CameraNettyServer.this.systemConfig.getCommunicateMode();
                String tcpOutEnd = CameraNettyServer.this.systemConfig.getTcpOutEnd();
                if (ExpUtils.isNotBlank(tcpOutEnd)) {
                    if ("2".equals(communicateMode)) {
                        ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])HexUtil.decodeHex((String)tcpOutEnd));
                        socketChannel.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(1024, byteBuf)});
                    } else {
                        ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])tcpOutEnd.getBytes());
                        socketChannel.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(1024, byteBuf)});
                    }
                }
                socketChannel.pipeline().addLast(new ChannelHandler[]{new CameraDataDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new CameraNettyServerHandler(CameraNettyServer.this.gateWay)});
            }
        });
        this.channelFuture = serverBootstrap.bind(port);
    }

    public void close() {
        this.bossGroup.shutdownGracefully();
    }
}

