/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.datastuct;

import cn.yto.constants.MtyEnum;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.DisposeGateWayImp;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientManage;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.server.thread.DisposeRcvClientDataItemThread;
import cn.yto.netty.server.thread.DisposeRcvClientDataManageThread;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.ExpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class GateWay
implements DisposeGateWayImp {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final Logger operateLogger = CustomLoggerFactory.OperateLogger();
    private SocketClientManage tcpClientList = new SocketClientManage();
    public static ConcurrentHashMap<Integer, SocketClientObj> sdmConnects = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, String> tmwsConns = new ConcurrentHashMap();
    private Vector<SocketClientObj> tcpClients_Tmp = new Vector();
    private LinkedBlockingQueue<RcvDataObj> rcv_queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor threadPoolDisposeData;
    private int checkInterval = 0;

    public GateWay() {
        logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u7f51\u5173\u7ebf\u7a0b\u6c60");
        this.threadPoolDisposeData = new ThreadPoolExecutor(12, 20, 6L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(30), new ThreadPoolExecutor.CallerRunsPolicy());
        new DisposeRcvClientDataManageThread(this.threadPoolDisposeData, this.rcv_queue).start();
    }

    @Override
    public boolean DoOnRcvTcpOnData(Channel channel, Object msg) {
        SocketClientObj tcpObj = (SocketClientObj)this.tcpClientList.get(channel.hashCode());
        if (tcpObj == null) {
            logger.info("\u5f02\u5e38IP|" + channel.remoteAddress().toString());
            return false;
        }
        tcpObj.m_lostDataTime = 0;
        if (channel.isOpen()) {
            String requestData = (String)msg;
            byte[] rcvData = requestData.getBytes();
            RcvDataObj rdObj = new RcvDataObj(rcvData, tcpObj);
            this.dispatchRcvQueue(rdObj);
        }
        return true;
    }

    @Override
    public boolean DoOnTcpClientDisconnect(Channel channel) {
        int idstr = channel.hashCode();
        SocketClientObj tcpConnclientObj = (SocketClientObj)this.tcpClientList.get(idstr);
        if (tcpConnclientObj != null) {
            tcpConnclientObj.close();
            this.tcpClientList.remove(idstr);
            if (sdmConnects.containsKey(idstr)) {
                sdmConnects.remove(idstr);
            }
            if (tmwsConns.containsKey(idstr)) {
                tmwsConns.remove(idstr);
            }
            DisposeRcvClientDataItemThread.refreshSignature(channel.remoteAddress().toString().split("/")[0]);
            logger.info("\u6389\u7ebfTCP\u8fde\u63a5:" + tcpConnclientObj.remoteaddress + "|\u5f53\u524dTCP\u8fde\u63a5\u6570:" + this.tcpClientList.size());
        }
        return true;
    }

    @Override
    public boolean DoOnTcpConnect(Channel channel) {
        SocketClientObj tcpConnclientObj = new SocketClientObj(channel, channel.remoteAddress());
        int hashCode = channel.hashCode();
        this.tcpClientList.put(hashCode, tcpConnclientObj);
        logger.info("\u63a5\u6536\u4e00\u4e2aTCP\u8fde\u63a5:{}," + tcpConnclientObj.remoteaddress + "|\u5f53\u524dTCP\u8fde\u63a5\u6570:" + this.tcpClientList.size(), (Object)hashCode);
        return true;
    }

    public void DoonTimer() {
        this.checkInterval = ++this.checkInterval > Integer.MAX_VALUE ? 0 : this.checkInterval;
        this.CheckConnectClientTcp();
    }

    private void CheckConnectClientTcp() {
        try {
            this.tcpClients_Tmp.clear();
            Collection c = this.tcpClientList.values();
            for (SocketClientObj clientItem : c) {
                if (!clientItem.bLostData()) continue;
                this.tcpClients_Tmp.add(clientItem);
            }
            this.CloseAllOtherTcp();
        }
        catch (Exception ex) {
            logger.error("\u68c0\u6d4b\u5ba2\u6237\u7aef\u5bf9\u8c61\u957f\u65f6\u95f4\u672a\u901a\u8baf\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
        }
    }

    private void CloseAllOtherTcp() {
        int size = this.tcpClients_Tmp.size();
        if (size > 0) {
            for (int i = this.tcpClients_Tmp.size() - 1; i >= 0; --i) {
                SocketClientObj obj = this.tcpClients_Tmp.elementAt(i);
                obj.close();
            }
        }
    }

    private void dispatchRcvQueue(RcvDataObj rdObj) {
        try {
            String requestData = new String(rdObj.getData());
            if (requestData.substring(8).startsWith("{") && requestData.substring(8).endsWith("}")) {
                rdObj.setCreateTime(new Date());
                JSONObject jObject = JSON.parseObject((String)requestData.substring(8));
                this.rcv_queue.put(rdObj);
            } else {
                logger.warn("\u63a5\u6536\u5230\u975e\u6cd5\u683c\u5f0f\u62a5\u6587\uff1a" + requestData);
                rdObj.getClient().sendErrData(rdObj.getData());
            }
        }
        catch (Exception ex) {
            rdObj.getClient().sendErrData(rdObj.getData());
        }
    }

    public void sendSdmMsg(Integer connectionHashCode, String msg) {
        SocketClientObj socketClientObj = (SocketClientObj)this.tcpClientList.get(connectionHashCode);
        if (socketClientObj != null) {
            Channel channel = socketClientObj.channel;
            try {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)(msg + "\r\n"), (Charset)Charset.forName("gbk"));
                channel.writeAndFlush((Object)buf);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.error("\u672a\u627e\u5230\u8fde\u63a5:{}", (Object)connectionHashCode);
        }
    }

    public void sendSdmMsg(String msg) {
        if (CollectionUtils.isEmpty(sdmConnects)) {
            operateLogger.info("\u5f53\u524d\u4e09\u6bb5\u7801\u7f13\u5b58\u4e2d\u65e0\u8fde\u63a5");
            return;
        }
        long start = System.currentTimeMillis();
        Iterator<Map.Entry<Integer, SocketClientObj>> iterator = sdmConnects.entrySet().iterator();
        while (iterator.hasNext()) {
            SocketClientObj socketClientObj;
            Map.Entry<Integer, SocketClientObj> next = iterator.next();
            Integer channelId = next.getKey();
            if (Objects.isNull(channelId) || Objects.isNull(socketClientObj = sdmConnects.get(channelId)) || Objects.isNull(socketClientObj.channel)) continue;
            if (!socketClientObj.channel.isOpen()) {
                operateLogger.info("\u6839\u636echannelId:{},\u627e\u5230\u7684socket\u5bf9\u8c61\u901a\u9053\u672a\u6253\u5f00", (Object)channelId);
                iterator.remove();
                continue;
            }
            try {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)(msg + "\r\n"), (Charset)Charset.forName("gbk"));
                operateLogger.info("\u51c6\u5907\u53d1\u9001\u6d88\u606f\u7ed9\u4e09\u6bb5\u7801\u7f51\u5173:{}", (Object)msg);
                socketClientObj.channel.writeAndFlush((Object)buf);
                operateLogger.info("\u63a8\u9001\u7ed9\u4e09\u6bb5\u7801\u7f51\u5173\u6210\u529f,\u8017\u65f6:[{}]ms", (Object)(System.currentTimeMillis() - start));
            }
            catch (Exception e) {
                operateLogger.info("\u6d88\u606f\u63a8\u9001\u7ed9\u4e09\u6bb5\u7801\u7f51\u5173\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public void notifyAssignedTmwsMac(JSONObject jsonObject, List<String> macList) {
        if (CollectionUtils.isEmpty(tmwsConns)) {
            operateLogger.info("\u5f53\u524d\u6761\u7801\u5a01\u89c6\u4f9b\u4ef6\u53f0\u5ba2\u6237\u7aef\u7f13\u5b58\u4e3a\u7a7a...\u4e0d\u8fdb\u884c\u63a8\u9001");
            return;
        }
        String mty = jsonObject.getString("mty");
        if (ExpUtils.isBlank(mty)) {
            operateLogger.info("\u5f53\u524d\u6d88\u606f\u4e2d\u672a\u4f20\u6d88\u606f\u7801mty...\u4e0d\u8fdb\u884c\u63a8\u9001");
            return;
        }
        MtyEnum mtyEnum = MtyEnum.mtyEnumMap.get(mty);
        if (Objects.isNull((Object)mtyEnum)) {
            operateLogger.info("\u6682\u4e0d\u652f\u6301\u7684mty\u7801...");
            return;
        }
        switch (mtyEnum) {
            case PUSH_WEIGHT: {
                operateLogger.info("\u91cd\u91cf\u63a8\u9001\u5ba2\u6237\u7aef...");
                break;
            }
            case PUSH_FAULT: {
                operateLogger.info("\u6545\u969c\u63a8\u9001\u7ed9\u5ba2\u6237\u7aef...");
                break;
            }
            default: {
                operateLogger.info("\u6682\u4e0d\u652f\u6301\u7684mty\u7801...");
                return;
            }
        }
        Iterator<Map.Entry<Integer, String>> iterator = tmwsConns.entrySet().iterator();
        while (iterator.hasNext()) {
            SocketClientObj socketClientObj;
            Integer channelId;
            Map.Entry<Integer, String> entry = iterator.next();
            String mac = entry.getValue();
            if (!CollectionUtils.isEmpty(macList) && !macList.contains(mac) || Objects.isNull(channelId = entry.getKey()) || Objects.isNull(socketClientObj = (SocketClientObj)this.tcpClientList.get(channelId)) || Objects.isNull(socketClientObj.channel)) continue;
            if (!socketClientObj.channel.isOpen()) {
                operateLogger.info("\u6839\u636emac:{},channelId:{},\u627e\u5230\u7684socket\u5bf9\u8c61\u901a\u9053\u672a\u6253\u5f00", (Object)mac, (Object)channelId);
                iterator.remove();
                continue;
            }
            try {
                String msg = jsonObject.toJSONString();
                String dataLth = String.valueOf(msg.getBytes("gbk").length);
                dataLth = AdapterHelperUtil.renewItem(dataLth, 8);
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)(dataLth + msg), (Charset)Charset.forName("gbk"));
                socketClientObj.channel.writeAndFlush((Object)buf);
                operateLogger.info("\u6d88\u606f\u6570\u636e\u63a8\u9001\u6761\u7801\u536b\u89c6\u5ba2\u6237\u7aefMAC={} success, message={}", (Object)mac, (Object)(dataLth + msg));
            }
            catch (Exception e) {
                operateLogger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

