/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.datastuct;

import cn.yto.netty.server.tcp.NettyServerHandler;
import cn.yto.netty.utils.Common;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketClientObj {
    private static final Logger logger = LoggerFactory.getLogger(NettyServerHandler.class);
    public Channel channel = null;
    public SocketAddress remoteaddress;
    public boolean isDev = true;
    public String devIdStr;
    public int m_lostDataTime = 0;
    public byte[] rcvData = null;
    public static final long BEAT_COUNT_DEFAULT = 3L;
    public static final long BEAT_COUNT_LIMIT = 10000L;
    private long beatCount = 3L;

    public SocketClientObj(Channel _channel, SocketAddress _remoteAddress) {
        this.remoteaddress = _remoteAddress;
        this.channel = _channel;
    }

    public boolean SendData(byte[] sendData) {
        try {
            if (this.channel.isOpen()) {
                ByteBuf buf = Unpooled.buffer((int)sendData.length).writeBytes(sendData);
                this.channel.writeAndFlush((Object)buf);
                logger.debug(Common.toString(sendData));
            }
        }
        catch (Exception E) {
            logger.debug("Tcp Senddata to client Error:" + E.getMessage());
            this.close();
        }
        return true;
    }

    public boolean SendData(String sendData) {
        try {
            if (this.channel.isOpen()) {
                ByteBuf buf = Unpooled.copiedBuffer((CharSequence)sendData, (Charset)Charset.forName("gbk"));
                this.channel.writeAndFlush((Object)buf);
                logger.debug(sendData);
            }
        }
        catch (Exception E) {
            logger.debug("Tcp Senddata to client Error:" + E.getMessage());
            this.close();
        }
        return true;
    }

    public boolean sendErrData(ByteBuf buf) {
        try {
            if (this.channel.isOpen()) {
                this.channel.writeAndFlush((Object)buf);
            }
        }
        catch (Exception E) {
            logger.error("Tcp Senddata to client Error:" + E.getMessage());
            this.close();
        }
        return true;
    }

    public boolean sendErrData(byte[] sendData) {
        try {
            String errInfo = new String(sendData);
            errInfo = "\u975e\u6cd5\u62a5\u6587:".concat(errInfo).concat("\r\n");
            this.SendData(errInfo.getBytes("UTF-8"));
        }
        catch (Exception E) {
            logger.debug("Tcp Senddata to client Error:" + E.getMessage());
        }
        return true;
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            logger.debug("\u5173\u95ed\u8fde\u63a5\u5931\u8d25\uff01" + ex.getLocalizedMessage());
        }
    }

    public boolean bLostData() {
        int n = this.m_lostDataTime = this.m_lostDataTime < Integer.MAX_VALUE ? (this.m_lostDataTime = this.m_lostDataTime + 1) : 0;
        if (this.m_lostDataTime >= 10) {
            this.m_lostDataTime = 0;
            return true;
        }
        return false;
    }

    public void rcvData(byte[] rcvData) {
        this.rcvData = rcvData;
    }

    public long getBeatCount() {
        return this.beatCount;
    }

    public void setBeatCount(long beatCount) {
        this.beatCount = beatCount;
    }
}

