/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.plc;

import cn.yto.config.WcsClientConfig;
import cn.yto.config.WcsTcpServerConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.DisposeGateWayImp;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientManage;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.server.thread.DisposePlcRcvClientDataManageThread;
import cn.yto.netty.server.thread.DisposeRcvClientDataItemThread;
import cn.yto.netty.utils.MessageUtils;
import cn.yto.utils.ExpUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PlcGateWay
implements DisposeGateWayImp {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private SocketClientManage tcpClientList = new SocketClientManage();
    private Vector<SocketClientObj> tcpClients_Tmp = new Vector();
    public static ConcurrentHashMap<Integer, String> devNoConnectMap = new ConcurrentHashMap();
    private LinkedBlockingQueue<RcvDataObj> plc_rcv_queue = new LinkedBlockingQueue();
    private ThreadPoolExecutor plcThreadPoolDisposeData;
    private int checkInterval = 0;
    @Autowired
    WcsClientConfig wcsClientConfig;
    @Autowired
    WcsTcpServerConfig wcsTcpServerConfig;

    @PostConstruct
    public void init() {
        if (this.wcsTcpServerConfig.getPlcStartUpChannel() == 1) {
            logger.info("\u5f00\u59cb\u521d\u59cb\u5316\u7f51\u5173PLC\u7ebf\u7a0b\u6c60");
            this.plcThreadPoolDisposeData = new ThreadPoolExecutor(15, 25, 6L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(300), new ThreadPoolExecutor.CallerRunsPolicy());
            new DisposePlcRcvClientDataManageThread(this.plcThreadPoolDisposeData, this.plc_rcv_queue).start();
        }
    }

    @Override
    public boolean DoOnRcvTcpOnData(Channel channel, Object msg) {
        SocketClientObj tcpObj = (SocketClientObj)this.tcpClientList.get(channel.hashCode());
        if (tcpObj == null) {
            logger.info("\u5f02\u5e38IP|" + channel.remoteAddress().toString());
            return false;
        }
        tcpObj.m_lostDataTime = 0;
        if (channel.isOpen()) {
            byte[] rcvData = (byte[])msg;
            RcvDataObj rdObj = new RcvDataObj(rcvData, tcpObj);
            this.dispatchRcvQueue(rdObj);
        }
        return true;
    }

    @Override
    public boolean DoOnTcpClientDisconnect(Channel channel) {
        int idstr = channel.hashCode();
        SocketClientObj tcpConnclientObj = (SocketClientObj)this.tcpClientList.get(idstr);
        if (tcpConnclientObj != null) {
            tcpConnclientObj.close();
            this.tcpClientList.remove(idstr);
            if (devNoConnectMap.containsKey(idstr)) {
                devNoConnectMap.remove(idstr);
            }
            DisposeRcvClientDataItemThread.refreshSignature(channel.remoteAddress().toString().split("/")[0]);
            logger.info("\u6389\u7ebfPLC TCP\u8fde\u63a5:" + tcpConnclientObj.remoteaddress + "|\u5f53\u524dPLC TCP\u8fde\u63a5\u6570:" + this.tcpClientList.size());
        }
        return true;
    }

    @Override
    public boolean DoOnTcpConnect(Channel channel) {
        SocketClientObj tcpConnclientObj = new SocketClientObj(channel, channel.remoteAddress());
        int hashCode = channel.hashCode();
        this.tcpClientList.put(hashCode, tcpConnclientObj);
        logger.info("\u63a5\u6536\u4e00\u4e2aPLC TCP\u8fde\u63a5:{}," + tcpConnclientObj.remoteaddress + "|\u5f53\u524dPLC TCP\u8fde\u63a5\u6570:" + this.tcpClientList.size(), (Object)hashCode);
        return true;
    }

    public void DoonTimer() {
        this.checkInterval = ++this.checkInterval > Integer.MAX_VALUE ? 0 : this.checkInterval;
        this.CheckConnectClientTcp();
    }

    private void CheckConnectClientTcp() {
        try {
            this.tcpClients_Tmp.clear();
            Collection c = this.tcpClientList.values();
            for (SocketClientObj clientItem : c) {
                if (!clientItem.bLostData()) continue;
                this.tcpClients_Tmp.add(clientItem);
            }
            this.CloseAllOtherTcp();
        }
        catch (Exception ex) {
            logger.error("\u68c0\u6d4bPLC\u5ba2\u6237\u7aef\u5bf9\u8c61\u957f\u65f6\u95f4\u672a\u901a\u8baf\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
        }
    }

    private void CloseAllOtherTcp() {
        int size = this.tcpClients_Tmp.size();
        if (size > 0) {
            for (int i = this.tcpClients_Tmp.size() - 1; i >= 0; --i) {
                SocketClientObj obj = this.tcpClients_Tmp.elementAt(i);
                obj.close();
            }
        }
    }

    private void dispatchRcvQueue(RcvDataObj rdObj) {
        try {
            this.plc_rcv_queue.put(rdObj);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean sendMsg(String msg, String layerNo) {
        Iterator<Map.Entry<Object, Object>> iterator;
        if (this.tcpClientList.size() == 1 && (iterator = this.tcpClientList.entrySet().iterator()).hasNext()) {
            Map.Entry next = iterator.next();
            SocketClientObj socketClientObj = (SocketClientObj)next.getValue();
            if (Objects.nonNull(socketClientObj) && !socketClientObj.channel.isOpen()) {
                logger.info("\u6839\u636edevNo:{},\u627e\u5230\u7684socket\u5bf9\u8c61\u901a\u9053\u672a\u6253\u5f00", (Object)layerNo);
                this.tcpClientList.remove(socketClientObj.channel.hashCode());
                return false;
            }
            try {
                byte[] bytes = MessageUtils.buildResponseByte(msg);
                socketClientObj.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes));
                logger.info("\u6d88\u606f\u6570\u636e\u63a8\u9001\u5206\u62e3\u673aDEV_NO={}\u6210\u529f, message={}", (Object)layerNo, (Object)msg);
            }
            catch (Exception e) {
                logger.info("\u6d88\u606f\u6570\u636e\u63a8\u9001\u5206\u62e3\u673aDEV_NO={}\u5931\u8d25", (Object)layerNo, (Object)e);
                return false;
            }
            return true;
        }
        if (CollectionUtils.isEmpty(devNoConnectMap) || ExpUtils.isBlank(layerNo)) {
            logger.info("\u5f53\u524dPLC\u7f13\u5b58\u4e2d\u65e0\u8fde\u63a5");
            return false;
        }
        iterator = devNoConnectMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer channelId;
            Map.Entry<Object, Object> entry = iterator.next();
            String devNo = (String)entry.getValue();
            if (!layerNo.equals(devNo) || Objects.isNull(channelId = (Integer)entry.getKey())) continue;
            SocketClientObj socketClientObj = (SocketClientObj)this.tcpClientList.get(channelId);
            if (Objects.isNull(socketClientObj) || Objects.isNull(socketClientObj.channel)) {
                logger.info("\u6839\u636edevNo:{},channelId:{},\u672a\u627esocket\u5bf9\u8c61", (Object)devNo, (Object)channelId);
                continue;
            }
            if (!socketClientObj.channel.isOpen()) {
                logger.info("\u6839\u636edevNo:{},channelId:{},\u627e\u5230\u7684socket\u5bf9\u8c61\u901a\u9053\u672a\u6253\u5f00", (Object)devNo, (Object)channelId);
                iterator.remove();
                continue;
            }
            try {
                byte[] bytes = MessageUtils.buildResponseByte(msg);
                socketClientObj.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes));
                logger.info("\u6d88\u606f\u6570\u636e\u63a8\u9001\u5206\u62e3\u673aDEV_NO={}\u6210\u529f, message={}", (Object)devNo, (Object)msg);
                return true;
            }
            catch (Exception e) {
                logger.info("\u6d88\u606f\u6570\u636e\u63a8\u9001\u5206\u62e3\u673aDEV_NO={}\u5931\u8d25", (Object)devNo, (Object)e);
            }
        }
        return false;
    }
}

