/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.plc;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.utils.PlcHexUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;

public class PlcGatewayDataDecoder
extends ByteToMessageDecoder {
    Logger logger = CustomLoggerFactory.OperateLogger();

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        while (in.isReadable()) {
            try {
                while (in.isReadable() && in.readByte() != 2) {
                }
                int currentReaderIndex = in.readerIndex();
                while (in.isReadable()) {
                    if (in.readByte() != 3 || in.capacity() != in.readerIndex()) continue;
                    int endIndex = in.readerIndex();
                    int length = endIndex - currentReaderIndex - 1;
                    ByteBuf buf = in.slice(currentReaderIndex, length);
                    byte[] data = new byte[length];
                    buf.readBytes(data, 0, length);
                    String dataHex = PlcHexUtils.bytesToHex(data);
                    this.logger.info("Netty\u6536\u5230PLC\u62a5\u6587:{}", (Object)dataHex);
                    ctx.fireChannelRead((Object)data);
                }
            }
            catch (Exception e) {
                this.logger.error("\u89e3\u6790PLC\u62a5\u6587\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

