/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.plc;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.plc.PlcGateWay;
import cn.yto.netty.server.plc.PlcGatewayDataDecoder;
import cn.yto.netty.server.plc.PlcNettyServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlcNettyServer {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workGroup = null;
    private ChannelFuture channelFuture = null;
    @Autowired
    private PlcGateWay gateWay;

    public void start(int port) {
        logger.info("\u5f00\u59cb\u7ed1\u5b9aNetty\u670d\u52a1\u7aef\u7aef\u53e3,\u7528\u4e8e\u76d1\u542cPLC\u8bf7\u6c42");
        this.bind(port);
    }

    public void bind(int port) {
        this.bossGroup = new NioEventLoopGroup();
        this.workGroup = new NioEventLoopGroup();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(this.bossGroup, this.workGroup);
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                logger.info("\u6709\u4e00PLC\u5ba2\u6237\u7aef\u767b\u5f55\u5230\u672c\u670d\u52a1\u7aef\uff0c\u5ba2\u6237\u7aef\u5730\u5740\uff1a" + socketChannel.remoteAddress().getAddress() + ":" + socketChannel.remoteAddress().getPort() + "(" + socketChannel.remoteAddress().getHostName() + ")");
                ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])"\r\n".getBytes());
                socketChannel.pipeline().addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(4096, byteBuf)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new PlcGatewayDataDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new PlcNettyServerHandler(PlcNettyServer.this.gateWay)});
            }
        });
        this.channelFuture = serverBootstrap.bind(port);
    }

    public void close() {
        this.bossGroup.shutdownGracefully();
    }
}

