/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.tcp;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class GatewayDataDecoder
extends ByteToMessageDecoder {
    Logger logger = CustomLoggerFactory.OperateLogger();
    Logger heartBeatLogger = CustomLoggerFactory.HeartBeatLogger();

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        while (this.searchHead(in)) {
            try {
                int buffLen = in.readableBytes();
                if (buffLen < 30) {
                    return;
                }
                int index = in.readerIndex();
                byte[] dataLenBytes = new byte[8];
                in.getBytes(index, dataLenBytes);
                int dataLen = Integer.parseInt(this.toString(dataLenBytes));
                byte[] data = new byte[dataLen + 8];
                in.readBytes(data);
                String dataStr = this.toString(data);
                String waybillNo = "";
                try {
                    String rgex = "waybillNo\":\"(.*?)\",";
                    Pattern pattern = Pattern.compile(rgex);
                    Matcher m = pattern.matcher(dataStr);
                    if (m.find()) {
                        waybillNo = m.group(1);
                    }
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                }
                if (ExpUtils.isBlank(waybillNo)) {
                    this.heartBeatLogger.info("===Netty\u6536\u5230\u62a5\u6587\u957f\u5ea6:{}", (Object)dataStr.length());
                } else {
                    this.logger.info("===Netty\u6536\u5230\u62a5\u6587\u957f\u5ea6:{},\u5355\u53f7:{}", (Object)dataStr.length(), (Object)waybillNo);
                }
                ctx.fireChannelRead((Object)dataStr);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                in.skipBytes(1);
            }
        }
    }

    private boolean searchHead(ByteBuf buffer) throws Exception {
        int buffLen = buffer.readableBytes();
        if (buffLen < 8) {
            return false;
        }
        int readIndex = buffer.readerIndex();
        byte[] dataLenBytes = new byte[8];
        for (int i = 0; i < buffLen; ++i) {
            try {
                buffer.getBytes(readIndex + i, dataLenBytes);
                int dataLen = Integer.parseInt(this.toString(dataLenBytes));
                byte startHead = buffer.getByte(readIndex + i + 8);
                if (startHead != 123) {
                    buffer.skipBytes(1);
                    return false;
                }
                if (dataLen <= 0 || dataLen > 5096) {
                    buffer.skipBytes(1);
                    return false;
                }
                return buffer.readableBytes() >= dataLen + 8;
            }
            catch (Exception e) {
                buffer.skipBytes(1);
                continue;
            }
        }
        return false;
    }

    public String toString(byte[] data) {
        String result = "";
        try {
            result = new String(data, "GB18030");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

