/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.tcp;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.DisposeGateWayImp;
import cn.yto.netty.server.tcp.GatewayDataDecoder;
import cn.yto.netty.server.tcp.NettyServerHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NettyServer {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workGroup = null;
    private ChannelFuture channelFuture = null;
    @Autowired
    private DisposeGateWayImp gateWay;

    public DisposeGateWayImp getGateWay() {
        return this.gateWay;
    }

    public void setGateWay(DisposeGateWayImp gateWay) {
        this.gateWay = gateWay;
    }

    public static void main(String[] args) {
        System.out.println("[Demo-Netty-Server]\u5f00\u542f8188\u7aef\u53e3");
        new NettyServer().bind(8188);
    }

    public void start(int port) {
        logger.info("\u5f00\u59cb\u7ed1\u5b9aNetty TCP\u670d\u52a1\u7aef\u7aef\u53e3{}", (Object)port);
        this.bind(port);
    }

    public void bind(int port) {
        this.bossGroup = new NioEventLoopGroup();
        this.workGroup = new NioEventLoopGroup();
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        serverBootstrap.group(this.bossGroup, this.workGroup);
        serverBootstrap.channel(NioServerSocketChannel.class);
        serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        serverBootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) throws Exception {
                logger.info("\u6709\u4e00\u5ba2\u6237\u7aef\u767b\u5f55\u5230\u672c\u670d\u52a1\u7aef\uff0c\u5ba2\u6237\u7aef\u5730\u5740\uff1a" + socketChannel.remoteAddress().getAddress() + ":" + socketChannel.remoteAddress().getPort() + "(" + socketChannel.remoteAddress().getHostName() + ")");
                socketChannel.pipeline().addLast(new ChannelHandler[]{new GatewayDataDecoder()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new NettyServerHandler(NettyServer.this.gateWay)});
            }
        });
        this.channelFuture = serverBootstrap.bind(port);
    }

    public void close() {
        this.bossGroup.shutdownGracefully();
    }
}

