/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.tcp;

import cn.yto.netty.server.datastuct.DisposeGateWayImp;
import cn.yto.netty.server.datastuct.GatewayToClient;
import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NettyServerHandler.class);
    public DisposeGateWayImp disposeGateWayImp = null;

    public NettyServerHandler(DisposeGateWayImp disposeGateWayImp_) {
        this.disposeGateWayImp = disposeGateWayImp_;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.disposeGateWayImp.DoOnTcpConnect(ctx.channel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        GatewayToClient gatewayToClient = new GatewayToClient("001", cause.getMessage(), null);
        String errorMsg = new Gson().toJson((Object)gatewayToClient).toString();
        int len = errorMsg.length();
        errorMsg = String.format("%08d", len) + errorMsg;
        ByteBuf buf = Unpooled.buffer((int)errorMsg.getBytes().length);
        buf.writeBytes(errorMsg.getBytes(Charset.forName("GBK")));
        ctx.channel().writeAndFlush((Object)buf);
        logger.info("[\u901a\u9053:" + ctx.channel().remoteAddress().toString().split("/")[0] + "]\u8bf7\u6c42\u62a5\u6587\u975e\u6cd5\uff0c\u670d\u52a1\u7aef\u51c6\u5907\u65ad\u5f00\u4e0e\u5176\u8fde\u63a5\u5f02\u5e38\u539f\u56e0\u4e3a:" + errorMsg);
        this.disposeGateWayImp.DoOnTcpClientDisconnect(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.disposeGateWayImp.DoOnTcpClientDisconnect(ctx.channel());
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.disposeGateWayImp.DoOnRcvTcpOnData(ctx.channel(), msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().flush();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.disposeGateWayImp.DoOnTcpClientDisconnect(ctx.channel());
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            String hearStr = "USERSTATE\r\n";
            ByteBuf buf = Unpooled.buffer((int)hearStr.getBytes().length);
            buf.writeBytes(hearStr.getBytes());
            if (e.state() == IdleState.READER_IDLE) {
                logger.debug("[\u53d1\u9001\u5fc3\u8df3\u63a2\u6d4b\u6d88\u606fREADER_IDLE][" + hearStr + "]");
                ctx.channel().writeAndFlush((Object)buf);
            } else if (e.state() == IdleState.WRITER_IDLE) {
                logger.debug("[\u53d1\u9001\u5fc3\u8df3\u63a2\u6d4b\u6d88\u606fWRITER_IDLE][" + hearStr + "]");
                ctx.channel().writeAndFlush((Object)buf);
            } else if (e.state() == IdleState.ALL_IDLE) {
                logger.debug("[\u5b9a\u65f6\u5411\u5ba2\u6237\u7aef\u53d1\u9001\u6570\u636e]");
            }
        }
    }
}

