/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.thread;

import cn.yto.communication.camera.receive.ReceiveCameraScanComm;
import cn.yto.config.SystemConfig;
import cn.yto.constants.PlcRespCodeEnum;
import cn.yto.entity.BaseResponse;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.service.log.ReqMonitorService;
import cn.yto.utils.SpringUtil;
import org.slf4j.Logger;

public class DisposeCameraRcvClientDataItemThread
implements Runnable {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    private SocketClientObj tcpObj = null;
    private RcvDataObj dataObj = null;
    private static SystemConfig systemConfig;
    private static ReceiveCameraScanComm receiveCameraScanComm;
    public boolean running = false;

    public static SystemConfig getSystemConfig() {
        if (systemConfig == null) {
            systemConfig = SpringUtil.getBean(SystemConfig.class);
        }
        return systemConfig;
    }

    public static ReceiveCameraScanComm getCameraScanService() {
        if (receiveCameraScanComm == null) {
            receiveCameraScanComm = SpringUtil.getBean(ReceiveCameraScanComm.class);
        }
        return receiveCameraScanComm;
    }

    public DisposeCameraRcvClientDataItemThread() {
    }

    public DisposeCameraRcvClientDataItemThread(RcvDataObj dataObj) {
        this.dataObj = dataObj;
        this.running = true;
    }

    public DisposeCameraRcvClientDataItemThread(boolean _running, SocketClientObj _tcpObj) {
        this.running = _running;
        this.tcpObj = _tcpObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.running) {
            try {
                ReqMonitorService.cameraStart();
                BaseResponse response = DisposeCameraRcvClientDataItemThread.getCameraScanService().process(this.dataObj);
                if (!response.getCode().equals("000")) {
                    String code = response.getCode();
                    String msg = response.getMsg();
                    ReqMonitorService.continueLog("CAMERA\u8bf7\u6c42\u5904\u7406\u5931\u8d25,\u54cd\u5e94\u7801:{},\u63d0\u793a\u4fe1\u606f:{}", code, msg);
                } else {
                    ReqMonitorService.continueLog("CAMERA\u8bf7\u6c42\u5904\u7406\u6210\u529f:{}", PlcRespCodeEnum.PLC_SUCCESS_CODE.getKey());
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                String code = PlcRespCodeEnum.PLC_FAIL_SYSTEM_CODE.getKey();
                ReqMonitorService.continueLog("CAMERA\u8bf7\u6c42\u5904\u7406\u5f02\u5e38:{}", e.getMessage());
            }
            finally {
                ReqMonitorService.cameraEnd();
            }
        }
    }
}

