/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.server.thread;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.HexUtil;
import cn.yto.communication.plc.receive.ReceiveDeviceStatusCmdComm;
import cn.yto.communication.plc.receive.ReceiveFaultComm;
import cn.yto.communication.plc.receive.ReceiveGrayCmdComm;
import cn.yto.communication.plc.receive.ReceiveLatticeComm;
import cn.yto.communication.plc.receive.ReceiveLatticeStatusCmdComm;
import cn.yto.communication.plc.receive.ReceiveParamQueryComm;
import cn.yto.communication.plc.receive.ReceiveParamSetComm;
import cn.yto.communication.plc.receive.ReceiveScanComm;
import cn.yto.communication.plc.receive.ReceiveSortResultComm;
import cn.yto.communication.plc.receive.ReceiveSyncCartComm;
import cn.yto.communication.plc.receive.ReceiveWeightComm;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.server.datastuct.RcvDataObj;
import cn.yto.netty.server.datastuct.SocketClientObj;
import cn.yto.netty.server.plc.PlcGateWay;
import cn.yto.service.log.ReqMonitorService;
import cn.yto.utils.ExpUtils;
import cn.yto.utils.SpringUtil;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.slf4j.Logger;

public class DisposePlcRcvClientDataItemThread
implements Runnable {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    private static final Logger heartBeatLogger = CustomLoggerFactory.HeartBeatLogger();
    private SocketClientObj tcpObj = null;
    private RcvDataObj dataObj = null;
    private static ReceiveWeightComm receiveWeightComm;
    private static ReceiveLatticeComm receiveLatticeComm;
    private static ReceiveFaultComm receiveFaultComm;
    private static ReceiveSyncCartComm receiveSyncCartComm;
    private static ReceiveScanComm receiveScanComm;
    private static ReceiveSortResultComm sortResultComm;
    private static ReceiveLatticeStatusCmdComm receiveLatticeStatusCmdComm;
    private static ReceiveDeviceStatusCmdComm receiveDeviceStatusCmdComm;
    private static ReceiveParamQueryComm receiveParamQueryComm;
    private static ReceiveParamSetComm receiveParamSetComm;
    private static ReceiveGrayCmdComm grayCmdComm;
    public boolean running = false;

    public DisposePlcRcvClientDataItemThread() {
    }

    public DisposePlcRcvClientDataItemThread(RcvDataObj dataObj) {
        this.dataObj = dataObj;
        this.running = true;
    }

    public static ReceiveWeightComm getReceiveWeightComm() {
        if (receiveWeightComm == null) {
            receiveWeightComm = SpringUtil.getBean(ReceiveWeightComm.class);
        }
        return receiveWeightComm;
    }

    public static ReceiveLatticeComm getReceiveLatticeComm() {
        if (receiveLatticeComm == null) {
            receiveLatticeComm = SpringUtil.getBean(ReceiveLatticeComm.class);
        }
        return receiveLatticeComm;
    }

    public static ReceiveFaultComm getReceiveFaultComm() {
        if (receiveFaultComm == null) {
            receiveFaultComm = SpringUtil.getBean(ReceiveFaultComm.class);
        }
        return receiveFaultComm;
    }

    public static ReceiveSyncCartComm getReceiveSyncCartComm() {
        if (receiveSyncCartComm == null) {
            receiveSyncCartComm = SpringUtil.getBean(ReceiveSyncCartComm.class);
        }
        return receiveSyncCartComm;
    }

    public static ReceiveScanComm getReceiveScanComm() {
        if (receiveScanComm == null) {
            receiveScanComm = SpringUtil.getBean(ReceiveScanComm.class);
        }
        return receiveScanComm;
    }

    public static ReceiveSortResultComm getSortResultComm() {
        if (sortResultComm == null) {
            sortResultComm = SpringUtil.getBean(ReceiveSortResultComm.class);
        }
        return sortResultComm;
    }

    public static ReceiveLatticeStatusCmdComm getReceiveLatticeStatusCmdComm() {
        if (receiveLatticeStatusCmdComm == null) {
            receiveLatticeStatusCmdComm = SpringUtil.getBean(ReceiveLatticeStatusCmdComm.class);
        }
        return receiveLatticeStatusCmdComm;
    }

    public static ReceiveDeviceStatusCmdComm getReceiveDeviceStatusCmdComm() {
        if (receiveDeviceStatusCmdComm == null) {
            receiveDeviceStatusCmdComm = SpringUtil.getBean(ReceiveDeviceStatusCmdComm.class);
        }
        return receiveDeviceStatusCmdComm;
    }

    public static ReceiveParamQueryComm getReceiveParamQueryComm() {
        if (receiveParamQueryComm == null) {
            receiveParamQueryComm = SpringUtil.getBean(ReceiveParamQueryComm.class);
        }
        return receiveParamQueryComm;
    }

    public static ReceiveParamSetComm getReceiveParamSetComm() {
        if (receiveParamSetComm == null) {
            receiveParamSetComm = SpringUtil.getBean(ReceiveParamSetComm.class);
        }
        return receiveParamSetComm;
    }

    public static ReceiveGrayCmdComm getGrayCmdComm() {
        if (grayCmdComm == null) {
            grayCmdComm = SpringUtil.getBean(ReceiveGrayCmdComm.class);
        }
        return grayCmdComm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (!this.running) return;
        ReqMonitorService.plcStart();
        String requestData = null;
        boolean heartCmd = false;
        try {
            byte[] data = this.dataObj.getData();
            if (data.length == 0) {
                return;
            }
            requestData = new String(data);
            String[] split = requestData.split("\\|");
            if (split.length < 3) {
                ReqMonitorService.continueLog("PLC\u53d1\u9001\u7684\u5b57\u7b26\u4e32\u5206\u9694\u540e\u957f\u5ea6\u5c0f\u4e8e3", new Object[0]);
                return;
            }
            String sortId = split[0];
            String msgType = split[1];
            String devNo = split[2];
            String commonSplitStr = this.buildCommonSplitStr(sortId, msgType, devNo);
            switch (msgType) {
                case "PING": {
                    if (ExpUtils.isNotBlank(devNo) && Objects.nonNull(this.dataObj.getClient()) && Objects.nonNull(this.dataObj.getClient().channel)) {
                        PlcGateWay.devNoConnectMap.putIfAbsent(this.dataObj.getClient().channel.hashCode(), devNo);
                    }
                    String respStr = commonSplitStr + "|" + System.currentTimeMillis();
                    byte[] buf = this.buildResponseByte(respStr);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])buf));
                    heartCmd = true;
                    heartBeatLogger.info("\u5fc3\u8df3\u6307\u4ee4\u54cd\u5e94PLC:{}", (Object)respStr);
                    return;
                }
                case "FEED": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684FEED\u7ed3\u679c\u54cd\u5e94:{}", requestData);
                    if (split.length < 3) return;
                    String resultCode = split[3];
                    if ("00".equals(resultCode)) {
                        logger.info("\u4f9b\u5305\u6307\u4ee4\u54cd\u5e94\u6210\u529f");
                        return;
                    } else {
                        logger.info("\u4f9b\u5305\u6307\u4ee4\u54cd\u5e94\u5931\u8d25,\u7ed3\u679c\u7801:{}", (Object)resultCode);
                        return;
                    }
                }
                case "LIGHT": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684LIGHT\u7ed3\u679c\u54cd\u5e94:{}", requestData);
                    String lightStr = commonSplitStr + "|00";
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(lightStr)));
                    ReqMonitorService.continueLog("LIGHT\u6307\u4ee4\u54cd\u5e94PLC:{}", lightStr);
                    return;
                }
                case "WEIGHT": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684WEIGHT\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String weightStr = DisposePlcRcvClientDataItemThread.getReceiveWeightComm().handleWeightMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(weightStr)));
                    ReqMonitorService.continueLog("WEIGHT\u6307\u4ee4\u54cd\u5e94PLC:{}", weightStr);
                    return;
                }
                case "SYNC": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684SYNC\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String cartStr = DisposePlcRcvClientDataItemThread.getReceiveSyncCartComm().handleSyncCartMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(cartStr)));
                    ReqMonitorService.continueLog("SYNC\u6307\u4ee4\u54cd\u5e94PLC:{}", cartStr);
                    return;
                }
                case "SCAN": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684SCAN\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String scanStr = DisposePlcRcvClientDataItemThread.getReceiveScanComm().handleScanMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(scanStr)));
                    ReqMonitorService.continueLog("SCAN\u6307\u4ee4\u54cd\u5e94PLC:{}", scanStr);
                    return;
                }
                case "SORT": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684SORT\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String sortStr = DisposePlcRcvClientDataItemThread.getSortResultComm().handleSortMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(sortStr)));
                    ReqMonitorService.continueLog("SORT\u6307\u4ee4\u54cd\u5e94PLC:{}", sortStr);
                    return;
                }
                case "LOCK": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684LOCK\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String lockStr = DisposePlcRcvClientDataItemThread.getReceiveLatticeComm().processPlcLatticeMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(lockStr)));
                    ReqMonitorService.continueLog("LOCK\u6307\u4ee4\u54cd\u5e94PLC:{}", lockStr);
                    return;
                }
                case "FAULT": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684FAULT\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String faultMsg = DisposePlcRcvClientDataItemThread.getReceiveFaultComm().processPlcFaultMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(faultMsg)));
                    ReqMonitorService.continueLog("FAULT\u6307\u4ee4\u54cd\u5e94PLC:{}", faultMsg);
                    return;
                }
                case "CHUTE": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684CHUTE\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String latticeMsg = DisposePlcRcvClientDataItemThread.getReceiveLatticeStatusCmdComm().processPlcLatticeStatusMsg(requestData);
                    if (!ExpUtils.isNotBlank(latticeMsg)) return;
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(latticeMsg)));
                    ReqMonitorService.continueLog("CHUTE\u6307\u4ee4\u54cd\u5e94PLC:{}", latticeMsg);
                    return;
                }
                case "FULL": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684FULL\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String fullMsg = DisposePlcRcvClientDataItemThread.getReceiveLatticeStatusCmdComm().processPlcFullLatticeStatusMsg(requestData);
                    if (!ExpUtils.isNotBlank(fullMsg)) return;
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(fullMsg)));
                    ReqMonitorService.continueLog("FULL\u6307\u4ee4\u54cd\u5e94PLC:{}", fullMsg);
                    return;
                }
                case "STATUS": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684STATUS\u6307\u4ee4\u4e0a\u62a5:{}", requestData);
                    String statusMsg = DisposePlcRcvClientDataItemThread.getReceiveDeviceStatusCmdComm().processDeviceStatusMsg(requestData);
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(statusMsg)));
                    ReqMonitorService.continueLog("STATUS\u6307\u4ee4\u54cd\u5e94PLC:{}", statusMsg);
                    return;
                }
                case "FORCE": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684FORCE\u54cd\u5e94:{}", requestData);
                    return;
                }
                case "QUERY": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684query\u6307\u4ee4\u54cd\u5e94:{}", requestData);
                    DisposePlcRcvClientDataItemThread.getReceiveParamQueryComm().processPlcParamQueryCmd(requestData);
                    return;
                }
                case "SET": {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u7684set\u6307\u4ee4\u54cd\u5e94:{}", requestData);
                    String queryMsg = DisposePlcRcvClientDataItemThread.getReceiveParamSetComm().processPlcParamSetCmd(requestData);
                    if (!ExpUtils.isNotBlank(queryMsg)) return;
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(queryMsg)));
                    ReqMonitorService.continueLog("\u8bbe\u7f6e\u4e4b\u540e\u8fdb\u884c\u67e5\u8be2:{}", queryMsg);
                    return;
                }
                case "GRAY": {
                    ReqMonitorService.continueLog("\u6536\u5230plc\u7684\u7070\u5ea6\u68c0\u6d4b\u7ed3\u679c:{}", requestData);
                    String grayMsg = DisposePlcRcvClientDataItemThread.getGrayCmdComm().processPlcGrayStatusMsg(requestData);
                    if (!ExpUtils.isNotBlank(grayMsg)) return;
                    this.dataObj.getClient().channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])this.buildResponseByte(grayMsg)));
                    return;
                }
                default: {
                    ReqMonitorService.continueLog("\u6536\u5230PLC\u6307\u4ee4:{},\u62a5\u6587:{}", msgType, requestData);
                    return;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return;
        }
        finally {
            if (!heartCmd) {
                ReqMonitorService.plcEnd();
            }
        }
    }

    private String buildCommonSplitStr(String sortId, String msgType, String devNo) {
        return sortId + "|" + msgType + "|" + devNo;
    }

    private byte[] buildResponseByte(String str) {
        String respStrHex = "02" + HexUtil.encodeHexStr((String)str).toUpperCase() + "030D0A";
        return Convert.hexToBytes((String)respStrHex);
    }
}

