/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class Common {
    public static final String NETTY_SERVER_CHARSET = "GBK";
    private static String DateFormate = "yyyy-MM-dd HH:mm:ss";
    private static AtomicLong serial = new AtomicLong(1L);
    private static Common instance = new Common();

    private Common() {
    }

    public static Common getInstance() {
        return instance;
    }

    public String getDateFormate() {
        return DateFormate;
    }

    public byte[] getSerialID() {
        long cmID = serial.getAndIncrement();
        if (cmID < 0L || cmID > 65535L) {
            serial.set(0L);
            cmID = 1L;
        }
        byte[] rebyte = new byte[]{(byte)(cmID >> 8), (byte)cmID};
        return rebyte;
    }

    public String byte2string(byte array) {
        return String.format("%02X", array);
    }

    public int getNonSign(byte Sign) {
        if (Sign < 0) {
            return Sign + 256;
        }
        return Sign;
    }

    public String translate(String s) {
        return s.replaceAll("%2E", ".").replaceAll("%20", " ").replaceAll("%22", "\"").replaceAll("%23", "#").replaceAll("%25", "%").replaceAll("%26", "&").replaceAll("%28", "(").replaceAll("%29", ")").replaceAll("%2B", "+").replaceAll("%2C", "-").replaceAll("%2F", "/").replaceAll("%3A", ":").replaceAll("%3B", ";").replaceAll("%3C", "<").replaceAll("%3D", "=").replaceAll("%3E", ">").replaceAll("%3F", "?").replaceAll("%40", "@").replaceAll("%5C", "\\").replaceAll("%7C", "|");
    }

    public byte[] getGPRS2_0IDBytes(String s) {
        return new byte[]{(byte)Integer.parseInt(s.substring(0, 2), 16), (byte)Integer.parseInt(s.substring(2, 4), 16), (byte)Integer.parseInt(s.substring(4, 6), 16), (byte)Integer.parseInt(s.substring(6, 8), 16), (byte)Integer.parseInt(s.substring(8, 10), 16), (byte)Integer.parseInt(s.substring(10, 12), 16), (byte)Integer.parseInt(s.substring(12, 14), 16)};
    }

    public String byteToMinaString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        buf.append("[pos=");
        buf.append("0");
        buf.append(" lim=");
        buf.append(data.length);
        buf.append(" cap=");
        buf.append(data.length);
        buf.append(": ");
        for (int i = 0; i < data.length; ++i) {
            buf.append(String.format("%02X", data[i]));
            buf.append(" ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String bytesToString(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            buf.append(String.format("%02x", data[i]));
            buf.append(" ");
        }
        return buf.toString().trim();
    }

    public long byte2Long(int a, int b, int c, int d) {
        return (long)a * 0x1000000L + (long)b * 65536L + (long)c * 256L + (long)d;
    }

    public long byte2Long(byte a, byte b, byte c, byte d) {
        return this.byte2Long(this.getNonSign(a), this.getNonSign(b), this.getNonSign(c), this.getNonSign(d));
    }

    public double bytes2double(byte b, byte b1, byte b2, byte b3) {
        return (double)this.byte2long(new byte[]{b, b1, b2, b3}) / 1000000.0;
    }

    public String long2HexStr(long param) {
        try {
            String hex = Long.toHexString(param).toString().toUpperCase();
            return hex;
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    public long hexStr2long(String param) {
        param = param.toUpperCase();
        long ret = 0L;
        int val = 0;
        for (int i = 0; i < param.length(); ++i) {
            val = 0;
            switch (param.charAt(i)) {
                case '0': {
                    val = 0;
                    break;
                }
                case '1': {
                    val = 1;
                    break;
                }
                case '2': {
                    val = 2;
                    break;
                }
                case '3': {
                    val = 3;
                    break;
                }
                case '4': {
                    val = 4;
                    break;
                }
                case '5': {
                    val = 5;
                    break;
                }
                case '6': {
                    val = 6;
                    break;
                }
                case '7': {
                    val = 7;
                    break;
                }
                case '8': {
                    val = 8;
                    break;
                }
                case '9': {
                    val = 9;
                    break;
                }
                case 'A': {
                    val = 10;
                    break;
                }
                case 'B': {
                    val = 11;
                    break;
                }
                case 'C': {
                    val = 12;
                    break;
                }
                case 'D': {
                    val = 13;
                    break;
                }
                case 'E': {
                    val = 14;
                    break;
                }
                case 'F': {
                    val = 15;
                }
            }
            ret += (long)val * (long)Math.pow(16.0, param.length() - i - 1);
        }
        return ret;
    }

    public void printDeviceData(String direction, String vtID, String cmdID, String msgSerial, byte[] vtDataBytes) {
        String time = Common.getInstance().getCurrentTimeStr();
        System.out.println("\r\n[" + direction + "] [" + time + "] [" + vtID + "] [0x" + cmdID + "] [" + msgSerial + "]\r\n[" + this.byte2string(vtDataBytes) + "]");
    }

    public String toBCD(byte[] b) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            stringBuffer.append(String.format("%02X", b[i]));
        }
        return stringBuffer.toString();
    }

    public byte[] BCD2Bytes(String hex) {
        if (hex == null) {
            return new byte[0];
        }
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(this.toByte(achar[pos]) << 4 | this.toByte(achar[pos + 1]));
        }
        return result;
    }

    public byte[] BCD2FixedBytes(String hex, int fixedLen) {
        byte[] returnBytes = new byte[fixedLen];
        byte[] temp = this.BCD2Bytes(hex);
        try {
            if (temp != null && temp.length > 0) {
                System.arraycopy(temp, 0, returnBytes, 0, temp.length > fixedLen ? fixedLen : temp.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnBytes;
    }

    private byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public String byte2string(byte[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb = sb.append(String.format("%02X", array[i]));
        }
        return sb.toString().trim();
    }

    public byte[] int2byte(int value, int arrayLen) {
        if (arrayLen < 1) {
            arrayLen = 1;
        }
        byte[] ret = new byte[arrayLen];
        ByteBuffer a = ByteBuffer.allocate(4);
        a.putInt(value);
        a.clear();
        byte[] b = new byte[4];
        a.get(b);
        if (arrayLen == 1) {
            ret[0] = b[3];
        }
        if (arrayLen == 2) {
            ret[0] = b[2];
            ret[1] = b[3];
        }
        if (arrayLen == 3) {
            ret[0] = b[1];
            ret[1] = b[2];
            ret[2] = b[3];
        }
        if (arrayLen >= 4) {
            ret[arrayLen - 4] = b[0];
            ret[arrayLen - 3] = b[1];
            ret[arrayLen - 2] = b[2];
            ret[arrayLen - 1] = b[3];
        }
        return ret;
    }

    public long byte2long(byte[] b) {
        long l = 0L;
        for (int i = 0; i < b.length; ++i) {
            l += (long)((double)(b[i] & 0xFF) * Math.pow(256.0, b.length - i - 1));
        }
        return l;
    }

    public String getTimeStr(byte[] time) {
        return String.format("%02d-%02d-%02d %02d:%02d:%02d", time[0], time[1], time[2], time[3], time[4], time[5]);
    }

    public byte[] getCurrentTimeInBcdBytes(String format) {
        String timeStr = this.getCurrentTimeInFormat(format);
        return Common.getInstance().BCD2Bytes(timeStr);
    }

    public String getCurrentTimeInFormat(String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date());
    }

    public String getCurrentTimeStr() {
        Calendar c = Calendar.getInstance();
        return String.format("%02d-%02d-%02d %02d:%02d:%02d", c.get(1) - 2000, c.get(2) + 1, c.get(5), c.get(11), c.get(12), c.get(13));
    }

    public byte[] getTimeBytes(String s) {
        return new byte[]{(byte)Integer.parseInt(s.substring(0, 2)), (byte)Integer.parseInt(s.substring(3, 5)), (byte)Integer.parseInt(s.substring(6, 8)), (byte)Integer.parseInt(s.substring(9, 11)), (byte)Integer.parseInt(s.substring(12, 14)), (byte)Integer.parseInt(s.substring(15, 17))};
    }

    public byte[] booleans2Bytes(boolean[] status) {
        StringBuffer sb = new StringBuffer();
        for (boolean s : status) {
            sb.append(s ? "1" : "0");
        }
        byte[] b = new byte[status.length / 8];
        for (int i = 0; i < status.length / 8; ++i) {
            int temp = Integer.valueOf(sb.toString().substring(i * 8, i * 8 + 8), 2);
            b[i] = (byte)temp;
        }
        return b;
    }

    public boolean[] bytes2booleans(byte[] status) {
        boolean[] b = new boolean[status.length * 8];
        for (int i = 0; i < status.length; ++i) {
            boolean[] temp = this.byte2booleans(status[i]);
            for (int j = 0; j < temp.length; ++j) {
                b[(status.length - 1 - i) * 8 + j] = temp[j];
            }
        }
        return b;
    }

    public boolean[] byte2booleans(byte status) {
        boolean[] b = new boolean[8];
        String s = Integer.toBinaryString(status & 0xFF);
        int len = s.toCharArray().length;
        for (int n = 0; n < 8 - len; ++n) {
            s = "0" + s;
        }
        for (int i = 0; i < 8; ++i) {
            if (s.charAt(i) != '1') continue;
            b[7 - i] = true;
        }
        return b;
    }

    public byte[] hexStr2bytes(String rawData) {
        String[] readyStr = rawData.trim().split(" ");
        byte[] b = new byte[readyStr.length];
        for (int i = 0; i < readyStr.length; ++i) {
            b[i] = (byte)Integer.parseInt(readyStr[i], 16);
        }
        return b;
    }

    public byte getCheckSum(byte[] data) {
        byte ret = 0;
        for (int i = 0; i < data.length; ++i) {
            ret = (byte)(ret ^ data[i]);
        }
        return ret;
    }

    public byte[] getLRC(byte[] data) {
        byte[] LRC = new byte[2];
        LRC[0] = (byte)(this.getCheckSum(data) ^ 0x33);
        byte[] temp = new byte[data.length + 1];
        System.arraycopy(data, 0, temp, 0, data.length);
        temp[temp.length - 1] = LRC[0];
        int sum = 0;
        for (int i = 0; i < temp.length - 1; ++i) {
            sum += temp[i];
        }
        LRC[1] = (byte)(sum + 51);
        return LRC;
    }

    public byte[] encryptJT808Bytes(byte[] data) {
        ByteBuffer bf = ByteBuffer.allocate(data.length * 2 + 2);
        bf.put((byte)126);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == 125) {
                bf.put((byte)125);
                bf.put((byte)1);
                continue;
            }
            if (data[i] == 126) {
                bf.put((byte)125);
                bf.put((byte)2);
                continue;
            }
            bf.put(data[i]);
        }
        bf.put((byte)126);
        byte[] ret = new byte[bf.position()];
        System.arraycopy(bf.array(), 0, ret, 0, ret.length);
        return ret;
    }

    public byte[] wrapFlags(byte[] data) {
        ByteBuffer bf = ByteBuffer.allocate(data.length + 2);
        bf.put((byte)126);
        bf.put(data);
        bf.put((byte)126);
        bf.clear();
        return bf.array();
    }

    public byte[] unwrapFlags(byte[] data) {
        byte[] b = new byte[data.length - 2];
        System.arraycopy(data, 1, b, 0, b.length);
        return b;
    }

    public byte[] decryptJT808Bytes(byte[] data) {
        ByteBuffer bf = ByteBuffer.allocate(data.length);
        for (int i = 1; i < data.length - 1; ++i) {
            if (i == data.length - 2) {
                bf.put(data[i]);
                break;
            }
            if (data[i] == 125 && data[i + 1] == 1) {
                bf.put((byte)125);
                ++i;
                continue;
            }
            if (data[i] == 125 && data[i + 1] == 2) {
                bf.put((byte)126);
                ++i;
                continue;
            }
            bf.put(data[i]);
        }
        byte[] b = new byte[bf.position()];
        System.arraycopy(bf.array(), 0, b, 0, b.length);
        return b;
    }

    public byte[] decryptJT808BytesWithDelimiter(byte[] data) {
        ByteBuffer bf = ByteBuffer.allocate(data.length);
        bf.put(data[0]);
        for (int i = 1; i < data.length - 1; ++i) {
            if (i == data.length - 2) {
                bf.put(data[i]);
                break;
            }
            if (data[i] == 125 && data[i + 1] == 1) {
                bf.put((byte)125);
                ++i;
                continue;
            }
            if (data[i] == 125 && data[i + 1] == 2) {
                bf.put((byte)126);
                ++i;
                continue;
            }
            bf.put(data[i]);
        }
        bf.put(data[data.length - 1]);
        return bf.array();
    }

    public LinkedList<byte[]> multipack(byte[] b, int singlePackSize) {
        int len = b.length;
        int Kpart = singlePackSize;
        int total = 0;
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        if (len > Kpart) {
            total = len / Kpart;
            int y = len % Kpart;
            if (y != 0) {
                ++total;
            }
            int blen = 0;
            for (int i = 0; i < total; ++i) {
                blen = i == total - 1 && y != 0 ? y : Kpart;
                ByteBuffer ioBuffer = ByteBuffer.allocate(blen);
                for (int j = 0; j < blen; ++j) {
                    ioBuffer.put(b[i * Kpart + j]);
                }
                byte[] byteArray = new byte[ioBuffer.position()];
                ioBuffer.clear();
                ioBuffer.get(byteArray);
                list.add(byteArray);
            }
        } else {
            list.add(b);
        }
        return list;
    }

    public LinkedHashMap<Integer, byte[]> multipack4taxi(byte[] b, int singlePackSize) {
        int len = b.length;
        int Kpart = singlePackSize;
        int total = 0;
        int startByteAddr = 0;
        LinkedHashMap<Integer, byte[]> map = new LinkedHashMap<Integer, byte[]>();
        if (len > Kpart) {
            total = len / Kpart;
            int y = len % Kpart;
            if (y != 0) {
                ++total;
            }
            int blen = 0;
            for (int i = 0; i < total; ++i) {
                blen = i == total - 1 && y != 0 ? y : Kpart;
                startByteAddr = i * Kpart;
                ByteBuffer ioBuffer = ByteBuffer.allocate(blen);
                for (int j = 0; j < blen; ++j) {
                    ioBuffer.put(b[i * Kpart + j]);
                }
                byte[] byteArray = new byte[ioBuffer.position()];
                ioBuffer.clear();
                ioBuffer.get(byteArray);
                map.put(startByteAddr, byteArray);
            }
        } else {
            map.put(0, b);
        }
        return map;
    }

    public byte[] str2fixedLenBytes(String s, int len) {
        if (s == null || len < 0) {
            return null;
        }
        byte[] b = s.getBytes();
        byte[] returnBytes = new byte[len];
        System.arraycopy(b, 0, returnBytes, 0, b.length <= len ? b.length : len);
        return returnBytes;
    }

    public boolean isApplicaitonAlreadyRunning() {
        File file = new File(new File("").getAbsolutePath() + File.separator + " .lock");
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        FileLock lock = null;
        try {
            lock = new RandomAccessFile(file.getAbsolutePath(), "rw").getChannel().tryLock();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(0);
        }
        return lock == null;
    }

    public byte[] file2Bytes(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            throw new FileNotFoundException(filename);
        }
        AbstractInterruptibleChannel channel = null;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            channel = fs.getChannel();
            ByteBuffer byteBuffer = ByteBuffer.allocate((int)((FileChannel)channel).size());
            while (((FileChannel)channel).read(byteBuffer) > 0) {
            }
            byte[] byArray = byteBuffer.array();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                if (channel != null) {
                    channel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Date StringToDate(String dateStr, String formatStr) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        ParsePosition pos = new ParsePosition(0);
        Date date = null;
        try {
            date = ((DateFormat)sdf).parse(dateStr, pos);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return date;
    }

    public boolean withInNdaysBeforeNow(String dateStr, int nDays) {
        return this.withInNsecondsBeforeNow(dateStr, nDays * 60 * 60 * 24);
    }

    public boolean withInNhoursBeforeNow(String dateStr, int nhours) {
        return this.withInNsecondsBeforeNow(dateStr, nhours * 60 * 60);
    }

    public boolean withInNminutesBeforeNow(String dateStr, int nMinutes) {
        return this.withInNsecondsBeforeNow(dateStr, nMinutes * 60);
    }

    public boolean withInNsecondsBeforeNow(String dateStr, int nSeconds) {
        Date now = new Date();
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DateFormate, Locale.CHINA);
            Date compareDate = sdf.parse(dateStr);
            long compareDateTimeInMillsc = compareDate.getTime();
            long nowDateTimeInMillsc = now.getTime();
            long diff = 1000 * nSeconds;
            return nowDateTimeInMillsc - compareDateTimeInMillsc <= diff;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean betweenNdays(String dateStr, int nDaysBeforeNow, int nDaysAfterNow) {
        return this.withInNdaysBeforeNow(dateStr, nDaysBeforeNow) && this.withInNdaysBeforeNow(dateStr, nDaysAfterNow * -1);
    }

    public byte[] encryptTo3Des(byte[] myEncryptionKey, String source) throws Exception {
        DESedeKeySpec ks = new DESedeKeySpec(myEncryptionKey);
        SecretKeyFactory skf = SecretKeyFactory.getInstance("DESede");
        Cipher cipher = Cipher.getInstance("DESede");
        SecretKey key = skf.generateSecret(ks);
        cipher.init(1, key);
        byte[] plainText = source.getBytes();
        byte[] encryptedText = cipher.doFinal(plainText);
        return encryptedText;
    }

    public final byte[] MD5(String s) {
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            return md;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static String toString(byte[] data) {
        String result = "";
        try {
            result = new String(data, "GB18030");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }
}

