/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.utils;

import cn.yto.entity.BaseResponse;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTools {
    private static final Logger log = LoggerFactory.getLogger(NettyTools.class);
    private static Cache<String, BlockingQueue<BaseResponse>> responseMsgCache = CacheBuilder.newBuilder().maximumSize(50000L).concurrencyLevel(20).expireAfterWrite(2L, TimeUnit.MINUTES).build();

    public static BaseResponse waitReceiveMsg(String key) {
        try {
            BaseResponse vo = (BaseResponse)((BlockingQueue)Objects.requireNonNull(responseMsgCache.getIfPresent((Object)key))).poll(2L, TimeUnit.SECONDS);
            if (vo == null) {
                vo = new BaseResponse();
                vo.setCode("100");
                vo.setMsg("\u63a8\u9001WCS\u65e0\u54cd\u5e94");
            }
            responseMsgCache.invalidate((Object)key);
            return vo;
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6570\u636e\u5f02\u5e38,sn={},msg=null", (Object)key);
            return null;
        }
    }

    public static void initReceiveMsg(String key) {
        responseMsgCache.put((Object)key, new LinkedBlockingQueue(1));
    }

    public static void setReceiveMsg(String key, BaseResponse resp) {
        if (responseMsgCache.getIfPresent((Object)key) != null) {
            ((BlockingQueue)responseMsgCache.getIfPresent((Object)key)).add(resp);
            return;
        }
    }
}

