/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.netty.utils;

import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.yto.communication.plc.send.SendTopScanComm;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.service.MsgProcHelperService;
import cn.yto.utils.ExpUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.slf4j.Logger;

public class PlcHexUtils {
    public static final Logger logger = CustomLoggerFactory.OperateLogger();
    public static final String HEX_OF_HEAD = "0A0B";
    public static final String HEX_OF_TAIL = "0D0A";
    public static final String SEPERATOR = "\\|";
    public static final String MSG_HEAD_HEX = "FFFF";
    public static final int MSG_VERSION_NUM = 0;
    public static final int MSG_SERIAL_NUM = 0;
    private static final int WAYBILLNO_LENGTH = 25;
    private static final String SPACE = " ";

    public static void main(String[] args) {
        int carNo = 9999;
        int mty = 8660;
        String waybillNo = "YT2508198965345";
        int lattice1 = 19;
        ArrayList<Integer> latticeList = new ArrayList<Integer>();
        latticeList.add(lattice1);
        String wholeMsg = SendTopScanComm.topScanLatticeSortCommand(0, 0, mty, carNo, waybillNo, 0, 0, latticeList);
        System.out.println(wholeMsg);
        System.out.println(MsgProcHelperService.beautyHexStr(wholeMsg));
    }

    public static String msgToHex(String msg) {
        if (msg == null || msg.length() == 0) {
            throw new RuntimeException("msg empty");
        }
        String hexOfBody = HexUtil.encodeHexStr((String)msg).toUpperCase() + HEX_OF_TAIL;
        String hexOfBodyLength = PlcHexUtils.hexOfBodyLength(hexOfBody);
        String hexOfWhole = HEX_OF_HEAD + hexOfBodyLength + hexOfBody;
        return hexOfWhole;
    }

    public static String hexToMsg(String hex) {
        String hexOfBody;
        String resolvedHexOfBodyLength;
        if (hex == null || hex.length() == 0) {
            throw new RuntimeException("hex empty");
        }
        if (!hex.startsWith(HEX_OF_HEAD)) {
            throw new RuntimeException("head illegal");
        }
        if (!hex.endsWith(HEX_OF_TAIL)) {
            throw new RuntimeException("tail illegal");
        }
        if (hex.length() < 12) {
            throw new RuntimeException("hex length too short");
        }
        String hexOfBodyLength = hex.substring(4, 8);
        if (!hexOfBodyLength.equals(resolvedHexOfBodyLength = PlcHexUtils.hexOfBodyLength(hexOfBody = hex.substring(8)))) {
            throw new RuntimeException("length illegal");
        }
        String hexOfMsg = hex.substring(8, hex.length() - 4);
        if (hexOfMsg == null || hexOfMsg.length() == 0) {
            throw new RuntimeException("msg empty");
        }
        String msg = HexUtil.decodeHexStr((String)hexOfMsg);
        return msg;
    }

    public static String hexToMsgForCamera(String hex, String head, String tail) {
        if (hex == null || hex.length() == 0) {
            throw new RuntimeException("hex empty");
        }
        if (!hex.startsWith(head)) {
            throw new RuntimeException("head illegal");
        }
        if (!hex.endsWith(tail)) {
            throw new RuntimeException("tail illegal");
        }
        if (hex.length() < 12) {
            throw new RuntimeException("hex length too short");
        }
        String hexOfBody = hex.substring(head.length(), hex.length() - tail.length());
        String msg = HexUtil.decodeHexStr((String)hexOfBody, (Charset)Charset.forName("gbk"));
        return msg;
    }

    public static boolean isPlcHex(String hex) {
        if (hex == null || hex.length() == 0) {
            throw new RuntimeException("hex empty");
        }
        return hex.startsWith(HEX_OF_HEAD) && hex.endsWith(HEX_OF_TAIL);
    }

    public static boolean isPlcHex(String hex, String head, String tail) {
        if (hex == null || hex.length() == 0) {
            throw new RuntimeException("hex empty");
        }
        return hex.startsWith(head) && hex.endsWith(tail);
    }

    public static ByteBuf error(String code, String msg) {
        String resp = "500|" + code;
        String hex = PlcHexUtils.msgToHex(resp);
        logger.info("PLC\u8bf7\u6c42\u6821\u9a8c\u5931\u8d25:{}", (Object)msg);
        logger.info("PLC\u54cd\u5e94:{}", (Object)resp);
        logger.info("PLC\u54cd\u5e94HEX:{}", (Object)hex);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])PlcHexUtils.hexToBytes(hex));
        return buf;
    }

    public static ByteBuf resp(String content, String msg) {
        String hex = PlcHexUtils.msgToHex(content);
        if (ExpUtils.isNotBlank(msg)) {
            logger.info("PLC\u8bf7\u6c42\u6821\u9a8c\u4fe1\u606f:{}", (Object)msg);
        }
        logger.info("PLC\u53d1\u9001:{}", (Object)content);
        logger.info("PLC\u53d1\u9001HEX:{}", (Object)hex);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])PlcHexUtils.hexToBytes(hex));
        return buf;
    }

    public static String bytesToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; ++n) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            sb.append(strHex.length() == 1 ? "0" + strHex : strHex);
        }
        return sb.toString().trim().toUpperCase();
    }

    private static byte[] hexToBytes(String hex) {
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }

    private static String hexOfBodyLength(String hexStr) {
        int byteLength = hexStr.length() / 2;
        String hexOfByteLength = HexUtil.toHex((int)byteLength).toUpperCase();
        if (hexOfByteLength.length() > 4) {
            throw new RuntimeException("length illegal");
        }
        String pad = StrUtil.padPre((CharSequence)hexOfByteLength, (int)4, (CharSequence)"0");
        return pad;
    }
}

