/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.rest;

import cn.yto.cache.CommonInfo;
import cn.yto.entity.HttpBaseResponse;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.rest.MonitorGateWayHttpClient;
import cn.yto.rest.RestClient;
import cn.yto.rest.RestTransporter;
import cn.yto.rest.login.ServerLoginStore;
import cn.yto.rest.newserver.domain.NewServerResp;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;

public class ManageClient {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final int SUCCESS = 200;
    private static String HEAD_KEY_TIMESTAMP = "X-API-TIMESTAMP";
    private static String HEAD_KEY_APPID = "X-API-APPID";
    private static String HEAD_KEY_SIGNATURE = "X-API-SIGNATURE";
    private static final String RESP_SUCCESS = "000";

    @Deprecated
    public static <I, O> NewServerResp<O> doRequest(I msgBody, String action, ParameterizedTypeReference<NewServerResp<O>> respType) {
        return ManageClient.doRequest(0, msgBody, action, respType);
    }

    @Deprecated
    public static <I, O> NewServerResp<O> doRequest(int timeout, I msgBody, String action, ParameterizedTypeReference<NewServerResp<O>> respType) {
        NewServerResp resp = new NewServerResp();
        Map<String, String> headerParam = null;
        headerParam = ManageClient.getHeaderParam();
        ResponseEntity<NewServerResp<O>> result = null;
        result = timeout <= 0 ? ManageClient.getTransporter(action).exchange(action, msgBody, respType, null, headerParam, HttpMethod.POST) : ManageClient.getTransporter(action).exchange(timeout, action, msgBody, respType, null, headerParam, HttpMethod.POST);
        if (result == null) {
            resp.setCode("5001");
            resp.setMessage("Rest\u8bf7\u6c42\u5f02\u5e38");
            return resp;
        }
        int retCode = result.getStatusCode().value();
        if (200 != retCode) {
            logger.error("Rest\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38\uff0cHTTP\u72b6\u6001\u7801[" + retCode + "]");
            resp.setCode("5002");
            resp.setMessage("Rest\u72b6\u6001\u7801\u5f02\u5e38");
            return resp;
        }
        resp = (NewServerResp)result.getBody();
        resp.setCode("200");
        return resp;
    }

    private static RestTransporter getTransporter(String action) {
        RestTransporter t = RestClient.getTransporter("manageWeb");
        return t;
    }

    public static <I, O> NewServerResp<O> doRequest2(int timeout, I msgBody, String action, ParameterizedTypeReference<ManagePlatResp<O>> respType) {
        return ManageClient.doRequest2(timeout, msgBody, action, respType, true);
    }

    public static <I, O> NewServerResp<O> doRequest2(int timeout, I msgBody, String action, ParameterizedTypeReference<ManagePlatResp<O>> respType, boolean offlineByHand) {
        NewServerResp resp = new NewServerResp();
        Map<String, String> headerParam = ManageClient.getHeaderParam();
        ResponseEntity<ManagePlatResp<O>> result = null;
        result = timeout <= 0 ? ManageClient.getTransporter(action).exchange(action, msgBody, respType, null, headerParam, HttpMethod.POST) : ManageClient.getTransporter(action).exchange(timeout, action, msgBody, respType, null, headerParam, HttpMethod.POST);
        if (result == null) {
            resp.setCode("5001");
            resp.setMessage("Rest\u8bf7\u6c42\u5f02\u5e38");
            return resp;
        }
        int retCode = result.getStatusCode().value();
        if (200 != retCode) {
            logger.error("Rest\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38\uff0cHTTP\u72b6\u6001\u7801[" + retCode + "]");
            resp.setCode("5002");
            resp.setMessage("Rest\u72b6\u6001\u7801\u5f02\u5e38");
            return resp;
        }
        ManagePlatResp body = (ManagePlatResp)result.getBody();
        if (body != null) {
            Object data = body.getData();
            resp.setData(data);
            if (RESP_SUCCESS.equals(body.getRespCode()) || RESP_SUCCESS.equals(body.getRespcode())) {
                resp.setCode("200");
            } else {
                Optional.ofNullable(body.getRespCode()).ifPresent(resp::setCode);
                Optional.ofNullable(body.getRespcode()).ifPresent(resp::setCode);
            }
            resp.setMessage(body.getRespMessage());
        } else {
            resp.setCode("200");
            resp.setMessage("\u8bf7\u6c42\u54cd\u5e94\u6210\u529f,\u4f46\u8fd4\u56de\u7684body\u4e3a\u7a7a");
        }
        return resp;
    }

    private static Map<String, String> getHeaderParam() {
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("token", ServerLoginStore.getServerToken());
        headerParam.put("orgCode", CommonInfo.getInstance().getOrgCode());
        headerParam.put("userCode", CommonInfo.getInstance().getUserCode());
        HttpBaseResponse<HashMap<String, String>> httpBaseResponse = MonitorGateWayHttpClient.doRequest(3000, null, "/Yto_Server/manageWebHeader", new ParameterizedTypeReference<HttpBaseResponse<HashMap<String, String>>>(){});
        if (httpBaseResponse != null && httpBaseResponse.getData() != null) {
            headerParam.putAll((Map<String, String>)httpBaseResponse.getData());
        }
        return headerParam;
    }

    public static <O> NewServerResp<O> postForm(int timeout, LinkedMultiValueMap<String, Object> formData, String action, ParameterizedTypeReference<ManagePlatResp<O>> respType, Map<String, String> urlRequestParam, Map<String, String> headerParam) {
        ResponseEntity<ManagePlatResp<O>> result;
        NewServerResp resp = new NewServerResp();
        Map<String, String> header = ManageClient.getHeaderParam();
        if (headerParam != null) {
            header.putAll(headerParam);
        }
        if ((result = ManageClient.getTransporter(action).postForm(timeout, action, formData, respType, urlRequestParam, header)) == null) {
            resp.setCode("5001");
            resp.setMessage("Rest\u8bf7\u6c42\u5f02\u5e38");
            return resp;
        }
        int retCode = result.getStatusCode().value();
        if (200 != retCode) {
            logger.error("Rest\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38\uff0cHTTP\u72b6\u6001\u7801[" + retCode + "]");
            resp.setCode("5002");
            resp.setMessage("Rest\u72b6\u6001\u7801\u5f02\u5e38");
            return resp;
        }
        ManagePlatResp body = (ManagePlatResp)result.getBody();
        if (body != null) {
            Object data = body.getData();
            resp.setData(data);
            if (RESP_SUCCESS.equals(body.getRespCode()) || RESP_SUCCESS.equals(body.getRespcode())) {
                resp.setCode("200");
            } else {
                Optional.ofNullable(body.getRespCode()).ifPresent(resp::setCode);
                Optional.ofNullable(body.getRespcode()).ifPresent(resp::setCode);
            }
            resp.setMessage(body.getRespMessage());
        } else {
            resp.setCode("200");
            resp.setMessage("\u8bf7\u6c42\u54cd\u5e94\u6210\u529f,\u4f46\u8fd4\u56de\u7684body\u4e3a\u7a7a");
        }
        return resp;
    }

    public static class ManagePlatResp<T>
    implements Serializable {
        private String respCode;
        private String respcode;
        private String respMessage;
        private T data;

        public String getRespCode() {
            return this.respCode;
        }

        public void setRespCode(String respCode) {
            this.respCode = respCode;
        }

        public String getRespcode() {
            return this.respcode;
        }

        public void setRespcode(String respcode) {
            this.respcode = respcode;
        }

        public String getRespMessage() {
            return this.respMessage;
        }

        public T getData() {
            return this.data;
        }

        public void setRespMessage(String respMessage) {
            this.respMessage = respMessage;
        }

        public void setData(T data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagePlatResp)) {
                return false;
            }
            ManagePlatResp other = (ManagePlatResp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$respCode = this.getRespCode();
            String other$respCode = other.getRespCode();
            if (this$respCode == null ? other$respCode != null : !this$respCode.equals(other$respCode)) {
                return false;
            }
            String this$respcode = this.getRespCode();
            String other$respcode = other.getRespCode();
            if (this$respcode == null ? other$respcode != null : !this$respcode.equals(other$respcode)) {
                return false;
            }
            String this$respMessage = this.getRespMessage();
            String other$respMessage = other.getRespMessage();
            if (this$respMessage == null ? other$respMessage != null : !this$respMessage.equals(other$respMessage)) {
                return false;
            }
            T this$data = this.getData();
            T other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ManagePlatResp;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $respCode = this.getRespCode();
            result = result * 59 + ($respCode == null ? 43 : $respCode.hashCode());
            String $respcode = this.getRespCode();
            result = result * 59 + ($respcode == null ? 43 : $respcode.hashCode());
            String $respMessage = this.getRespMessage();
            result = result * 59 + ($respMessage == null ? 43 : $respMessage.hashCode());
            T $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        public String toString() {
            return "ManageClient.ManagePlatResp(respCode=" + this.getRespCode() + ", respcode=" + this.getRespCode() + ", respMessage=" + this.getRespMessage() + ", data=" + this.getData() + ")";
        }
    }
}

