/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.rest;

import cn.yto.config.HttpHostsConfig;
import cn.yto.config.SystemConfig;
import cn.yto.entity.HttpBaseResponse;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.rest.RestClient;
import cn.yto.rest.RestTransporter;
import cn.yto.utils.SpringUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;

public class MonitorGateWayHttpClient {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    private static final int SUCCESS = 200;
    private static HttpHostsConfig httpHostsConfig;
    private static SystemConfig systemConfig;

    public static HttpHostsConfig getHttpHostsConfiguration() {
        if (httpHostsConfig == null) {
            httpHostsConfig = SpringUtil.getBean(HttpHostsConfig.class);
        }
        return httpHostsConfig;
    }

    public static SystemConfig getSystemConfig() {
        if (systemConfig == null) {
            systemConfig = SpringUtil.getBean(SystemConfig.class);
        }
        return systemConfig;
    }

    public static <I, O> HttpBaseResponse<O> doRequest(I msgBody, String action, ParameterizedTypeReference<HttpBaseResponse<O>> respType) {
        return MonitorGateWayHttpClient.doRequest(0, msgBody, action, respType);
    }

    public static <I, O> HttpBaseResponse<O> doRequest(int timeout, I msgBody, String action, ParameterizedTypeReference<HttpBaseResponse<O>> respType) {
        HttpBaseResponse resp = new HttpBaseResponse();
        HashMap<String, String> headerParam = new HashMap<String, String>();
        ResponseEntity<HttpBaseResponse<O>> result = null;
        result = timeout <= 0 ? MonitorGateWayHttpClient.getTransporter(action).exchange(action, msgBody, respType, null, headerParam, HttpMethod.POST) : MonitorGateWayHttpClient.getTransporter(action).exchange(timeout, action, msgBody, respType, null, headerParam, HttpMethod.POST);
        if (result == null) {
            resp.setRespCode("5001");
            resp.setRespMessage("Rest\u8bf7\u6c42\u5f02\u5e38");
            return resp;
        }
        int httpStatusCode = result.getStatusCode().value();
        if (200 != httpStatusCode) {
            logger.error("Rest\u4e0a\u4f20\u8bf7\u6c42\u5f02\u5e38\uff0cHTTP\u72b6\u6001\u7801[" + httpStatusCode + "]");
            resp.setRespCode("5002");
            resp.setRespMessage("Rest\u72b6\u6001\u7801\u5f02\u5e38");
            return resp;
        }
        resp = (HttpBaseResponse)result.getBody();
        return resp;
    }

    private static RestTransporter getTransporter(String action) {
        RestTransporter t = RestClient.getTransporter("monitorGateWay");
        return t;
    }
}

