/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.rest;

import cn.yto.config.SystemConfig;
import cn.yto.entity.HttpHostConfiguration;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.rest.RestTransporter;
import cn.yto.utils.SpringUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class RestClient {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static final Map<String, RestTransporter> transports = new HashMap<String, RestTransporter>();
    public static final String MONITOR_GATEWAY = "monitorGateWay";
    public static final String NEW_SERVER_INTERCEPT_TRANSPORTER = "manageWeb";
    private static SystemConfig systemConfig;

    public static SystemConfig getSystemConfig() {
        if (systemConfig == null) {
            systemConfig = SpringUtil.getBean(SystemConfig.class);
        }
        return systemConfig;
    }

    public static synchronized void init(Map<String, HttpHostConfiguration> hosts) {
        hosts.forEach((k, v) -> {
            Boolean enable = v.getEnable();
            if (!enable.booleanValue()) {
                return;
            }
            RestTransporter tp = null;
            try {
                tp = new RestTransporter((String)k, (HttpHostConfiguration)v);
                transports.put((String)k, tp);
            }
            catch (Exception e) {
                logger.error("Rest Client\u521d\u59cb\u5316\u5931\u8d25,\u5e94\u7528\u540d:" + k);
            }
        });
    }

    public static synchronized RestTransporter getTransporter(String name) {
        RestTransporter tp = transports.get(name);
        return tp;
    }

    public static synchronized void setTransporter(String name, RestTransporter t) {
        transports.put(name, t);
    }
}

