/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.rest;

import cn.yto.config.SystemConfig;
import cn.yto.entity.HttpHostConfiguration;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import cn.yto.utils.GoogleJsonUtil;
import cn.yto.utils.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class RestTransporter {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static SystemConfig systemConfig;
    private final String server;
    public final String baseUrl;
    private final RestTemplate restTemplate;

    public static SystemConfig getSystemConfig() {
        if (systemConfig == null) {
            systemConfig = SpringUtil.getBean(SystemConfig.class);
        }
        return systemConfig;
    }

    public RestTransporter(String server, HttpHostConfiguration cfg) {
        String context;
        this.server = server;
        String baseUrl = "";
        String scheme = cfg.getScheme();
        if (StringUtils.isBlank((CharSequence)scheme)) {
            scheme = "http";
        }
        baseUrl = baseUrl + scheme + "://";
        String host = cfg.getHost();
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new NullPointerException("host\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        baseUrl = baseUrl + host;
        int port = cfg.getPort();
        if (port != 80) {
            baseUrl = baseUrl + ":" + port;
        }
        if (!StringUtils.isBlank((CharSequence)(context = cfg.getContext()))) {
            baseUrl = baseUrl + "/" + context;
        }
        this.baseUrl = baseUrl = baseUrl + "/";
        RestTemplate restTemplate = null;
        PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = this.poolingHttpClientConnectionManager(cfg.getMaxTotal());
        RequestConfig requestConfig = this.requestConfig(cfg.getConnectionRequestTimeout(), cfg.getConnectTimeout(), cfg.getSocketTimeout());
        CloseableHttpClient closeableHttpClient = this.httpClient(poolingHttpClientConnectionManager, requestConfig);
        this.restTemplate = restTemplate = this.restTemplate((HttpClient)closeableHttpClient);
    }

    public <I, O> ResponseEntity<O> post(String action, I requestBody, Class<O> responseType, Map<String, String> urlRequestParam) {
        return this.exchange(0, action, requestBody, responseType, null, urlRequestParam, null, null);
    }

    public <I, O> ResponseEntity<O> post(String action, I requestBody, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam) {
        return this.exchange(0, action, requestBody, null, responseType, urlRequestParam, null, null);
    }

    public <I, O> ResponseEntity<O> exchange(String action, I requestBody, Class<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        return this.exchange(0, action, requestBody, responseType, null, urlRequestParam, headerParam, httpMethod);
    }

    public <I, O> ResponseEntity<O> exchange(String action, I requestBody, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        return this.exchange(0, action, requestBody, null, responseType, urlRequestParam, headerParam, httpMethod);
    }

    public <I, O> ResponseEntity<O> exchange(int timeout, String action, I requestBody, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        return this.exchange(timeout, action, requestBody, null, responseType, urlRequestParam, headerParam, httpMethod);
    }

    public <I, O> ResponseEntity<O> exchange(int timeout, String action, I requestBody, Class<O> responseType, ParameterizedTypeReference<O> responseType2, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        ResponseEntity response;
        block26: {
            response = null;
            long start = System.currentTimeMillis();
            String waybillNo = "";
            try {
                if (action.startsWith("/")) {
                    action = action.substring(1);
                }
                String url = this.baseUrl + action;
                String rgex = "waybillNo\":\"(.*?)\"";
                Pattern pattern = Pattern.compile(rgex);
                HttpHeaders headers = new HttpHeaders();
                if (requestBody == null) {
                    if (this.needLog(action)) {
                        logger.info("Rest\u8bf7\u6c42\u5730\u5740:{}{}", (Object)url, (Object)(timeout > 0 ? ",\u8d85\u65f6\u8bbe\u7f6e" + timeout + "ms" : ""));
                        logger.info("Rest\u8bf7\u6c42\u53c2\u6570:\u65e0");
                    }
                } else {
                    String requestJson = "";
                    if (requestBody instanceof MultiValueMap) {
                        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
                        requestJson = requestBody.toString();
                    } else {
                        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
                        requestJson = JSONObject.toJSON(requestBody).toString();
                    }
                    try {
                        Matcher matcher = pattern.matcher(requestJson);
                        if (matcher.find()) {
                            waybillNo = matcher.group(1);
                        }
                    }
                    catch (Exception exception) {
                        logger.error(exception.getMessage());
                    }
                    if (this.needLog(action)) {
                        if (StringUtils.isNotBlank((CharSequence)requestJson) && requestJson.length() > 2000) {
                            requestJson = requestJson.substring(0, 2000) + "...";
                        }
                        logger.info("Rest\u8bf7\u6c42\u5730\u5740:{}{}{}", new Object[]{url, timeout > 0 ? ",\u8d85\u65f6\u8bbe\u7f6e" + timeout + "ms" : "", ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo});
                        logger.info("Rest\u8bf7\u6c42\u53c2\u6570:{}{}", (Object)requestJson, (Object)(ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo));
                    }
                }
                if (urlRequestParam != null) {
                    UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
                    urlRequestParam.entrySet();
                    for (Map.Entry<String, String> e : urlRequestParam.entrySet()) {
                        builder.queryParam(e.getKey(), new Object[]{e.getValue()});
                    }
                    url = builder.toUriString();
                }
                headers.add("Accept", "application/json;charset=UTF-8");
                if (headerParam != null) {
                    for (Map.Entry entry : headerParam.entrySet()) {
                        headers.add((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if (httpMethod == null) {
                    httpMethod = HttpMethod.POST;
                }
                HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
                response = responseType2 != null ? (timeout <= 0 ? this.restTemplate.exchange(url, httpMethod, requestEntity, responseType2, new Object[0]) : RestTransporter.getRestTemplate(timeout).exchange(url, httpMethod, requestEntity, responseType2, new Object[0])) : (timeout <= 0 ? this.restTemplate.exchange(url, httpMethod, requestEntity, responseType, new Object[0]) : RestTransporter.getRestTemplate(timeout).exchange(url, httpMethod, requestEntity, responseType, new Object[0]));
                if (this.needLog(action)) {
                    logger.info("Rest\u8bf7\u6c42\u8017\u65f6:{}{}", (Object)(System.currentTimeMillis() - start), (Object)(ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo));
                }
                if (response.getStatusCode().value() == 200) {
                    Object object = response.getBody();
                    String responseJson = GoogleJsonUtil.toJson(object);
                    if (StringUtils.isNotBlank((CharSequence)responseJson) && responseJson.length() > 1000) {
                        responseJson = responseJson.substring(0, 1000) + "...";
                    }
                    if (this.needLog(action)) {
                        logger.info("Rest\u8fd4\u56de\u53c2\u6570:{}{}", (Object)responseJson, (Object)(ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo));
                    }
                } else if (this.needLog(action)) {
                    logger.error("Rest\u8bf7\u6c42" + url + "\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a:{}{}", (Object)response.getStatusCode().value(), (Object)(ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo));
                }
            }
            catch (Exception e) {
                if (!this.needLog(action)) break block26;
                logger.info("Rest\u8bf7\u6c42\u8017\u65f6:{}{}", (Object)(System.currentTimeMillis() - start), (Object)(ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo));
                if (timeout <= 0) {
                    logger.error("Rest\u8bf7\u6c42\u5f02\u5e38," + e.getMessage() + (ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo), (Throwable)e);
                }
                Throwable cause = e.getCause();
                if (cause.getMessage() != null && cause.getMessage().contains("timed out")) {
                    logger.error("Rest\u8bf7\u6c42\u8d85\u65f6,\u63a5\u53e3\u8bbe\u5b9a\u7684\u8d85\u65f6\u65f6\u95f4:{}{}", (Object)timeout, (Object)(ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo));
                }
                logger.error("Rest\u8bf7\u6c42\u5f02\u5e38," + e.getMessage() + (ExpUtils.isBlank(waybillNo) ? "" : ",\u5355\u53f7:" + waybillNo), (Throwable)e);
            }
        }
        return response;
    }

    public static RestTemplate getRestTemplate(int timeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout(timeout);
        requestFactory.setReadTimeout(timeout);
        RestTemplate restTemp = new RestTemplate();
        restTemp.setRequestFactory((ClientHttpRequestFactory)requestFactory);
        restTemp.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
        return restTemp;
    }

    private boolean needLog(String action) {
        return action == null || !action.equals("appinfo/ping") && !action.equals("getTimesForToken");
    }

    private PoolingHttpClientConnectionManager poolingHttpClientConnectionManager(Integer maxTotal) {
        PoolingHttpClientConnectionManager result = new PoolingHttpClientConnectionManager();
        result.setMaxTotal(maxTotal.intValue());
        result.setDefaultMaxPerRoute(maxTotal.intValue());
        return result;
    }

    private RequestConfig requestConfig(Integer connectionRequestTimeout, Integer ConnectTimeout, Integer SocketTimeout) {
        RequestConfig result = RequestConfig.custom().setConnectionRequestTimeout(connectionRequestTimeout.intValue()).setConnectTimeout(ConnectTimeout.intValue()).setSocketTimeout(SocketTimeout.intValue()).build();
        return result;
    }

    private CloseableHttpClient httpClient(PoolingHttpClientConnectionManager poolingHttpClientConnectionManager, RequestConfig requestConfig) {
        ConnectionKeepAliveStrategy connectionKeepAliveStrategy = new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
                return 30000L;
            }
        };
        CloseableHttpClient result = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(requestConfig).setKeepAliveStrategy(connectionKeepAliveStrategy).setConnectionManagerShared(true).build();
        return result;
    }

    private RestTemplate restTemplate(HttpClient httpClient) {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        requestFactory.setHttpClient(httpClient);
        return new RestTemplate((ClientHttpRequestFactory)requestFactory);
    }

    private SimpleClientHttpRequestFactory getSimpleFactory(Integer ConnectTimeout, Integer SocketTimeout) {
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(ConnectTimeout.intValue());
        clientHttpRequestFactory.setReadTimeout(SocketTimeout.intValue());
        return clientHttpRequestFactory;
    }

    public static <I, O> ResponseEntity<O> exchangeWithCustomTemplate(RestTemplate restTemplate, String url, I requestBody, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam, HttpMethod httpMethod) {
        ResponseEntity response = null;
        long start = System.currentTimeMillis();
        logger.info("Rest\u8bf7\u6c42\u5730\u5740:" + url);
        try {
            String requestJson = JSONObject.toJSON(requestBody).toString();
            if (StringUtils.isNotBlank((CharSequence)requestJson) && requestJson.length() > 2000) {
                requestJson = requestJson.substring(0, 2000) + "...";
            }
            logger.info("Rest\u8bf7\u6c42\u53c2\u6570:" + requestJson);
            if (urlRequestParam != null) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
                urlRequestParam.entrySet();
                for (Map.Entry<String, String> e : urlRequestParam.entrySet()) {
                    builder.queryParam(e.getKey(), new Object[]{e.getValue()});
                }
                url = builder.toUriString();
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
            headers.add("Accept", "application/json;charset=UTF-8");
            if (headerParam != null) {
                for (Map.Entry<String, String> e : headerParam.entrySet()) {
                    headers.add(e.getKey(), e.getValue());
                }
            }
            if (httpMethod == null) {
                httpMethod = HttpMethod.POST;
            }
            HttpEntity requestEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            response = restTemplate.exchange(url, httpMethod, requestEntity, responseType, new Object[0]);
            logger.info("Rest\u8bf7\u6c42\u8017\u65f6:" + (System.currentTimeMillis() - start));
            if (response.getStatusCode().value() == 200) {
                Object respBody = response.getBody();
                String responseJson = GoogleJsonUtil.toJson(respBody);
                if (StringUtils.isNotBlank((CharSequence)responseJson) && responseJson.length() > 1000) {
                    responseJson = responseJson.substring(0, 1000) + "...";
                }
                logger.info("Rest\u8fd4\u56de\u53c2\u6570:" + responseJson);
            } else {
                logger.error("Rest\u8bf7\u6c42" + url + "\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\uff1a" + response.getStatusCode().value());
            }
        }
        catch (Exception e) {
            logger.info("Rest\u8bf7\u6c42\u8017\u65f6:" + (System.currentTimeMillis() - start));
            logger.error("Rest\u8bf7\u6c42\u5f02\u5e38," + e.getMessage(), (Throwable)e);
        }
        return response;
    }

    public <O> ResponseEntity<O> postForm(int timeout, String action, LinkedMultiValueMap<String, Object> formData, ParameterizedTypeReference<O> responseType, Map<String, String> urlRequestParam, Map<String, String> headerParam) {
        String url = this.baseUrl + action;
        if (urlRequestParam != null) {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            for (Map.Entry<String, String> entry : urlRequestParam.entrySet()) {
                builder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            url = builder.toUriString();
        }
        RestTemplate restTemplate = null;
        restTemplate = timeout <= 0 ? this.restTemplate : RestTransporter.getRestTemplate(timeout);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(MediaType.MULTIPART_FORM_DATA);
        if (headerParam != null) {
            for (Map.Entry<String, String> entry : headerParam.entrySet()) {
                httpHeaders.add(entry.getKey(), entry.getValue());
            }
        }
        HttpEntity httpEntity = new HttpEntity(formData, (MultiValueMap)httpHeaders);
        return restTemplate.exchange(url, HttpMethod.POST, httpEntity, responseType, new Object[0]);
    }
}

