/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule;

import org.quartz.spi.JobFactory;
import org.quartz.spi.TriggerFiredBundle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class AppQuartzConfig {
    @Bean
    public AdaptableJobFactory springBeanJobFactory() {
        return new AdaptableJobFactory(){
            @Autowired
            private AutowireCapableBeanFactory capableBeanFactory;

            protected Object createJobInstance(TriggerFiredBundle bundle) throws Exception {
                Object jobInstance = super.createJobInstance(bundle);
                this.capableBeanFactory.autowireBean(jobInstance);
                return jobInstance;
            }
        };
    }

    @Bean
    public SchedulerFactoryBean schedulerFactoryBean() {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setJobFactory((JobFactory)this.springBeanJobFactory());
        return schedulerFactoryBean;
    }
}

