/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule;

import cn.yto.cache.CommonInfo;
import cn.yto.cache.DeviceRecordCacheService;
import cn.yto.cache.GatewayInfoCacheService;
import cn.yto.cache.LatticeCacheService;
import cn.yto.cache.LatticeStatusCacheService;
import cn.yto.cache.NewLatticeCacheService;
import cn.yto.cache.OperationTableCacheService;
import cn.yto.communication.monitor.send.SendOperTableSyncComm;
import cn.yto.config.SortingConfig;
import cn.yto.config.WcsClientConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.service.lattice.LatticeLockService;
import cn.yto.utils.ExpUtils;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CacheRefreshScheduler {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private LatticeCacheService latticeCacheService;
    @Autowired
    private OperationTableCacheService operationTableCacheService;
    @Autowired
    private WcsClientConfig wcsClientConfig;
    @Autowired
    private GatewayInfoCacheService gatewayInfoCacheService;
    @Autowired
    private LatticeLockService latticeLockService;
    @Autowired
    private LatticeStatusCacheService latticeStatusCacheService;
    @Autowired
    private NewLatticeCacheService newLatticeCacheService;
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    private SendOperTableSyncComm sendOperTableSyncComm;

    public void start() {
        try {
            this.seconds10Task();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u79d2\u4efb\u52a1\u65f6, \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        try {
            this.minuteTask();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5206\u949f\u4efb\u52a1\u65f6, \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        try {
            this.minute5Task();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5206\u949f\u4efb\u52a1\u65f6, \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        try {
            this.hourTask();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5c0f\u65f6\u4efb\u52a1\u65f6, \u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    private void seconds10Task() {
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CacheRefreshScheduler.this.latticeStatusCacheService.refreshLatticeStatusCache();
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }

    public void minuteTask() {
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CacheRefreshScheduler.this.newLatticeCacheService.refresh();
                if (ExpUtils.isBlank(CommonInfo.getInstance().getUserCode())) {
                    logger.info("\u5f53\u524d\u7cfb\u7edf\u4fe1\u606fuserCode\u4e3a\u7a7a, \u5c1d\u8bd5\u53bb\u83b7\u53d6");
                    CacheRefreshScheduler.this.gatewayInfoCacheService.refreshOptOutSystemInfo();
                }
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    public void hourTask() {
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (CacheRefreshScheduler.this.sortingConfig.topScan()) {
                    CacheRefreshScheduler.this.sendOperTableSyncComm.syncOperTable(SendOperTableSyncComm.TYPE_PART);
                }
                CacheRefreshScheduler.this.operationTableCacheService.refreshOperationTableCache();
            }
        }, 0L, 1L, TimeUnit.HOURS);
    }

    public void minute5Task() {
        ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
        scheduledThreadPool.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (CacheRefreshScheduler.this.wcsClientConfig.getMonitorStartUpChannel() == 1) {
                    CacheRefreshScheduler.this.latticeLockService.uploadAllLatticeStatus();
                }
                logger.info("\u5f53\u524d\u65e0\u8bfb\u6570\u91cf:{}", DeviceRecordCacheService.ipNoReadCache);
                logger.info("\u5f53\u524d\u603b\u6570\u91cf:{}", DeviceRecordCacheService.ipTotalCache);
                if (DeviceRecordCacheService.waybillNoThreeCodeCache.size() < 1L && MapUtils.isNotEmpty(DeviceRecordCacheService.ipTotalCache)) {
                    DeviceRecordCacheService.ipNoReadCache.clear();
                    DeviceRecordCacheService.ipTotalCache.clear();
                }
            }
        }, 2L, 5L, TimeUnit.MINUTES);
    }
}

