/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.schedule.BaseJob;
import java.util.Map;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.stereotype.Component;

@Component
public class SchedulerJobManager
implements ApplicationContextAware {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private SchedulerFactoryBean schedulerFactoryBean;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void scheduleAllJobs() throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        this.scheduleJobs(scheduler);
    }

    public void stop() throws SchedulerException {
        Scheduler scheduler = this.schedulerFactoryBean.getScheduler();
        scheduler.clear();
    }

    private void scheduleJobs(Scheduler scheduler) throws SchedulerException {
        Map jobMap = this.applicationContext.getBeansOfType(BaseJob.class);
        for (BaseJob job : jobMap.values()) {
            try {
                String jobName = job.getClass().getSimpleName() + "_job";
                String jobTriggerName = job.getClass().getSimpleName() + "_trigger";
                String jobGroupName = job.getClass().getSimpleName() + "_group";
                JobDetail jobDetail = JobBuilder.newJob(job.getClass()).withIdentity(jobName, jobGroupName).build();
                String cronExpression = job.getCronExpression();
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobTriggerName, jobGroupName).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
                JobKey jobKey = new JobKey(jobName, jobGroupName);
                TriggerKey triggerKey = new TriggerKey(jobTriggerName, jobGroupName);
                if (scheduler.checkExists(jobKey) || scheduler.checkExists(triggerKey)) continue;
                logger.info("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\uff1a" + jobName);
                scheduler.scheduleJob(jobDetail, trigger);
            }
            catch (Exception f) {
                logger.error("\u521d\u59cb\u5316\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519\u4e86: " + f);
            }
        }
    }
}

