/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule.job;

import cn.yto.config.SystemConfig;
import cn.yto.constants.ManageConfigTypeEnum;
import cn.yto.entity.ManageConfigResp;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.schedule.BaseJob;
import cn.yto.schedule.job.PartitionDataCleanRunnable;
import cn.yto.schedule.job.TimeOutDataCleanRunnable;
import cn.yto.service.ManageConfigService;
import cn.yto.service.database.BaseDataHandlerService;
import cn.yto.service.image.CleanImageDirService;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import cn.yto.utils.PartitionUtils;
import cn.yto.utils.SpringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@DisallowConcurrentExecution
public class DeleteTimeOutDataJob
extends BaseJob {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    @Autowired
    private SystemConfig systemConfig;
    @Autowired
    private BaseDataHandlerService baseDataHandlerService;
    @Autowired
    private CleanImageDirService cleanImageDirService;
    private CountDownLatch latch;
    private static final int recordCount = 1000;
    public static final String CRON_DELETE_JOB = "0 15 12 * * ?";
    private static ExecutorService executor;
    @Value(value="${appJob.cron.delTimeOutData:}")
    private String delTimeOutData;

    public DeleteTimeOutDataJob() {
        if (executor == null) {
            executor = Executors.newCachedThreadPool();
        }
    }

    @Override
    public String getCronExpression() {
        ManageConfigResp manageConfigByType = ManageConfigService.MANAGE_CONFIG_TYPE_MAP.get(ManageConfigTypeEnum.DELETE_JOB_CONFIG.getType());
        if (Objects.nonNull(manageConfigByType) && ExpUtils.isNotBlank(manageConfigByType.getConfigContent())) {
            String cron = manageConfigByType.getConfigContent();
            logger.info("\u6570\u636e\u6e05\u7406\u4efb\u52a1\u8868\u8fbe\u5f0f\u4f7f\u7528\u8fdc\u7a0b\u914d\u7f6e\u7684:{}", (Object)cron);
            return cron;
        }
        if (ExpUtils.isNotBlank(this.delTimeOutData)) {
            logger.info("\u6570\u636e\u6e05\u7406\u4efb\u52a1\u8868\u8fbe\u5f0f\u4f7f\u7528\u672c\u5730\u914d\u7f6e\u7684:{}", (Object)this.delTimeOutData);
            return this.delTimeOutData;
        }
        logger.info("\u4e1a\u52a1\u7f51\u5173\u6570\u636e\u6e05\u7406\u4efb\u52a1\u8868\u8fbe\u5f0f\u4f7f\u7528\u9ed8\u8ba4\u914d\u7f6e:{}", (Object)CRON_DELETE_JOB);
        return CRON_DELETE_JOB;
    }

    public void execute(JobExecutionContext context) {
        try {
            this.doActionOnCheckTable();
            this.doActionOnErrorRecordTable();
            this.doActionOnImageTable();
            this.cleanImageDirService.cleanImageDir(this.systemConfig.getImgSaveDays());
        }
        catch (Exception e) {
            logger.error("\u6e05\u7406\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Deprecated
    public void cleanImageData() {
        File failFile;
        this.baseDataHandlerService.deleteRecordsByIds("T_IMAGE_UPLOAD_INFO_", "CREATE_TIME", this.systemConfig.getImgSaveDays());
        File srcFile = new File(this.systemConfig.getImgFtpSrcPath());
        if (srcFile.exists()) {
            File[] needDelFiles;
            for (File file : needDelFiles = srcFile.listFiles((directory, name) -> !name.toUpperCase().endsWith(".JPG"))) {
                FileUtils.deleteQuietly((File)file);
            }
        }
        if ((failFile = new File(this.systemConfig.getImgProcessPath())).exists()) {
            File[] files = failFile.listFiles();
            BasicFileAttributes bAttributes = null;
            for (File file : files) {
                try {
                    bAttributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    Instant instant = bAttributes.lastModifiedTime().toInstant();
                    Date date1 = Date.from(instant);
                    Long days = (System.currentTimeMillis() - date1.getTime()) / 1000L / 60L / 60L / 24L;
                    if (days < (long)this.systemConfig.getImgSaveDays()) continue;
                    FileUtils.deleteQuietly((File)file);
                }
                catch (IOException e) {
                    logger.info("\u4e0a\u4f20\u5931\u8d25\u7684\u76ee\u5f55,\u6587\u4ef6{}\u6e05\u9664\u65f6\u51fa\u73b0\u5f02\u5e38:{}", (Object)file.getName(), (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean needClean(String timeStr, Date date, int days) {
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        ca.add(5, -days);
        Date time = ca.getTime();
        return timeStr.compareTo(DateUtil.formatYMD(time)) < 0;
    }

    public void doActionOnCheckTable() {
        int waybillCheckConfigTime = this.systemConfig.getDeviceRecordSaveDays();
        int threadCount = 10;
        if (threadCount > 0) {
            this.cleanJobDataByPartition(null, waybillCheckConfigTime, "T_DEVICE_SORT_RECORD_", threadCount);
        }
    }

    public void doActionOnImageTable() {
        int imageConfigTime = this.systemConfig.getImgSaveDays();
        this.cleanJobDataByPartition(null, imageConfigTime, "T_IMAGE_UPLOAD_INFO_", 3);
    }

    public void doActionOnErrorRecordTable() {
        int saveDays = this.systemConfig.getDeviceRecordSaveDays();
        String condition = " ${column} < DATE_SUB(CURRENT_TIMESTAMP,INTERVAL ${day} DAY) ".replace("${column}", "CREATE_TIME").replace("${day}", String.valueOf(saveDays));
        this.cleanDataByMultipleThreads(null, "T_DEVICE_ERROR_RECORD", 1000, false, condition, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDataByMultipleThreads(String lockType, String tableName, int recordCount, boolean needBackup, String condition, int threadCount) {
        logger.info("\u6b63\u5728\u4e3a\u5220\u9664\u8868" + tableName);
        if (this.latch == null) {
            this.latch = new CountDownLatch(threadCount);
        }
        for (int i = 0; i < threadCount; ++i) {
            String tbName = threadCount > 1 ? tableName + i : tableName;
            TimeOutDataCleanRunnable timeOutDataCleanRunnable = SpringUtil.getBean(TimeOutDataCleanRunnable.class);
            timeOutDataCleanRunnable.setLatch(this.latch);
            timeOutDataCleanRunnable.setCondition(condition);
            timeOutDataCleanRunnable.setNeedBackup(needBackup);
            timeOutDataCleanRunnable.setRecordCount(recordCount);
            timeOutDataCleanRunnable.setTableName(tbName);
            executor.submit(timeOutDataCleanRunnable);
        }
        try {
            this.latch.await();
            if (this.latch.getCount() == 0L) {
                logger.info("\u8ba1\u6570\u5668\u5b8c\u6210\u6b64\u6b21\u7ebf\u7a0b\u540c\u6b65");
            }
        }
        catch (InterruptedException e) {
            logger.info("CountDownLatch \u88ab\u4e2d\u65ad");
        }
        finally {
            this.latch = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanJobDataByPartition(String lockType, int saveDay, String tableName, int threadCount) {
        logger.info("threadCount = " + threadCount);
        boolean getLockOk = false;
        if (StringUtils.isBlank((CharSequence)lockType) || getLockOk) {
            logger.info("\u6b63\u5728\u4e3a\u5220\u9664\u8868" + tableName + "\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60");
            if (this.latch == null) {
                this.latch = new CountDownLatch(threadCount);
            }
            Set<String> deletePartition = PartitionUtils.getDeletePartition(saveDay);
            logger.info("\u4fdd\u5b58\u5929\u6570:{},\u5f85\u6e05\u7406\u7684\u5206\u533a:{}", (Object)saveDay, deletePartition);
            for (int i = 0; i < threadCount; ++i) {
                String tbName = threadCount > 1 ? tableName + i : tableName;
                int index = i;
                PartitionDataCleanRunnable partitionDataCleanRunnable = SpringUtil.getBean(PartitionDataCleanRunnable.class);
                partitionDataCleanRunnable.setLatch(this.latch);
                if (CollectionUtils.isNotEmpty(deletePartition)) {
                    Set<String> part = deletePartition.stream().map(s -> index + s).collect(Collectors.toSet());
                    partitionDataCleanRunnable.setPartition(part);
                }
                partitionDataCleanRunnable.setTableName(tbName);
                executor.submit(partitionDataCleanRunnable);
            }
            try {
                this.latch.await();
                if (this.latch.getCount() == 0L) {
                    logger.info("\u8ba1\u6570\u5668\u5b8c\u6210\u6b64\u6b21\u7ebf\u7a0b\u540c\u6b65");
                }
            }
            catch (InterruptedException e) {
                logger.info("CountDownLatch \u88ab\u4e2d\u65ad");
            }
            finally {
                this.latch = null;
            }
        }
    }
}

