/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule.job;

import cn.yto.config.SystemConfig;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.schedule.BaseJob;
import cn.yto.service.image.ExpImgUploadService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HandleSupplementImagesJob
extends BaseJob {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    private static AtomicBoolean atomicBoolean = new AtomicBoolean(Boolean.FALSE);
    @Value(value="${appJob.cron.supplementImage}")
    private String supplementImage;
    @Autowired
    private ExpImgUploadService imageUploadService;
    @Autowired
    private SystemConfig systemConfig;

    @Override
    public String getCronExpression() {
        return this.supplementImage;
    }

    public void execute(JobExecutionContext context) {
        if ("1".equals(this.systemConfig.getImgSupplySwitch()) && atomicBoolean.compareAndSet(false, true)) {
            try {
                this.imageUploadService.handleSupplmentData();
            }
            catch (Exception e) {
                logger.error("\u8865\u4f20\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
            }
            finally {
                atomicBoolean.set(false);
            }
        }
    }
}

