/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule.job;

import cn.yto.constants.MtyEnum;
import cn.yto.entity.busigateway.request.OptCommonReq;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.netty.client.manage.NettyClientManage;
import cn.yto.netty.client.tcp.TcpNettyClientObj;
import cn.yto.utils.AdapterHelperUtil;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;

public class HeartBeatTaskThread
extends Thread {
    private static final Logger logger = CustomLoggerFactory.HeartBeatLogger();
    private int iCount = 0;
    private int type;
    private OptCommonReq heart = new OptCommonReq();

    public HeartBeatTaskThread(int type) {
        this.type = type;
    }

    @Override
    public void run() {
        logger.info("\u5fc3\u8df3\u4efb\u52a1\u5f00\u59cb:");
        try {
            TcpNettyClientObj nettyClient = null;
            this.heart.setMty(MtyEnum.AUTO_DEVICE_SYSTEM_HEART_BEAT.getKey());
            this.heart.setTxId(MtyEnum.AUTO_DEVICE_SYSTEM_HEART_BEAT_RESP.getKey());
            nettyClient = this.type == 1 ? NettyClientManage.getInstance().getThreeCodeInfo_NettyClient() : (this.type == 2 ? NettyClientManage.getInstance().getSupplyExpress_NettyClient() : NettyClientManage.getInstance().getFallLattice_NettyClient());
            String jsonStr = JSONObject.toJSONString((Object)this.heart);
            String message = AdapterHelperUtil.renewItem(String.valueOf(jsonStr.length()), 8) + jsonStr;
            long currentTime = System.currentTimeMillis();
            long lostDataTime = 0L;
            lostDataTime = nettyClient != null ? (this.type == 1 ? nettyClient.getM_LostDataTime_ThreeCode() : (this.type == 2 ? nettyClient.getM_LostDataTime_SupplyExpress() : nettyClient.getM_LostDataTime_FallLattice())) : System.currentTimeMillis();
            logger.info("\u4e22\u5931\u6570\u636e\u65f6\u95f4\u4e3a:" + lostDataTime + "  \u5f53\u524d\u65f6\u95f4\u4e3a:" + currentTime);
            long diff = currentTime - lostDataTime;
            if (diff > 20000L) {
                logger.info("\u901a\u4fe1\u5df2\u65ad\u5f00\uff0c\u51c6\u5907\u91cd\u8fde\uff1a");
                nettyClient.Close();
                nettyClient.Connect();
                if (this.type == 1) {
                    NettyClientManage.getInstance().setThreeCodeInfo_NettyClient(nettyClient);
                } else if (this.type == 2) {
                    NettyClientManage.getInstance().setSupplyExpress_NettyClient(nettyClient);
                } else {
                    NettyClientManage.getInstance().setFallLattice_NettyClient(nettyClient);
                }
            }
            if (nettyClient != null) {
                nettyClient.SendData(logger, message);
            }
        }
        catch (Exception e) {
            logger.info("\u5fc3\u8df3\u4efb\u52a1\u8fd0\u884c\u53d1\u751f\u5f02\u5e38: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

