/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule.job;

import cn.yto.service.devicesort.DeviceRecordCleanService;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class PartitionDataCleanRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PartitionDataCleanRunnable.class);
    @Autowired
    private DeviceRecordCleanService deviceRecordCleanService;
    private String tableName;
    private CountDownLatch latch;
    private Set<String> partition;

    public Set<String> getPartition() {
        return this.partition;
    }

    public void setPartition(Set<String> partition) {
        this.partition = partition;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    public void run() {
        try {
            this.deviceRecordCleanService.dropPartition(this.tableName, this.partition);
        }
        finally {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }
}

