/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.schedule.job;

import cn.yto.service.devicesort.DeviceRecordCleanService;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class TimeOutDataCleanRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(TimeOutDataCleanRunnable.class);
    @Autowired
    private DeviceRecordCleanService deviceRecordCleanService;
    private String tableName;
    private int recordCount;
    private boolean needBackup;
    private String condition;
    private CountDownLatch latch;

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void setNeedBackup(boolean needBackup) {
        this.needBackup = needBackup;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public void run() {
        try {
            this.deviceRecordCleanService.doActions(this.tableName, this.recordCount, this.needBackup, this.condition);
        }
        finally {
            if (this.latch != null) {
                this.latch.countDown();
            }
        }
    }
}

