/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.service;

import cn.yto.constants.ErrorTypeEnum;
import cn.yto.entity.DeviceErrorRecord;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.mapper.IDeviceErrorRecordMapper;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FaultProcService
implements CommandLineRunner {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static final int QUEUE_SIZE = 10000;
    private final BlockingQueue<DeviceErrorRecord> deviceErrorRecordQueue = new ArrayBlockingQueue<DeviceErrorRecord>(10000);
    @Autowired
    private IDeviceErrorRecordMapper deviceErrorRecordMapper;

    public void run(String ... args) throws Exception {
        Thread t = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        DeviceErrorRecord errorRecord = this.deviceErrorRecordQueue.take();
                        this.handleErrorReq(errorRecord);
                    }
                }
                catch (InterruptedException e) {
                    logger.error("\u6545\u969c\u5904\u7406\u7ebf\u7a0b\u4e2d\u65ad\u5f02\u5e38", (Throwable)e);
                    continue;
                }
                break;
            }
        });
        t.setName("Thread-fault");
        t.start();
    }

    private void handleErrorReq(DeviceErrorRecord req) {
        try {
            if (ErrorTypeEnum.WRONG_SUPPLY.getCode().equals(req.getType())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().and(StringUtils.isNotBlank((CharSequence)req.getWaybillNo()), i -> (LambdaQueryWrapper)i.eq(DeviceErrorRecord::getWaybillNo, (Object)req.getWaybillNo()))).and(StringUtils.isNotBlank((CharSequence)req.getDeviceIp()), i -> (LambdaQueryWrapper)i.eq(DeviceErrorRecord::getDeviceIp, (Object)req.getDeviceIp()))).and(Objects.nonNull(req.getCreateTime()), i -> (LambdaQueryWrapper)i.eq(DeviceErrorRecord::getCreateTime, (Object)req.getCreateTime()));
                List deviceErrorRecords = this.deviceErrorRecordMapper.selectList((Wrapper)queryWrapper);
                if (CollectionUtils.isEmpty((Collection)deviceErrorRecords)) {
                    this.deviceErrorRecordMapper.insert(req);
                }
                return;
            }
            this.deviceErrorRecordMapper.insert(req);
        }
        catch (Exception e) {
            logger.error("\u63d2\u5165\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }

    public void proc(DeviceErrorRecord req) {
        if (!this.deviceErrorRecordQueue.offer(req)) {
            logger.info("\u6545\u969c\u4e0a\u4f20\u961f\u5217\u5df2\u6ee1 \u672c\u6b21\u4e0d\u4e0a\u4f20 {}", (Object)JSONObject.toJSONString((Object)req));
        }
        logger.info("\u5f53\u524d\u6545\u969c\u961f\u5217\u4e2d\u6709\u672a\u4e0a\u4f20\u6570\u636e:" + this.deviceErrorRecordQueue.size());
    }
}

