/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.service.lattice;

import cn.yto.cache.LatticeBindCacheService;
import cn.yto.cache.LatticeStatusCacheService;
import cn.yto.cache.NewLatticeCacheService;
import cn.yto.communication.monitor.send.MonitorGateWayComm;
import cn.yto.communication.plc.receive.ReceiveDeviceStatusCmdComm;
import cn.yto.config.SortingConfig;
import cn.yto.config.WcsClientConfig;
import cn.yto.config.WcsTcpServerConfig;
import cn.yto.constants.CFTypeEnum;
import cn.yto.constants.MtyEnum;
import cn.yto.entity.AllLatticeStatusDataReq;
import cn.yto.entity.DeviceSortRecord;
import cn.yto.entity.ExpLatticeBindEntity;
import cn.yto.entity.LatticeLockRecord;
import cn.yto.entity.LatticeStatus;
import cn.yto.entity.busigateway.response.WrongSortQueryReq;
import cn.yto.entity.monitor.CFAnalysisResult;
import cn.yto.entity.monitor.CFSummary;
import cn.yto.entity.monitor.CartStatistics;
import cn.yto.entity.monitor.LatticeStatistics;
import cn.yto.entity.monitor.SingleLatticeReq;
import cn.yto.entity.monitor.TableStatistics;
import cn.yto.entity.monitor.UnLockLatticeReq;
import cn.yto.entity.monitor.WrongBuildPackDetail;
import cn.yto.entity.monitor.WrongBuildPackDto;
import cn.yto.entity.monitor.WrongBuildPackReq;
import cn.yto.entity.monitor.WrongBuildPackVO;
import cn.yto.log.CustomLoggerFactory;
import cn.yto.mapper.ILatticeLockRecordMapper;
import cn.yto.service.devicesort.DeviceSortRecordService;
import cn.yto.utils.AdapterHelperUtil;
import cn.yto.utils.BeanUtil;
import cn.yto.utils.DateUtil;
import cn.yto.utils.ExpUtils;
import cn.yto.utils.LatticeUtils;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.Property;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class LatticeLockService {
    private static final Logger logger = CustomLoggerFactory.OperateLogger();
    @Autowired
    private ILatticeLockRecordMapper latticeLockRecordMapper;
    @Autowired
    private WcsTcpServerConfig wcsTcpServerConfig;
    @Autowired
    private WcsClientConfig wcsClientConfig;
    @Autowired
    private LatticeBindCacheService latticeBindCacheService;
    @Autowired
    private SortingConfig sortingConfig;
    @Autowired
    DeviceSortRecordService deviceSortRecordService;
    @Autowired
    NewLatticeCacheService latticeCacheService;
    @Autowired
    private MonitorGateWayComm monitorGateWayComm;

    @Transactional
    public int insertLockRecord(LatticeLockRecord latticeLockRecord) {
        return this.latticeLockRecordMapper.insert(latticeLockRecord);
    }

    public int updateUnlockRecord(LatticeLockRecord latticeLockRecord) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(LatticeLockRecord::getLatticeNo, (Object)latticeLockRecord.getLatticeNo())).eq(LatticeLockRecord::getStatus, (Object)"1")).isNull(LatticeLockRecord::getLatticeUnlockTime)).le(LatticeLockRecord::getLatticeLockTime, (Object)latticeLockRecord.getLatticeUnlockTime())).orderByDesc((Object[])new Property[]{LatticeLockRecord::getCreateTime});
        List latticeLockRecords = this.latticeLockRecordMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)latticeLockRecords)) {
            latticeLockRecord.setCreateTime(new Date());
            return this.latticeLockRecordMapper.insert(latticeLockRecord);
        }
        LatticeLockRecord needUpdate = (LatticeLockRecord)latticeLockRecords.get(0);
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(LatticeLockRecord::getId, (Object)needUpdate.getId());
        latticeLockRecord.setUpdateTime(new Date());
        return this.latticeLockRecordMapper.update(latticeLockRecord, (Wrapper)updateWrapper);
    }

    public List<LatticeLockRecord> selectList(QueryWrapper<LatticeLockRecord> queryWrapper) {
        return this.latticeLockRecordMapper.selectList((Wrapper)queryWrapper);
    }

    public void sendLatticeUnlockToMonitor(LatticeLockRecord latticeLockRecord, ExpLatticeBindEntity latticeBindEntity) {
        Long lockTime;
        String latticeNo = latticeLockRecord.getLatticeNo();
        if (ExpUtils.isBlank(latticeNo)) {
            return;
        }
        Date latticeLockTime = latticeLockRecord.getLatticeLockTime();
        if (Objects.isNull(latticeLockTime) && Objects.isNull(lockTime = LatticeStatusCacheService.lockStatusCache.get(Integer.parseInt(latticeNo)))) {
            return;
        }
        lockTime = latticeLockTime.getTime();
        UnLockLatticeReq request = new UnLockLatticeReq();
        request.setWcsIp(this.wcsTcpServerConfig.getWcsIp());
        request.setWcsPort(String.valueOf(this.wcsTcpServerConfig.getWcsTcpPort()));
        request.setOpCode(MtyEnum.LATTICE_UNLOCK_UPLOAD.getKey());
        long lockLatticeTime = (latticeLockRecord.getLatticeUnlockTime().getTime() - lockTime) / 1000L;
        if (lockLatticeTime < 0L) {
            logger.info("\u5f53\u524d\u683c\u53e3{} \u9501\u683c\u65f6\u957f:{}\u5c0f\u4e8e\u96f6, \u4e0d\u8fdb\u884c\u9501\u683c\u65f6\u957f\u4e0a\u4f20", (Object)latticeNo, (Object)lockLatticeTime);
            return;
        }
        if (lockLatticeTime >= 3600L) {
            logger.info("\u5f53\u524d\u683c\u53e3{} \u9501\u683c\u65f6\u95f4\u8d85\u8fc7{}s, \u4e0d\u8fdb\u884c\u9501\u683c\u65f6\u957f\u4e0a\u4f20", (Object)latticeNo, (Object)lockLatticeTime);
            return;
        }
        if (lockLatticeTime > 180L && (Objects.isNull(ReceiveDeviceStatusCmdComm.currentDevStartTime) || System.currentTimeMillis() <= 1800000L + ReceiveDeviceStatusCmdComm.currentDevStartTime)) {
            logger.info("\u5f53\u524d\u683c\u53e3{} \u6309180s\u9501\u683c\u65f6\u957f\u4e0a\u4f20", (Object)latticeNo);
            lockLatticeTime = 180L;
        }
        request.setLockLatticeLong(lockLatticeTime);
        request.setLatticeNo(latticeNo);
        request.setMode(1);
        request.setUnLockLatticeTime(latticeLockRecord.getLatticeUnlockTime().getTime());
        if (latticeBindEntity != null) {
            String bindUserCode = latticeBindEntity.getBindUserCode();
            request.setEmpCode(bindUserCode);
            latticeLockRecord.setEmpCode(bindUserCode);
            Date createTime = latticeBindEntity.getCreateTime();
            request.setLatticeBindTime(createTime.getTime());
            latticeLockRecord.setPackageBindTime(createTime);
            String packageNo = latticeBindEntity.getPackageNo();
            request.setPackageNo(packageNo);
            latticeLockRecord.setPackageNo(packageNo);
        }
        latticeLockRecord.setUpdateTime(new Date());
        this.monitorGateWayComm.sendMsgToMonitor(JSONObject.toJSONString((Object)request));
    }

    public void uploadAllLatticeStatus() {
        AllLatticeStatusDataReq allLatticeStatusDataReq = new AllLatticeStatusDataReq();
        allLatticeStatusDataReq.setOpCode(MtyEnum.ALL_LATTICE_STATUS_UPLOAD.getKey());
        allLatticeStatusDataReq.setCreateTime(System.currentTimeMillis());
        allLatticeStatusDataReq.setWcsIp(this.wcsTcpServerConfig.getWcsIp());
        allLatticeStatusDataReq.setWcsPort(String.valueOf(this.wcsTcpServerConfig.getWcsTcpPort()));
        List<Integer> lockLattices = LatticeStatusCacheService.lockLattices;
        Integer latticeNos = this.sortingConfig.getLatticeNum();
        ArrayList<LatticeStatus> latticeList = new ArrayList<LatticeStatus>();
        for (int i = 1; i <= latticeNos; ++i) {
            LatticeStatus latticeStatus = new LatticeStatus();
            if (lockLattices.contains(i)) {
                latticeStatus.setLockStatus("1");
            }
            latticeStatus.setLatticeNo(String.format("%03d", i));
            latticeList.add(latticeStatus);
        }
        allLatticeStatusDataReq.setLatticeList(latticeList);
        this.monitorGateWayComm.sendMsgToMonitor(JSONObject.toJSONString((Object)allLatticeStatusDataReq));
    }

    @Async
    public void uploadSingleLatticeStatus(String latticeNo, String type) {
        SingleLatticeReq singleLatticeReq = new SingleLatticeReq();
        try {
            if ("1".equals(type)) {
                singleLatticeReq.setOpCode(MtyEnum.LATTICE_LOCK_UPLOAD.getKey());
                long now = System.currentTimeMillis();
                singleLatticeReq.setLockLatticeTime(now);
                singleLatticeReq.setMode("1");
                LatticeStatusCacheService.lockStatusCache.put(Integer.parseInt(latticeNo), now);
            } else {
                singleLatticeReq.setOpCode(MtyEnum.SINGLE_LATTICE_UNLOCK_UPLOAD.getKey());
                singleLatticeReq.setUnLockLatticeTime(System.currentTimeMillis());
                LatticeStatusCacheService.lockStatusCache.remove(Integer.parseInt(latticeNo));
            }
            singleLatticeReq.setWcsIp(this.wcsTcpServerConfig.getWcsIp());
            singleLatticeReq.setLatticeNo(latticeNo);
            singleLatticeReq.setWcsPort(String.valueOf(this.wcsTcpServerConfig.getWcsTcpPort()));
            this.monitorGateWayComm.sendMsgToMonitor(JSONObject.toJSONString((Object)singleLatticeReq));
        }
        catch (Exception e) {
            logger.error("\u589e\u91cf\u4e0a\u4f20\u683c\u53e3\u72b6\u6001\u65f6\uff0c\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public List<WrongBuildPackDetail> analyizeCFData(WrongSortQueryReq sortQueryReq) {
        List<WrongBuildPackDto> wrongBuildPackDtos = this.queryCFData(sortQueryReq.getStatDate(), sortQueryReq.getOrgCode());
        ArrayList<WrongBuildPackDetail> buildPackDetails = new ArrayList<WrongBuildPackDetail>();
        wrongBuildPackDtos.stream().forEach(e -> {
            WrongBuildPackDetail packDetal = new WrongBuildPackDetail();
            BeanUtil.copy((Object)e, (Object)packDetal);
            String waybillNo = e.getWaybillNo();
            DeviceSortRecord deviceSortRecord = this.deviceSortRecordService.searchDeviceSortByWaybillNo(waybillNo, "2");
            if (Objects.nonNull(deviceSortRecord)) {
                packDetal.setTableNo(deviceSortRecord.getLayer() + "-" + deviceSortRecord.getTableNo());
                packDetal.setCartNo(deviceSortRecord.getLayer() + "-" + deviceSortRecord.getCartNo());
                packDetal.setWeight(deviceSortRecord.getWeight());
                packDetal.setPlanLatticeNo(deviceSortRecord.getLatticeNoReal());
                packDetal.setPackTime(DateUtil.formatYMDHMSS(deviceSortRecord.getLatticeTime()));
                String unpackOrgCode = e.getUnpackOrgCode();
                String realLatticeNo = this.latticeCacheService.getLatticeNoByDestOrgCode(sortQueryReq.getDeviceId() + "-" + sortQueryReq.getSchemeNo(), unpackOrgCode);
                packDetal.setRealLatticeNo(realLatticeNo);
                String wrongType = LatticeUtils.getWrongType(packDetal.getPlanLatticeNo(), realLatticeNo);
                packDetal.setWrongType(wrongType);
                packDetal.setContainerNo(deviceSortRecord.getContainerNo());
                buildPackDetails.add(packDetal);
            } else {
                logger.info("\u6839\u636e\u5355\u53f7:{},\u672a\u67e5\u5230\u8bb0\u5f55", (Object)waybillNo);
            }
        });
        return buildPackDetails;
    }

    public CFAnalysisResult calcWrongSort(WrongSortQueryReq sortQueryReq) {
        CFAnalysisResult cfAnalysisResult = new CFAnalysisResult();
        List<WrongBuildPackDetail> wrongBuildPackDetails = this.analyizeCFData(sortQueryReq);
        if (CollectionUtils.isEmpty(wrongBuildPackDetails)) {
            return cfAnalysisResult;
        }
        cfAnalysisResult.setWrongBuildPackDetails(wrongBuildPackDetails);
        Map<String, Map<String, Long>> tableMap = wrongBuildPackDetails.stream().collect(Collectors.groupingBy(WrongBuildPackDetail::getTableNo, Collectors.groupingBy(WrongBuildPackDetail::getWrongType, Collectors.counting())));
        ArrayList<TableStatistics> tableResult = new ArrayList<TableStatistics>();
        tableMap.forEach((k, v) -> {
            TableStatistics tableStatistics = new TableStatistics();
            tableStatistics.setTableNo((String)k);
            long wrongSortNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_ERROR.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_ERROR.getMsg());
            long latticeForWardNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_FORWARD.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_FORWARD.getMsg());
            long latticeBackWardNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_BACKWARD.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_BACKWARD.getMsg());
            long floatSortNums = latticeForWardNums + latticeBackWardNums;
            tableStatistics.setWrongSortNums(String.valueOf(wrongSortNums));
            tableStatistics.setFloatLatticeNums(String.valueOf(floatSortNums));
            tableResult.add(tableStatistics);
        });
        Map<String, Map<String, Long>> cartMap = wrongBuildPackDetails.stream().collect(Collectors.groupingBy(WrongBuildPackDetail::getCartNo, Collectors.groupingBy(WrongBuildPackDetail::getWrongType, Collectors.counting())));
        ArrayList<CartStatistics> cartResult = new ArrayList<CartStatistics>();
        cartMap.forEach((k, v) -> {
            CartStatistics cartStatistics = new CartStatistics();
            cartStatistics.setCartNo((String)k);
            long wrongSortNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_ERROR.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_ERROR.getMsg());
            long latticeForWardNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_FORWARD.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_FORWARD.getMsg());
            long latticeBackWardNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_BACKWARD.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_BACKWARD.getMsg());
            long floatSortNums = latticeForWardNums + latticeBackWardNums;
            cartStatistics.setWrongSortNums(String.valueOf(wrongSortNums));
            cartStatistics.setFloatLatticeNums(String.valueOf(floatSortNums));
            cartResult.add(cartStatistics);
        });
        Map<String, Map<String, Long>> latticeMap = wrongBuildPackDetails.stream().collect(Collectors.groupingBy(WrongBuildPackDetail::getPlanLatticeNo, Collectors.groupingBy(WrongBuildPackDetail::getWrongType, Collectors.counting())));
        ArrayList<LatticeStatistics> latticeResult = new ArrayList<LatticeStatistics>();
        latticeMap.forEach((k, v) -> {
            LatticeStatistics latticeStatistic = new LatticeStatistics();
            latticeStatistic.setLatticeNo((String)k);
            long wrongSortNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_ERROR.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_ERROR.getMsg());
            long latticeForWardNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_FORWARD.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_FORWARD.getMsg());
            long latticeBackWardNums = Objects.isNull(v.get(CFTypeEnum.LATTICE_BACKWARD.getMsg())) ? 0L : (Long)v.get(CFTypeEnum.LATTICE_BACKWARD.getMsg());
            long floatSortNums = latticeForWardNums + latticeBackWardNums;
            latticeStatistic.setWrongSortNums(String.valueOf(wrongSortNums));
            latticeStatistic.setFloatLatticeNums(String.valueOf(floatSortNums));
            latticeResult.add(latticeStatistic);
        });
        cfAnalysisResult.setLatticeResult(latticeResult);
        cfAnalysisResult.setTableResult(tableResult);
        cfAnalysisResult.setCartResult(cartResult);
        ArrayList<CFSummary> cfSummaryResult = new ArrayList<CFSummary>();
        Map<String, Long> wrongTypeMap = wrongBuildPackDetails.stream().collect(Collectors.groupingBy(WrongBuildPackDetail::getWrongType, Collectors.counting()));
        int sum = wrongBuildPackDetails.size();
        CFSummary total = new CFSummary();
        total.setCfType("\u603b\u8ba1");
        total.setCfCount(String.valueOf(sum));
        total.setCfRatio("100%");
        wrongTypeMap.forEach((k, v) -> {
            CFSummary summary = new CFSummary();
            summary.setCfType((String)k);
            summary.setCfCount(String.valueOf(v));
            double ratio = (double)v.longValue() / ((double)sum * 1.0) * 100.0;
            String ratioStr = String.format("%.2f%%", ratio);
            summary.setCfRatio(ratioStr);
            cfSummaryResult.add(summary);
        });
        cfSummaryResult.add(total);
        cfAnalysisResult.setCfSummaryResult(cfSummaryResult);
        return cfAnalysisResult;
    }

    public List<WrongBuildPackDto> queryCFData(String rptDate, String orgCode) {
        WrongBuildPackReq buildPackReq = new WrongBuildPackReq();
        buildPackReq.setOpCode(MtyEnum.OP_CODE_WRONG_BUILD_PACK_QUERY.getKey());
        buildPackReq.setPackOrgCode(orgCode);
        buildPackReq.setRptDate(rptDate);
        ArrayList<WrongBuildPackDto> list = new ArrayList<WrongBuildPackDto>();
        try (Socket socket = new Socket(this.wcsClientConfig.getMonitorIp(), (int)this.wcsClientConfig.getMonitorPort());
             PrintWriter output = new PrintWriter(socket.getOutputStream(), true);
             BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream(), "GBK"));){
            String response;
            socket.setSoTimeout(10000);
            String requestJson = JSONObject.toJSONString((Object)buildPackReq);
            String message = AdapterHelperUtil.renewItem(String.valueOf(requestJson.length()), 8) + requestJson;
            output.println(message);
            while ((response = input.readLine()) != null) {
                WrongBuildPackVO wrongBuildPackVO;
                logger.info("\u63a5\u6536\u5230\u7684\u9519\u5efa\u5305\u6570\u636e:{} ", (Object)response);
                if (!response.contains("opCode") || !Objects.nonNull(wrongBuildPackVO = (WrongBuildPackVO)JSONObject.parseObject((String)response.substring(8), WrongBuildPackVO.class))) continue;
                if (wrongBuildPackVO.isEnd()) {
                    logger.info("\u63a5\u6536\u5230\u7684\u9519\u5efa\u5305\u6570\u636e\u6709end\u6807\u8bc6,\u9000\u51fa...");
                    if (!Objects.nonNull(wrongBuildPackVO.getList())) break;
                    list.addAll(wrongBuildPackVO.getList());
                    break;
                }
                list.addAll(wrongBuildPackVO.getList());
            }
            logger.info("\u63a5\u6536\u5230\u7684\u9519\u5efa\u5305\u6570\u636e\u603b\u5927\u5c0f:{}", (Object)list.size());
        }
        catch (IOException e) {
            logger.error("TCP\u6d41\u5904\u7406\u65f6,\u51fa\u73b0\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
        }
        return list;
    }
}

