/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.utils.Base64Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class AESUtils {
    private static final String ALGORITHM = "AES";
    private static final int KEY_SIZE = 128;
    private static final int CACHE_SIZE = 1024;

    public static String getSecretKey() throws Exception {
        return AESUtils.getSecretKey(null);
    }

    public static String getSecretKey(String seed) throws Exception {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM);
        SecureRandom secureRandom = seed != null && !"".equals(seed) ? new SecureRandom(seed.getBytes()) : new SecureRandom();
        keyGenerator.init(128, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        return Base64Utils.encodeToString(secretKey.getEncoded());
    }

    public static byte[] encrypt(byte[] data, String key) throws Exception {
        Key k = AESUtils.toKey(Base64Utils.decodeToByteArray(key.getBytes()));
        byte[] raw = k.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, secretKeySpec);
        return cipher.doFinal(data);
    }

    public static void encryptFile(String key, String sourceFilePath, String destFilePath) throws Exception {
        File sourceFile = new File(sourceFilePath);
        File destFile = new File(destFilePath);
        if (sourceFile.exists() && sourceFile.isFile()) {
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            destFile.createNewFile();
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            Key k = AESUtils.toKey(Base64Utils.decodeToByteArray(key.getBytes()));
            byte[] raw = k.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, secretKeySpec);
            CipherInputStream cin = new CipherInputStream(in, cipher);
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = cin.read(cache)) != -1) {
                ((OutputStream)out).write(cache, 0, nRead);
                out.flush();
            }
            ((OutputStream)out).close();
            cin.close();
            ((InputStream)in).close();
        }
    }

    public static byte[] decrypt(byte[] data, String key) throws Exception {
        Key k = AESUtils.toKey(Base64Utils.decodeToByteArray(key.getBytes()));
        byte[] raw = k.getEncoded();
        SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, secretKeySpec);
        return cipher.doFinal(data);
    }

    public static void decryptFile(String key, String sourceFilePath, String destFilePath) throws Exception {
        File sourceFile = new File(sourceFilePath);
        File destFile = new File(destFilePath);
        if (sourceFile.exists() && sourceFile.isFile()) {
            if (!destFile.getParentFile().exists()) {
                destFile.getParentFile().mkdirs();
            }
            destFile.createNewFile();
            FileInputStream in = new FileInputStream(sourceFile);
            FileOutputStream out = new FileOutputStream(destFile);
            Key k = AESUtils.toKey(Base64Utils.decodeToByteArray(key.getBytes()));
            byte[] raw = k.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, secretKeySpec);
            CipherOutputStream cout = new CipherOutputStream(out, cipher);
            byte[] cache = new byte[1024];
            int nRead = 0;
            while ((nRead = in.read(cache)) != -1) {
                cout.write(cache, 0, nRead);
                cout.flush();
            }
            cout.close();
            out.close();
            in.close();
        }
    }

    private static Key toKey(byte[] key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key, ALGORITHM);
        return secretKey;
    }

    public static void main(String[] args) throws Exception {
        File imgFile = new File("D:\\20220712093100594_072417728.jpg");
        String pasww = "123456789zyw";
        byte[] bytes = FileUtils.readFileToByteArray((File)imgFile);
        String secretKey = AESUtils.getSecretKey(pasww);
        byte[] encrypt = AESUtils.encrypt(bytes, secretKey);
        byte[] bytes2 = FileUtils.readFileToByteArray((File)imgFile);
        byte[] decryptByte = AESUtils.decrypt(bytes2, AESUtils.getSecretKey(pasww));
        System.out.println(bytes == decryptByte);
    }
}

