/*
 * Decompiled with CFR 0.152.
 */
package cn.yto.utils;

import cn.yto.log.CustomLoggerFactory;
import cn.yto.utils.ExpUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;

public class CMDUtil {
    private static final Logger logger = CustomLoggerFactory.SystemLogger();
    public static List<String> TCP_NOT_START_STATUS = Arrays.asList("ESTABLISHED", "LISTENING", "LISTEN");
    public static List<String> TCP_START_STATUS = Arrays.asList("SYN_SENT", "TIME_WAIT");

    private static String exec(String command, String ... params) {
        StringBuilder commandParams = new StringBuilder();
        if (params != null) {
            for (String param : params) {
                commandParams.append(" " + param);
            }
        }
        try {
            String line;
            StringBuilder stringBuilder = new StringBuilder();
            String cmd = command + commandParams;
            logger.info("cmd : " + cmd);
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("GBK")));
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line + "\n");
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u811a\u672c\u51fa\u9519\u4e86...", (Throwable)e);
            return null;
        }
    }

    public static String excuteCMDCommand(String cmdCommand, String ... params) {
        return CMDUtil.exec(cmdCommand, params);
    }

    public static String excuteBatFile(String batPath, String ... params) {
        logger.info("bat\u6587\u4ef6\u8def\u5f84:" + batPath);
        String cmdCommand = "cmd /c start cmd.exe /c " + batPath;
        return CMDUtil.exec(cmdCommand, params);
    }

    public static String excuteShFile(String shPath, String ... params) {
        String cmdCommand = "sh " + shPath;
        return CMDUtil.exec(cmdCommand, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPID(String port) {
        BufferedReader br = null;
        String pid = null;
        try {
            String[] args = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0 ? new String[]{"/bin/sh", "/c", "netstat -tunlp|grep", port} : new String[]{"cmd.exe", "/c", "netstat -aon|findstr", port};
            InputStream is = Runtime.getRuntime().exec(args).getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String temp = br.readLine();
            logger.info("---------\u83b7\u53d6pid---------{}", (Object)temp);
            if (temp != null) {
                String[] strs = temp.split("\\s");
                pid = strs[strs.length - 1];
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return pid;
    }

    public static boolean checkProcessCanUsePort(String port) {
        return CMDUtil.checkProcessCanUsePortWithRetry(port, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkProcessCanUsePortWithRetry(String port, int retryCount) {
        BufferedReader br = null;
        InputStream is = null;
        String pid = null;
        try {
            String[] args = System.getProperty("os.name").toLowerCase().indexOf("linux") >= 0 ? new String[]{"/bin/sh", "/c", "netstat -tunlp|grep", ":" + port} : new String[]{"cmd.exe", "/c", "netstat -aon|findstr", ":" + port};
            is = Runtime.getRuntime().exec(args).getInputStream();
            br = new BufferedReader(new InputStreamReader(is));
            String temp = br.readLine();
            logger.info("---------\u83b7\u53d6pid info---------{}", (Object)temp);
            if (ExpUtils.isBlank(temp)) {
                boolean bl = true;
                CMDUtil.closeStreams(br, is);
                return bl;
            }
            String[] strs = temp.split("\\s");
            pid = strs[strs.length - 1];
            logger.info("pid:{}", (Object)pid);
            if (ExpUtils.isBlank(pid)) {
                boolean bl = false;
                CMDUtil.closeStreams(br, is);
                return bl;
            }
            for (String status : TCP_NOT_START_STATUS) {
                if (!temp.contains(status)) continue;
                boolean bl = false;
                CMDUtil.closeStreams(br, is);
                return bl;
            }
            for (String status : TCP_START_STATUS) {
                if (temp.contains(status)) {
                    logger.info("{} \u5305\u542bstatus\uff1a{} \u53ef\u542f\u52a8\u7aef\u53e3", (Object)temp, (Object)status);
                    boolean bl = true;
                    CMDUtil.closeStreams(br, is);
                    return bl;
                }
                logger.info("{} \u4e0d\u5305\u542bstatus\uff1a{}", (Object)temp, (Object)status);
            }
            if (retryCount < 3) {
                logger.info("\u4f11\u77205\u79d2\u540e\u91cd\u65b0\u67e5\u770b\u7aef\u53e3:{}\u72b6\u6001, \u5f53\u524d\u91cd\u8bd5\u6b21\u6570\uff1a{}", (Object)port, (Object)(retryCount + 1));
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error("\u4f11\u7720\u88ab\u4e2d\u65ad", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                CMDUtil.closeStreams(br, is);
                boolean bl = CMDUtil.checkProcessCanUsePortWithRetry(port, retryCount + 1);
                CMDUtil.closeStreams(br, is);
                return bl;
            }
            logger.warn("\u7aef\u53e3{}\u68c0\u67e5\u91cd\u8bd5\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650\uff0c\u8fd4\u56de\u9ed8\u8ba4\u503ctrue", (Object)port);
            boolean bl = true;
            CMDUtil.closeStreams(br, is);
            return bl;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return true;
        }
        finally {
            CMDUtil.closeStreams(br, is);
        }
    }

    public static void closeStreams(BufferedReader br, InputStream is) {
        if (br != null) {
            try {
                br.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95edBufferedReader\u5931\u8d25", (Throwable)e);
            }
        }
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.error("\u5173\u95edInputStream\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

